/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.Option;
import java.util.UUID;
import org.apache.log4j.Logger;

public class LayoutOption
implements Option {
    public static final String ATTRIBUTE_NAME = "name";
    private String key;
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_UUID = "id";
    public static final String ATTRIBUTE_PADDING = "padding";
    public static final String ATTRIBUTE_ORGANICNESS = "organicness";
    private static final int DEFAULT_PADDING = 2;
    private static final int DEFAULT_ORGANIC = 0;
    private String name = "none";
    private UUID uuid = UUID.randomUUID();
    private int padding = 2;
    private int organicness = 0;
    private boolean userOption = false;
    private boolean hidden;
    private boolean unlicensed;
    private static final Logger LOGGER = Logger.getLogger(LayoutOption.class);

    public final String getName() {
        return this.name;
    }

    public final void setName(String nameIn) {
        this.validateSetString(nameIn);
        this.name = nameIn;
    }

    public final String getI18nKey() {
        String value;
        if (this.key == null) {
            value = this.name;
            LOGGER.warn((Object)("Option.getI18nKey() called when i18n key = null, userDefined = " + this.userOption + ", " + this));
        } else {
            value = this.key;
        }
        return value;
    }

    public final void setI18nKey(String keyIn) {
        this.validateSetString(keyIn);
        this.key = keyIn;
    }

    private void validateSetString(String string) {
        if (string == null || "".equals(string.trim())) {
            throw new IllegalArgumentException("Can't specify an empty string");
        }
    }

    public final int getPadding() {
        return this.padding;
    }

    public final void setPadding(int paddingIn) {
        this.validateSetPadding(paddingIn);
        this.padding = paddingIn;
    }

    public final int getOrganicness() {
        return this.organicness;
    }

    public final void setOrganicness(int organicnessIn) {
        this.validateSetOrganicness(organicnessIn);
        this.organicness = organicnessIn;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    public final void setUUID(UUID idIn) {
        this.validateSetId(idIn);
        this.uuid = idIn;
    }

    private void validateSetId(UUID idIn) {
        if (idIn == null) {
            throw new IllegalArgumentException("Invlaid Layout Option id!");
        }
    }

    private void validateSetPadding(int value) {
        boolean minRange = true;
        int maxRange = 5;
        if (value < 1 || value > 5) {
            throw new IllegalArgumentException("Layout padding should be between 1 to 5");
        }
    }

    private void validateSetOrganicness(int value) {
        boolean minRange = false;
        int maxRange = 6;
        if (value < 0 || value > 6) {
            throw new IllegalArgumentException("Layout organicness should be between 0 to 6");
        }
    }

    public final boolean isUserDefined() {
        return this.userOption;
    }

    public final void setUserDefined(boolean userDefined) {
        this.userOption = userDefined;
    }

    public final void setHidden(boolean hiddenIn) {
        this.hidden = hiddenIn;
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    public final boolean isUnlicensed() {
        return this.unlicensed;
    }

    public final void setUnlicensed(boolean unlicensedIn) {
        this.unlicensed = unlicensedIn;
    }

    public final String toString() {
        String message = "%s[uuid=%s, name=%s, userDefined=%s, key=%s, hidden=%s, unlicensed=%s]";
        return String.format("%s[uuid=%s, name=%s, userDefined=%s, key=%s, hidden=%s, unlicensed=%s]", this.getClass().getSimpleName(), this.uuid, this.name, this.userOption, this.key, this.hidden, this.unlicensed);
    }
}

