/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import java.io.InputStream;

public class MindMapImage {
    private final InputStream imageStream;
    private double width;
    private double height;
    private ImageType imageType = ImageType.IMAGE;

    public MindMapImage(InputStream imageStreamIn, double widthIn, double heightIn) {
        this.validateMindMapImage(imageStreamIn, widthIn, heightIn);
        this.imageStream = imageStreamIn;
        this.width = widthIn;
        this.height = heightIn;
    }

    public MindMapImage(double widthIn, double heightIn) {
        this.width = widthIn;
        this.height = heightIn;
        this.imageStream = null;
    }

    public MindMapImage(InputStream imageStreamIn, ImageType imageTypeIn, double widthIn, double heightIn) {
        this(imageStreamIn, widthIn, heightIn);
        this.imageType = imageTypeIn;
        this.width = widthIn;
        this.height = heightIn;
    }

    private void validateMindMapImage(InputStream imageStreamIn, double widthIn, double heightIn) {
        if (imageStreamIn == null) {
            throw new IllegalArgumentException("Image stream should not be null");
        }
        if (widthIn <= 0.0 || heightIn <= 0.0) {
            throw new IllegalArgumentException(String.format("widthIn(%s) and heightIn(%s) must be greater than zero", widthIn, heightIn));
        }
    }

    public final InputStream getImageStream() {
        return this.imageStream;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final ImageType getImageType() {
        return this.imageType;
    }

    public final void setWidth(double widthIn) {
        this.width = widthIn;
    }

    public final void setHeight(double heightIn) {
        this.height = heightIn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        ICO,
        IMAGE;

    }
}

