/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.util.XMLUtils;
import com.thinkbuzan.gaia.model.properties.IProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Notes
implements IProperty,
Cloneable {
    private static final long serialVersionUID = 5246615927165618468L;
    public static final String NOTES_KEY = "com.thinkbuzan.gaia.cell.notes";
    private static final String NOTES_TAG_NAME = "Notes";
    private String notes;

    public Notes() {
        this.setNotes("");
    }

    public Notes(String notesIn) {
        this.setNotes(notesIn);
    }

    public void setNotes(String notesIn) {
        this.validateSetNotes(notesIn);
        this.notes = notesIn;
    }

    private void validateSetNotes(String notesIn) {
        if (notesIn == null) {
            throw new IllegalArgumentException("Note text cannot be null");
        }
    }

    public String getNotes() {
        return this.notes;
    }

    public Node encode(Document doc) {
        Element element = doc.createElement(NOTES_TAG_NAME);
        element.appendChild(doc.createCDATASection(XMLUtils.filterXml(this.getNotes())));
        return element;
    }

    public Notes decode(Node node) {
        String note = node.getTextContent();
        return new Notes(note);
    }

    public String getPropertyID() {
        return this.getClass().getName();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "Note Text: " + this.notes;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Notes)) {
            return false;
        }
        Notes otherNotes = (Notes)object;
        if (this.notes == otherNotes.notes) {
            return true;
        }
        if (this.notes == null) {
            return false;
        }
        return this.notes.equals(otherNotes.notes);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.notes != null) {
            hashCode += this.notes.hashCode();
        }
        return hashCode;
    }
}

