/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.util.XMLUtils;
import com.thinkbuzan.gaia.model.properties.IProperty;
import java.awt.Color;
import java.util.Random;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Swimlane
implements IProperty,
Cloneable {
    private static final long serialVersionUID = -1508061105802230002L;
    private static final String SWIM_ID = "id";
    private static final String SWIM_TAG = "swimlane";
    private static final String SWIM_LABEL = "label";
    private static final String SWIM_Y = "y";
    private static final String SWIM_COLOR = "colour";
    private static final String SWIM_HIGH = "highlight";
    private transient String id;
    private transient String label;
    private transient Double yCoord;
    private transient Color colour;
    private transient boolean highlight;

    public Swimlane() {
        this(null, null, null, false);
    }

    public Swimlane(String idIn, String labelIn, Double yIn, boolean highlightIn) {
        this.id = idIn == null ? UUID.randomUUID().toString() : idIn;
        this.label = labelIn;
        this.yCoord = yIn;
        this.colour = this.generateRandomColour();
        this.highlight = highlightIn;
    }

    public String getId() {
        return this.id;
    }

    private void setId(String uuid) {
        this.id = uuid == null ? UUID.randomUUID().toString() : uuid;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Double getYCoord() {
        return this.yCoord;
    }

    public void setYCoord(Double yIn) {
        this.yCoord = yIn;
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color colour) {
        this.colour = colour;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean high) {
        this.highlight = high;
    }

    private Color generateRandomColour() {
        Random rand = new Random();
        float r = rand.nextFloat();
        float g = rand.nextFloat();
        float b = rand.nextFloat();
        return new Color(r, g, b);
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public String toString() {
        return this.id + ", " + this.label + ", " + this.yCoord + ", " + this.highlight + ", " + this.colour;
    }

    public boolean equals(Object obj) {
        if (this.id == null) {
            return false;
        }
        if (!(obj instanceof Swimlane)) {
            return false;
        }
        if (((Swimlane)obj).getId() == null) {
            return false;
        }
        return this.id.equalsIgnoreCase(((Swimlane)obj).getId());
    }

    public Swimlane decode(Node node) {
        String colId;
        this.setLabel(XMLUtils.getAttributes(node, SWIM_LABEL));
        String idId = XMLUtils.getAttributes(node, SWIM_ID);
        if (idId != null) {
            this.setId(idId);
        } else {
            this.setId(UUID.randomUUID().toString());
        }
        String yId = XMLUtils.getAttributes(node, SWIM_Y);
        if (yId != null) {
            this.setYCoord(Double.valueOf(yId));
        }
        if ((colId = XMLUtils.getAttributes(node, SWIM_COLOR)) != null) {
            this.setColour(Color.decode(colId));
        } else {
            this.setColour(this.generateRandomColour());
        }
        String highId = XMLUtils.getAttributes(node, SWIM_HIGH);
        this.setHighlight(highId != null && Boolean.valueOf(highId) != false);
        return this;
    }

    public Node encode(Document doc) {
        Element element = doc.createElement(SWIM_TAG);
        element.setAttribute(SWIM_ID, this.id);
        element.setAttribute(SWIM_LABEL, this.label);
        if (this.yCoord != null) {
            element.setAttribute(SWIM_Y, Double.toString(this.yCoord));
        }
        if (this.colour != null) {
            element.setAttribute(SWIM_COLOR, Integer.toString(this.colour.getRGB()));
        }
        element.setAttribute(SWIM_HIGH, Boolean.toString(this.highlight));
        return element;
    }

    public String getPropertyID() {
        return this.getClass().getName();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

