/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.model.properties.IProperty;
import java.awt.Color;
import java.io.Serializable;
import java.util.UUID;

public abstract class TagsObject
implements IProperty,
Serializable {
    private static final long serialVersionUID = 591482503669166216L;
    public static final String ID = "id";
    public static final String TAG = "tag";
    public static final String NAME = "name";
    public static final String PARENT_ID = "parentid";
    public static final String COLOUR = "colour";
    private static final Color[] COLOURS = new Color[]{Color.decode("#ffaacc"), Color.decode("#ffbbcc"), Color.decode("#ffcccc"), Color.decode("#ffddcc"), Color.decode("#ffeecc"), Color.decode("#ffffcc")};
    private static int NEXT_COLOUR = 0;
    private String id = UUID.randomUUID().toString();
    private String name;
    private Color colour;
    private boolean selected;

    public TagsObject(String nameIn) {
        this.name = nameIn;
        this.colour = this.getNextColour();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String idIn) {
        this.id = idIn;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean flag) {
        this.selected = flag;
    }

    public void setName(String nameIn) {
        this.name = nameIn;
    }

    public String getName() {
        return this.name;
    }

    public void setColour(Color colourIn) {
        this.colour = colourIn;
    }

    public void setColour(String colourIn) {
        this.colour = Color.decode(colourIn);
    }

    public Color getColour() {
        return this.colour;
    }

    public String getColourString() {
        return "#" + Integer.toHexString(this.colour.getRGB()).substring(2);
    }

    private Color getNextColour() {
        if (NEXT_COLOUR > COLOURS.length - 1) {
            NEXT_COLOUR = 0;
        }
        return COLOURS[NEXT_COLOUR++];
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

