/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.chaos.utilities.ThreadSafeSimpleDateFormat;
import com.thinkbuzan.gaia.entities.ChangeableItem;
import com.thinkbuzan.gaia.entities.Predecessor;
import com.thinkbuzan.gaia.entities.Resource;
import com.thinkbuzan.gaia.entities.util.XMLUtils;
import com.thinkbuzan.gaia.entities.validate.Validate;
import com.thinkbuzan.gaia.model.properties.IProperty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Task
extends ChangeableItem
implements IProperty,
Cloneable {
    private static final long serialVersionUID = 899498424395191821L;
    public static final String TASK_KEY = "com.thinkbuzan.gaia.cell.task";
    public static final String TASK = "Task";
    public static final String START_DATE = "StartDate";
    public static final String DUE_DATE = "DueDate";
    public static final String PRIORITY = "Priority";
    public static final String COMPLETION = "Completion";
    public static final String IS_PROJECT_MANAGED = "IsProjectManaged";
    public static final String TASK_TO = "TaskTo";
    public static final String TASK_BODY = "TaskBody";
    public static final String TASK_NOTE = "TaskNote";
    public static final String TASK_HIDDEN = "TaskHidden";
    public static final String PREDECESSOR = "Predecessor";
    public static final String PREDECESSOR_STRUCTURE_ID = "PredecessorStructureId";
    public static final String PREDECESSOR_TYPE = "PredecessorType";
    public static final String RESOURCE_MAP = "ResourceMap";
    public static final String RESOURCE_MAP_KEY = "ResourceMapKey";
    public static final String RESOURCE_MAP_VALUE = "ResourceMapValue";
    public static final String RESOURCE_NAME = "ResourceName";
    public static final String RESOURCE_COST = "ResourceCost";
    public static final String CHANGED = "Changed";
    private static final Logger LOGGER = Logger.getLogger(Task.class);
    private Date startDate;
    private Date dueDate;
    private String to;
    private String body;
    private String note;
    private String hidden = "";
    private int priority;
    private double completion = 0.0;
    private boolean enabledForProjectManager = true;
    private static final SimpleDateFormat DATE_FORMAT = new ThreadSafeSimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.getDefault());
    private final List<Predecessor> predecessors;
    private final List<Resource> resources = new ArrayList<Resource>();
    private static final transient int MAX_COMPLETION_PERC = 100;
    private static final int COMPLETION_INCREMENT = 10;
    private static final transient int MILLISECONDS_IN_SECOND = 1000;
    private static final transient int SECONDS_IN_MINUTE = 60;
    private static final transient int MINUTES_IN_HOUR = 60;
    private static final transient int HOURS_IN_DAY = 24;

    public Task() {
        this.startDate = new Date();
        this.dueDate = new Date();
        this.predecessors = new ArrayList<Predecessor>();
    }

    public int getNextCompletion() {
        int remainder;
        int percentage = (int)this.completion;
        int incr = percentage + 10;
        if ((incr -= (remainder = incr % 10)) < 0 || incr > 100) {
            incr = 0;
        }
        return incr;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDateIn) {
        Validate.notNull(startDateIn, "startDateIn");
        this.startDate = startDateIn;
        if (this.getStartDate().after(this.getDueDate())) {
            this.setDueDate(this.getStartDate());
        }
        this.setChanged(true);
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDateIn) {
        Validate.notNull(dueDateIn, "dueDateIn");
        this.dueDate = dueDateIn;
        if (this.getDueDate().before(this.getStartDate())) {
            this.setStartDate(this.getDueDate());
        }
        this.setChanged(true);
    }

    public double calculateDuration() {
        Calendar startCalendar = Calendar.getInstance();
        Calendar dueCalendar = Calendar.getInstance();
        startCalendar.setTime(this.getStartDate());
        dueCalendar.setTime(this.getDueDate());
        long startMillis = startCalendar.getTimeInMillis();
        long dueMillis = dueCalendar.getTimeInMillis();
        long millisecondsDifference = dueMillis - startMillis;
        double daysDifference = millisecondsDifference;
        daysDifference /= 1000.0;
        daysDifference /= 60.0;
        daysDifference /= 60.0;
        return daysDifference /= 24.0;
    }

    public void setDueDateByDuration(double durationInDays) {
        Validate.positive(durationInDays, "durationInDays");
        Date newDueDate = this.calculateDueDateByDuration(durationInDays);
        this.setDueDate(newDueDate);
    }

    private Date calculateDueDateByDuration(double durationInDays) {
        int durationInMinutes = (int)(durationInDays * 24.0 * 60.0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.getStartDate());
        calendar.add(12, durationInMinutes);
        return calendar.getTime();
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String toIn) {
        this.to = toIn;
        this.setChanged(true);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String bodyIn) {
        this.body = bodyIn;
        this.setChanged(true);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String noteIn) {
        this.note = noteIn;
        this.setChanged(true);
    }

    public String getHidden() {
        return this.hidden;
    }

    public void setHidden(String hiddenIn) {
        this.hidden = hiddenIn;
        this.setChanged(true);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priorityIn) {
        this.priority = priorityIn;
        this.setChanged(true);
    }

    public double getCompletion() {
        return this.completion;
    }

    public void setCompletion(double completionIn) {
        this.completion = completionIn;
        this.setChanged(true);
    }

    public boolean isEnabledForProjectManager() {
        return this.enabledForProjectManager;
    }

    public void setEnabledForProjectManager(boolean enabledForProjectManagerIn) {
        this.enabledForProjectManager = enabledForProjectManagerIn;
        this.setChanged(true);
    }

    public List<Predecessor> getPredecessors() {
        return this.predecessors;
    }

    public void setPredecessors(List<Predecessor> predecessorsIn) {
        this.predecessors.clear();
        for (Predecessor pred : predecessorsIn) {
            this.addPredecessor(pred);
        }
        this.setChanged(true);
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resourcesIn) {
        this.resources.clear();
        this.resources.addAll(resourcesIn);
        this.setChanged(true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Task other = (Task)obj;
        return this.hidden.equals(other.hidden);
    }

    public int hashCode() {
        return this.hidden.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task decode(Node node) {
        Task decoded = new Task();
        try {
            try {
                SimpleDateFormat simpleDateFormat = DATE_FORMAT;
                synchronized (simpleDateFormat) {
                    decoded.setStartDate(DATE_FORMAT.parse(XMLUtils.getContent(node, START_DATE)));
                    decoded.setDueDate(DATE_FORMAT.parse(XMLUtils.getContent(node, DUE_DATE)));
                }
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("The date format is not correct.", ex);
            }
            decoded.setPriority(Integer.valueOf(XMLUtils.getContent(node, PRIORITY)));
            decoded.setCompletion(Double.valueOf(XMLUtils.getContent(node, COMPLETION)));
            decoded.setEnabledForProjectManager(Boolean.valueOf(XMLUtils.getContent(node, IS_PROJECT_MANAGED)));
            decoded.setTo(XMLUtils.getContent(node, TASK_TO));
            decoded.setBody(XMLUtils.getContent(node, TASK_BODY));
            decoded.setNote(XMLUtils.getContent(node, TASK_NOTE));
            decoded.setHidden(XMLUtils.getContent(node, TASK_HIDDEN));
            decoded.decodePredecessors(node);
            decoded.decodeResources(node);
            decoded.setChanged(Boolean.valueOf(XMLUtils.getContent(node, CHANGED)));
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Exception caught in Task.decode", (Throwable)e);
        }
        return decoded;
    }

    public Node encode(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("param document can not be null");
        }
        Element element = doc.createElement(this.getPropertyID());
        XMLUtils.appendElement(doc, element, START_DATE, DATE_FORMAT.format(this.startDate));
        XMLUtils.appendElement(doc, element, DUE_DATE, DATE_FORMAT.format(this.dueDate));
        XMLUtils.appendElement(doc, element, PRIORITY, this.priority);
        XMLUtils.appendElement(doc, element, COMPLETION, this.completion);
        XMLUtils.appendElement(doc, element, IS_PROJECT_MANAGED, this.enabledForProjectManager);
        XMLUtils.appendElement(doc, element, TASK_TO, this.to);
        XMLUtils.appendElement(doc, element, TASK_BODY, this.body);
        XMLUtils.appendElement(doc, element, TASK_NOTE, this.note);
        XMLUtils.appendElement(doc, element, TASK_HIDDEN, this.hidden);
        XMLUtils.appendElement(doc, element, CHANGED, this.isChanged());
        this.appendPredecessors(doc, element);
        this.appendResources(doc, element);
        return element;
    }

    public String getPropertyID() {
        return this.getClass().getName();
    }

    public boolean isMilestone() {
        return this.calculateDuration() == 0.0;
    }

    public void setToMilestone() {
        this.setDueDateByDuration(0.0);
        this.setChanged(true);
    }

    private void appendPredecessors(Document doc, Element parentElement) {
        for (Predecessor predecessor : this.predecessors) {
            Element predecessorElement = doc.createElement(PREDECESSOR);
            predecessorElement.setAttribute(PREDECESSOR_STRUCTURE_ID, predecessor.getStructureId());
            predecessorElement.setAttribute(PREDECESSOR_TYPE, predecessor.getType().toString());
            parentElement.appendChild(predecessorElement);
        }
    }

    private void appendResources(Document doc, Element parentElement) {
        for (Resource resource : this.resources) {
            Element resourceElement = doc.createElement(RESOURCE_MAP);
            resourceElement.setAttribute(RESOURCE_NAME, resource.getResourceName());
            resourceElement.setAttribute(RESOURCE_COST, resource.getResourceCost());
            parentElement.appendChild(resourceElement);
        }
    }

    private void decodeResources(Node node) {
        NodeList resourceNodes = XMLUtils.getNodeList(node, RESOURCE_MAP);
        for (int i = 0; i < resourceNodes.getLength(); ++i) {
            Node resourceNode = resourceNodes.item(i);
            String name = XMLUtils.getAttributes(resourceNode, RESOURCE_NAME);
            String cost = XMLUtils.getAttributes(resourceNode, RESOURCE_COST);
            Resource loadedResource = new Resource();
            loadedResource.setResourceName(name);
            loadedResource.setResourceCost(cost);
            this.resources.add(loadedResource);
        }
    }

    private void decodePredecessors(Node node) {
        NodeList predecessorNodes = XMLUtils.getNodeList(node, PREDECESSOR);
        this.predecessors.clear();
        for (int i = 0; i < predecessorNodes.getLength(); ++i) {
            Node predecessorNode = predecessorNodes.item(i);
            String structureId = XMLUtils.getAttributes(predecessorNode, PREDECESSOR_STRUCTURE_ID);
            String predecessorTypeString = XMLUtils.getAttributes(predecessorNode, PREDECESSOR_TYPE);
            Predecessor.PredecessorType predecessorType = Predecessor.PredecessorType.valueOf(predecessorTypeString);
            Predecessor predecessor = new Predecessor();
            predecessor.setStructureId(structureId);
            predecessor.setType(predecessorType);
            this.addPredecessor(predecessor);
        }
    }

    private void addPredecessor(Predecessor predecessor) {
        boolean exists = false;
        for (Predecessor existing : this.predecessors) {
            if (!existing.getStructureId().equals(predecessor.getStructureId())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.predecessors.add(predecessor);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Task task = (Task)super.clone();
        task.setStartDate(new Date(this.getStartDate().getTime()));
        task.setDueDate(new Date(this.getDueDate().getTime()));
        task.setChanged(this.isChanged());
        return task;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getSimpleName());
        buffer.append("[startDate=").append(this.startDate);
        buffer.append(", dueDate=").append(this.dueDate);
        buffer.append(", priority=").append(this.priority);
        buffer.append(", completion=").append(this.completion);
        buffer.append(", enabledForProjectManager=").append(this.enabledForProjectManager);
        buffer.append(", to=").append(this.to);
        buffer.append(", body=").append(this.body);
        buffer.append(", note=").append(this.note);
        buffer.append(", hidden=").append(this.hidden);
        buffer.append(", predecessors=").append(this.predecessors);
        buffer.append(']');
        return buffer.toString();
    }
}

