/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.ColorOption;
import com.thinkbuzan.gaia.entities.FontOption;
import com.thinkbuzan.gaia.entities.GraphicsOption;
import com.thinkbuzan.gaia.entities.LayoutOption;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Theme {
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_COLOR_OPTION = "coloroption";
    public static final String ATTRIBUTE_FONT_OPTION = "fontoption";
    public static final String ATTRIBUTE_GRAPHICS_OPTION = "graphicsoption";
    public static final String ATTRIBUTE_LAYOUT_OPTION = "layoutoption";
    private String name = "none";
    private String key;
    private UUID uuid = UUID.randomUUID();
    private ColorOption colorOption;
    private FontOption fontOption;
    private GraphicsOption graphicsOption;
    private LayoutOption layoutOption;
    private boolean userTheme = false;
    private boolean hidden;
    private boolean unlicensed;
    private static final Logger LOGGER = Logger.getLogger(Theme.class);

    public Theme(ColorOption colorOptionIn, FontOption fontOptionIn, GraphicsOption graphicsOptionIn, LayoutOption layoutOptionIn) {
        this.validateSetColorOption(colorOptionIn);
        this.validateSetFontOption(fontOptionIn);
        this.validateSetGraphicsOption(graphicsOptionIn);
        this.validateSetLayoutOption(layoutOptionIn);
        this.colorOption = colorOptionIn;
        this.fontOption = fontOptionIn;
        this.graphicsOption = graphicsOptionIn;
        this.layoutOption = layoutOptionIn;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    public final void setUUID(UUID idIn) {
        this.validateSetId(idIn);
        this.uuid = idIn;
    }

    private void validateSetId(UUID idIn) {
        if (idIn == null) {
            throw new IllegalArgumentException("Invlaid Theme id!");
        }
    }

    public final String getName() {
        return this.name;
    }

    public final void setI18nKey(String keyIn) {
        this.validateSetString(keyIn);
        this.key = keyIn;
    }

    public final String getI18nKey() {
        String value;
        if (this.key == null) {
            value = this.name;
            LOGGER.warn((Object)("Theme.getI18nKey() called when i18n key = null, userDefined = " + this.userTheme + ", " + this));
        } else {
            value = this.key;
        }
        return value;
    }

    public final void setName(String nameIn) {
        this.validateSetString(nameIn);
        this.name = nameIn;
    }

    private void validateSetString(String string) {
        if (string == null || "".equals(string.trim())) {
            throw new IllegalArgumentException("Can't specify an empty string");
        }
    }

    public final ColorOption getColorOption() {
        return this.colorOption;
    }

    public final void setColorOption(ColorOption colorOptionIn) {
        this.validateSetColorOption(colorOptionIn);
        this.colorOption = colorOptionIn;
    }

    private void validateSetColorOption(ColorOption colorOptionIn) {
        if (colorOptionIn == null) {
            throw new IllegalArgumentException("Color option can't be set to null!");
        }
    }

    public final FontOption getFontOption() {
        return this.fontOption;
    }

    public final void setFontOption(FontOption fontOptionIn) {
        this.validateSetFontOption(fontOptionIn);
        this.fontOption = fontOptionIn;
    }

    private void validateSetFontOption(FontOption fontOptionIn) {
        if (fontOptionIn == null) {
            throw new IllegalArgumentException("Font option can't be set to null!");
        }
    }

    public final GraphicsOption getGraphicsOption() {
        return this.graphicsOption;
    }

    public final void setGraphicsOption(GraphicsOption graphicsOptionIn) {
        this.validateSetGraphicsOption(graphicsOptionIn);
        this.graphicsOption = graphicsOptionIn;
    }

    private void validateSetGraphicsOption(GraphicsOption graphicsOptionIn) {
        if (graphicsOptionIn == null) {
            throw new IllegalArgumentException("Graphics option can't be set to null!");
        }
    }

    public final LayoutOption getLayoutOption() {
        return this.layoutOption;
    }

    public final void setLayoutOption(LayoutOption layoutOptionIn) {
        this.validateSetLayoutOption(layoutOptionIn);
        this.layoutOption = layoutOptionIn;
    }

    private void validateSetLayoutOption(LayoutOption layoutOptionIn) {
        if (layoutOptionIn == null) {
            throw new IllegalArgumentException("Layout option can't be set to null!");
        }
    }

    public final boolean isUserDefined() {
        return this.userTheme;
    }

    public final void setUserDefined(boolean userDefined) {
        this.userTheme = userDefined;
    }

    public final void setHidden(boolean hiddenIn) {
        this.hidden = hiddenIn;
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    public final boolean isUnlicensed() {
        return this.unlicensed;
    }

    public final void setUnlicensed(boolean unlicensedIn) {
        this.unlicensed = unlicensedIn;
    }

    public final String toString() {
        String message = "%s[uuid=%s, name=%s, key=%s, userTheme=%s, colorOption=%s, fontOption=%s, graphicsOption=%s, layoutOption=%s, hidden=%s, unlicensed=%s]";
        return String.format("%s[uuid=%s, name=%s, key=%s, userTheme=%s, colorOption=%s, fontOption=%s, graphicsOption=%s, layoutOption=%s, hidden=%s, unlicensed=%s]", this.getClass().getSimpleName(), this.uuid, this.name, this.key, this.userTheme, this.colorOption, this.fontOption, this.graphicsOption, this.layoutOption, this.hidden, this.unlicensed);
    }
}

