/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.Connection;
import com.thinkbuzan.gaia.entities.Swimlane;
import com.thinkbuzan.gaia.entities.TaskScale;
import com.thinkbuzan.gaia.entities.TaskStatus;
import com.thinkbuzan.gaia.entities.util.XMLUtils;
import com.thinkbuzan.gaia.model.properties.IProperty;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimelineInfo
implements IProperty,
Cloneable {
    private static final long serialVersionUID = 1891004488480156617L;
    private static final Logger LOGGER = Logger.getLogger(TimelineInfo.class);
    private static final String MANAGED = "managed";
    private static final String POSITION_X = "x";
    private static final String POSITION_Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String CONNECTOR = "connection";
    private static final String MILESTONE = "milestone";
    private static final String STATUS = "status";
    private static final String COMPLETION = "completion";
    private static final String SCALE = "scale";
    private static final String START = "start";
    private static final String END = "end";
    private static final String SWIMLANE = "swimlane";
    private static final String INTERVAL = "interval";
    private static final transient int MAX_COMPLETION_PERC = 100;
    private transient boolean includeInTimeline;
    private transient Double positionX;
    private transient Double positionY;
    private transient Double width;
    private transient Double height;
    private transient List<Connection> connections;
    private transient boolean milestone;
    private transient Integer completion;
    private transient Date start;
    private transient Date end;
    private transient TaskStatus status;
    private transient TaskScale scale;
    private transient Integer interval;
    private transient List<Swimlane> swimlanes;

    public TimelineInfo() {
        this(false, new ArrayList<Connection>());
    }

    public TimelineInfo(boolean doInclude) {
        this(doInclude, new ArrayList<Connection>());
    }

    public TimelineInfo(boolean doInclude, ArrayList<Connection> connectionsIn) {
        this.connections = connectionsIn;
        this.includeInTimeline = doInclude;
        this.swimlanes = new ArrayList<Swimlane>();
        this.setPositionX(null);
        this.setPositionY(null);
        this.setWidth(null);
        this.setHeight(null);
        this.setStart(null);
        this.setEnd(null);
        this.setMilestone(false);
        this.setCompletion(null);
        this.setStatus(TaskStatus.NONE);
        this.setScale(TaskScale.SEVEN_DAY);
        this.setInterval(null);
    }

    public final String getPropertyID() {
        return this.getClass().getName();
    }

    public final TimelineInfo decode(Node node) {
        TimelineInfo decoded = new TimelineInfo();
        try {
            String completAtt;
            String endAtt;
            String posX = XMLUtils.getAttributes(node, POSITION_X);
            String posY = XMLUtils.getAttributes(node, POSITION_Y);
            String wid = XMLUtils.getAttributes(node, WIDTH);
            String hei = XMLUtils.getAttributes(node, HEIGHT);
            if (posX != null) {
                decoded.setPositionX(Double.valueOf(posX));
            }
            if (posY != null) {
                decoded.setPositionY(Double.valueOf(posY));
            }
            if (wid != null) {
                decoded.setWidth(Double.valueOf(wid));
            }
            if (hei != null) {
                decoded.setHeight(Double.valueOf(hei));
            }
            Calendar calendar = Calendar.getInstance();
            TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
            TimeZone localTimeZone = calendar.getTimeZone();
            calendar.setTimeZone(utcTimeZone);
            String startAtt = XMLUtils.getAttributes(node, START);
            if (startAtt != null) {
                calendar.setTimeInMillis(Long.valueOf(startAtt));
                calendar.setTimeZone(localTimeZone);
                decoded.setStart(calendar.getTime());
                calendar.setTimeZone(utcTimeZone);
            }
            if ((endAtt = XMLUtils.getAttributes(node, END)) != null) {
                calendar.setTimeInMillis(Long.valueOf(endAtt));
                calendar.setTimeZone(localTimeZone);
                decoded.setEnd(calendar.getTime());
                calendar.setTimeZone(utcTimeZone);
            }
            if ((completAtt = XMLUtils.getAttributes(node, COMPLETION)) != null) {
                decoded.setCompletion(Integer.valueOf(completAtt));
            }
            String stat = XMLUtils.getAttributes(node, STATUS);
            try {
                if (stat != null && TaskStatus.valueOf(stat) != null) {
                    decoded.setStatus(TaskStatus.valueOf(stat));
                }
            }
            catch (Exception ex) {
                LOGGER.warn((Object)("unreadable taskstatus " + stat));
                decoded.setStatus(TaskStatus.NONE);
            }
            String scal = XMLUtils.getAttributes(node, SCALE);
            try {
                if (scal != null && TaskScale.valueOf(scal) != null) {
                    decoded.setScale(TaskScale.valueOf(scal));
                }
            }
            catch (Exception ex) {
                LOGGER.warn((Object)("unreadable taskscale " + scal));
                decoded.setScale(TaskScale.SEVEN_DAY);
            }
            String inter = XMLUtils.getAttributes(node, INTERVAL);
            if (inter != null) {
                decoded.setInterval(Integer.valueOf(inter));
            }
            decoded.setIncludeInTimeline(Boolean.valueOf(XMLUtils.getAttributes(node, MANAGED)));
            decoded.setMilestone(Boolean.valueOf(XMLUtils.getAttributes(node, MILESTONE)));
            decoded.decodeConnections(node);
            decoded.decodeSwimlanes(node);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Exception caught in TimelineInfo.decode", (Throwable)e);
        }
        return decoded;
    }

    public final Node encode(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("param document can not be null");
        }
        Element element = doc.createElement(this.getPropertyID());
        if (this.positionX != null) {
            element.setAttribute(POSITION_X, this.positionX.toString());
        }
        if (this.positionY != null) {
            element.setAttribute(POSITION_Y, this.positionY.toString());
        }
        if (this.width != null) {
            element.setAttribute(WIDTH, this.width.toString());
        }
        if (this.height != null) {
            element.setAttribute(HEIGHT, this.height.toString());
        }
        if (this.completion != null) {
            element.setAttribute(COMPLETION, this.completion.toString());
        }
        if (this.interval != null) {
            element.setAttribute(INTERVAL, this.interval.toString());
        }
        if (this.status != null) {
            element.setAttribute(STATUS, this.status.toString());
        }
        if (this.scale != null) {
            element.setAttribute(SCALE, this.scale.toString());
        }
        element.setAttribute(MANAGED, Boolean.toString(this.includeInTimeline));
        element.setAttribute(MILESTONE, Boolean.toString(this.milestone));
        Calendar calendar = Calendar.getInstance();
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        TimeZone localTimeZone = calendar.getTimeZone();
        if (this.start != null) {
            calendar.setTimeInMillis(this.start.getTime());
            calendar.setTimeZone(utcTimeZone);
            element.setAttribute(START, Long.toString(calendar.getTimeInMillis()));
            calendar.setTimeZone(localTimeZone);
        }
        if (this.end != null) {
            calendar.setTimeInMillis(this.end.getTime());
            calendar.setTimeZone(utcTimeZone);
            element.setAttribute(END, Long.toString(calendar.getTimeInMillis()));
            calendar.setTimeZone(localTimeZone);
        }
        this.appendConnections(doc, element);
        this.appendSwimlanes(doc, element);
        return element;
    }

    private void appendConnections(Document doc, Element parentElement) {
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        } else {
            for (Connection connection : this.connections) {
                Node connectElement = connection.encode(doc);
                parentElement.appendChild(connectElement);
            }
        }
    }

    private void decodeConnections(Node node) {
        NodeList predecessorNodes = XMLUtils.getNodeList(node, CONNECTOR);
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        } else {
            this.connections.clear();
        }
        for (int i = 0; i < predecessorNodes.getLength(); ++i) {
            Node predecessorNode = predecessorNodes.item(i);
            Connection connection = new Connection();
            connection.decode(predecessorNode);
            this.connections.add(connection);
        }
    }

    private void appendSwimlanes(Document doc, Element parentElement) {
        if (this.swimlanes == null) {
            this.swimlanes = new ArrayList<Swimlane>();
        } else {
            for (Swimlane swimlane : this.swimlanes) {
                Node swimElement = swimlane.encode(doc);
                parentElement.appendChild(swimElement);
            }
        }
    }

    private void decodeSwimlanes(Node node) {
        NodeList predecessorNodes = XMLUtils.getNodeList(node, SWIMLANE);
        if (this.swimlanes == null) {
            this.swimlanes = new ArrayList<Swimlane>();
        } else {
            this.swimlanes.clear();
        }
        for (int i = 0; i < predecessorNodes.getLength(); ++i) {
            Node predecessorNode = predecessorNodes.item(i);
            Swimlane swim = new Swimlane();
            swim.decode(predecessorNode);
            this.swimlanes.add(swim);
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        TimelineInfo task = (TimelineInfo)super.clone();
        task.clearConnections();
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        } else {
            for (Connection connection : this.connections) {
                task.addConnection(connection.getStructureId());
            }
        }
        return task;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getSimpleName());
        buffer.append("[ includedInTimeline=").append(this.includeInTimeline);
        buffer.append(", posX=").append(this.positionX);
        buffer.append(", posY=").append(this.positionY);
        buffer.append(", width=").append(this.width);
        buffer.append(", height=").append(this.height);
        buffer.append(", milestone=").append(this.milestone);
        buffer.append(", completion=").append(this.completion);
        if (this.status != null) {
            buffer.append(", status=").append(this.status.toString());
        }
        if (this.scale != null) {
            buffer.append(", scale=").append(this.scale.toString());
        }
        buffer.append(", connections={");
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        } else {
            for (Connection connection : this.connections) {
                buffer.append(connection.getStructureId());
            }
        }
        buffer.append("}");
        buffer.append(']');
        return buffer.toString();
    }

    public final Collection<? extends String> getConnectionIds() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        } else {
            for (Connection conn : this.connections) {
                list.add(conn.getStructureId());
            }
        }
        return list;
    }

    public final List<Connection> getConnections() {
        ArrayList<Connection> list = new ArrayList<Connection>();
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        } else {
            for (Connection conn : this.connections) {
                list.add(conn);
            }
        }
        return list;
    }

    public final void addConnection(String targetId) {
        boolean exists = false;
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        } else {
            for (Connection existing : this.connections) {
                if (!existing.getStructureId().equalsIgnoreCase(targetId)) continue;
                exists = true;
                break;
            }
        }
        if (!exists) {
            Connection connection = new Connection(targetId);
            this.connections.add(connection);
        }
    }

    public final void clearConnections() {
        this.connections = new ArrayList<Connection>();
    }

    public final void removeConnection(Connection connection) {
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        } else {
            this.connections.remove(connection);
        }
    }

    public final List<Swimlane> getSwimlanes() {
        ArrayList<Swimlane> list = new ArrayList<Swimlane>();
        if (this.swimlanes == null) {
            this.swimlanes = new ArrayList<Swimlane>();
        } else {
            for (Swimlane conn : this.swimlanes) {
                list.add(conn);
            }
        }
        return list;
    }

    public final void addSwimlane(String id, String labelIn, Double yoff) {
        this.addSwimlane(id, labelIn, yoff, null, false);
    }

    public final void addSwimlane(String id, String labelIn, Double yoff, Color colour, boolean highlight) {
        boolean exists = false;
        Swimlane swim = new Swimlane(id, labelIn, yoff, highlight);
        if (colour != null) {
            swim.setColour(colour);
        }
        if (this.swimlanes == null) {
            this.swimlanes = new ArrayList<Swimlane>();
        } else {
            for (Swimlane existing : this.swimlanes) {
                if (!existing.equals(swim)) continue;
                exists = true;
                break;
            }
        }
        if (!exists) {
            this.swimlanes.add(swim);
        }
    }

    public final void clearSwimlanes() {
        this.swimlanes = new ArrayList<Swimlane>();
    }

    public final void removeSwimlane(Swimlane swimlane) {
        if (this.swimlanes == null) {
            this.swimlanes = new ArrayList<Swimlane>();
        } else {
            this.swimlanes.remove(swimlane);
        }
    }

    public final void setIncludeInTimeline(boolean include) {
        this.includeInTimeline = include;
    }

    public final boolean isIncludeInTimeline() {
        return this.includeInTimeline;
    }

    public final void setPositionX(Double xin) {
        this.positionX = xin;
    }

    public final Double getPositionX() {
        return this.positionX;
    }

    public final void setPositionY(Double yin) {
        this.positionY = yin;
    }

    public final Double getPositionY() {
        return this.positionY;
    }

    public final Double getWidth() {
        return this.width;
    }

    public final void setWidth(Double width) {
        this.width = width;
    }

    public final Double getHeight() {
        return this.height;
    }

    public final void setHeight(Double height) {
        this.height = height;
    }

    public final Date getStart() {
        return this.start;
    }

    public final void setStart(Date startIn) {
        this.start = startIn;
    }

    public final Date getEnd() {
        return this.end;
    }

    public final void setEnd(Date endIn) {
        this.end = endIn;
    }

    public final boolean isMilestone() {
        return this.milestone;
    }

    public final void setMilestone(boolean milestone) {
        this.milestone = milestone;
    }

    public final TaskStatus getStatus() {
        return this.status;
    }

    public final void setStatus(TaskStatus status) {
        if (status != null) {
            this.status = status;
        }
    }

    public final TaskScale getScale() {
        return this.scale;
    }

    public final void setScale(TaskScale scale) {
        if (scale != null) {
            this.scale = scale;
        }
    }

    public final Integer getCompletion() {
        return this.completion;
    }

    public final void setCompletion(Integer completionIn) {
        if (completionIn != null) {
            this.completion = Math.min(Math.max(completionIn, 0), 100);
        }
    }

    public void setInterval(Integer intervalIn) {
        if (intervalIn != null) {
            this.interval = Math.max(Math.min(intervalIn, 3), 1);
        }
    }

    public Integer getInterval() {
        if (this.interval == null) {
            return 1;
        }
        return this.interval;
    }
}

