/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities.util;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XMLUtils {
    private static final Logger LOG = Logger.getLogger(XMLUtils.class);

    private XMLUtils() {
    }

    public static String getContent(Node parentNode, String nodeName) {
        if (!(parentNode instanceof Element)) {
            throw new IllegalArgumentException("the parent  node is not a element object.");
        }
        Element element = (Element)parentNode;
        NodeList nodeList = element.getElementsByTagName(nodeName);
        if (nodeList == null) {
            return null;
        }
        if (nodeList.getLength() <= 0) {
            return null;
        }
        Node node = nodeList.item(0);
        if (node == null) {
            return null;
        }
        return node.getTextContent();
    }

    public static String getAttributes(Node node, String attributeName) {
        if (!(node instanceof Element)) {
            throw new IllegalArgumentException("the parent node is not a element object.");
        }
        Node attributeNode = node.getAttributes().getNamedItem(attributeName);
        if (attributeNode != null) {
            return attributeNode.getTextContent();
        }
        return null;
    }

    public static Node getNode(Node parentNode, String nodeName) {
        if (!(parentNode instanceof Element)) {
            throw new IllegalArgumentException("the parent node is not a element object.");
        }
        Element element = (Element)parentNode;
        return element.getElementsByTagName(nodeName).item(0);
    }

    public static NodeList getNodeList(Node parentNode, String nodeName) {
        if (!(parentNode instanceof Element)) {
            throw new IllegalArgumentException("the parent node is not a element object.");
        }
        Element element = (Element)parentNode;
        return element.getElementsByTagName(nodeName);
    }

    public static void appendElement(Document doc, Element partentElement, String elementName, Object textValue) {
        if (textValue != null) {
            Element element = doc.createElement(elementName);
            Text text = doc.createTextNode(XMLUtils.filterXml(String.valueOf(textValue)));
            element.appendChild(text);
            partentElement.appendChild(element);
        }
    }

    public static void setAttribute(Element element, String name, Object value) {
        if (value != null) {
            element.setAttribute(name, XMLUtils.filterXml(String.valueOf(value)));
        }
    }

    public static void setTextContent(Element element, Object text) {
        if (text != null) {
            element.setTextContent(XMLUtils.filterXml(String.valueOf(text)));
        }
    }

    public static Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentbuilder = documentbuilderfactory.newDocumentBuilder();
            document = documentbuilder.newDocument();
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
        }
        return document;
    }

    public static void save(Document document) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult("test.xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            LOG.error((Object)e);
        }
    }

    public static String filterXml(String text) {
        if (text == null) {
            return "";
        }
        StringBuffer buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!XMLUtils.isLegalXml(c)) {
                if (buffer != null) continue;
                buffer = new StringBuffer(text.length());
                buffer.append(text.substring(0, i));
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c);
        }
        return buffer != null ? buffer.toString() : text;
    }

    public static boolean isLegalXml(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (XMLUtils.isLegalXml(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLegalXml(char c) {
        if (c >= '\u0092' && c <= '\u0097') {
            return false;
        }
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
    }
}

