/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities.validate;

import com.thinkbuzan.gaia.entities.validate.ValidationException;

public final class Validate {
    private Validate() {
    }

    public static void notNull(Object value, String variableName) {
        if (value == null) {
            throw new ValidationException(String.format("%s must not be null", variableName));
        }
    }

    public static void positive(float value, String variableName) {
        if (value < 0.0f) {
            throw new ValidationException(String.format("%s(%s) must be >= 0.0f", variableName, Float.valueOf(value)));
        }
    }

    public static void positive(double value, String variableName) {
        if (value < 0.0) {
            throw new ValidationException(String.format("%s(%s) must be >= 0.0", variableName, value));
        }
    }

    public static void strictlyPositive(float value, String variableName) {
        if (value <= 0.0f) {
            throw new ValidationException(String.format("%s(%s) must be > 0.0f", variableName, Float.valueOf(value)));
        }
    }

    public static void strictlyPositive(int value, String variableName) {
        if (value <= 0) {
            throw new ValidationException(String.format("%s(%s) must be > 0", variableName, value));
        }
    }

    public static void isTrueM(boolean value, String message) {
        if (!value) {
            throw new ValidationException(message);
        }
    }

    public static void equal(int value, int expectedValue, String variableName) {
        if (value != expectedValue) {
            throw new ValidationException(String.format("%s(%s) must be equal to %s", variableName, value, expectedValue));
        }
    }
}

