/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.spellchecker;

import com.buzanonline.chaos.preferences.Preferences;
import java.util.Locale;

public final class SpellCheckerUtil {
    private static final String PREFS_SPELL_CHECK_LOCALE = "com.thinkbuzan.gaia.spellcheck.locale";
    private static final Locale DEFAULT_LOCALE = Locale.UK;

    private SpellCheckerUtil() {
    }

    public static Locale getLocale(Preferences preferencesIn) {
        if (preferencesIn == null) {
            throw new IllegalArgumentException("The preferences should be not null.");
        }
        String locale = preferencesIn.get(PREFS_SPELL_CHECK_LOCALE, DEFAULT_LOCALE.toString());
        if (locale == null) {
            return DEFAULT_LOCALE;
        }
        return SpellCheckerUtil.getLocaleFromPreferenceString(locale);
    }

    private static Locale getLocaleFromPreferenceString(String localeValue) {
        Locale tmpLocale;
        block6: {
            block5: {
                String[] localeElements = localeValue.split("_");
                boolean localeWithLanguageLength = true;
                int localeWithCountryLength = 2;
                int localeWithVariantLength = 3;
                if (localeElements == null) break block5;
                switch (localeElements.length) {
                    case 1: {
                        tmpLocale = new Locale(localeElements[0]);
                        break block6;
                    }
                    case 2: {
                        tmpLocale = new Locale(localeElements[0], localeElements[1]);
                        break block6;
                    }
                    case 3: {
                        tmpLocale = new Locale(localeElements[0], localeElements[1], localeElements[2]);
                        break block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Found illegal locale value : " + localeValue);
                    }
                }
            }
            throw new IllegalArgumentException("Found illegal locale value : " + localeValue);
        }
        return tmpLocale;
    }
}

