/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.spellchecker;

import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.gaia.spellchecker.SpellCheckerService;
import com.thinkbuzan.gaia.spellchecker.osgi.I18nService;
import com.thinkbuzan.gaia.spellchecker.wintertree.BackgroundChecker;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;

public class SpellMouseListener
extends MouseAdapter {
    private final transient BackgroundChecker backgroundChecker;
    private static final Logger LOGGER = Logger.getLogger(SpellMouseListener.class);

    public SpellMouseListener(BackgroundChecker backCheckerIn) {
        if (backCheckerIn == null) {
            throw new IllegalArgumentException("The BackgroundChecker should be not-null.");
        }
        this.backgroundChecker = backCheckerIn;
    }

    public final void mouseClicked(MouseEvent evt) {
        if (!SystemInfo.isAnyMac() || evt.getButton() != 3) {
            this.checkPopup(evt);
        }
    }

    public final void mousePressed(MouseEvent evt) {
        if (!SystemInfo.isAnyMac() || evt.getButton() != 3) {
            this.checkPopup(evt);
        }
    }

    public final void mouseReleased(MouseEvent evt) {
        this.checkPopup(evt);
    }

    private void checkPopup(MouseEvent evt) {
        LOGGER.debug((Object)("checkPopup(e) Called, Button = " + evt.getButton()));
        boolean forcePopup = false;
        if (SystemInfo.isAnyMac() && evt.getButton() == 3) {
            forcePopup = true;
            LOGGER.debug((Object)"Forcing Popup for right-click on mac");
        }
        if (evt.isPopupTrigger() || forcePopup) {
            LOGGER.debug((Object)("e is popup trigger: showing popup in component: " + evt.getComponent()));
            Point point = new Point(evt.getX(), evt.getY());
            if (this.backgroundChecker.isInMisspelledWord(point)) {
                this.backgroundChecker.createPopupMenu(evt.getX(), evt.getY(), SpellCheckerService.NUMBER_OF_SUGGESTION_WORDS, this.getIgnoreAll(), this.getAdd(), this.getNoSuggestion()).show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private String getIgnoreAll() {
        return I18nService.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.ignoreAll");
    }

    private String getAdd() {
        return I18nService.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.add");
    }

    private String getNoSuggestion() {
        return I18nService.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.noSuggestions");
    }
}

