/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.spellchecker.impl;

import com.thinkbuzan.gaia.spellchecker.ISpellingListener;
import com.thinkbuzan.gaia.spellchecker.SpellCheckerException;
import com.thinkbuzan.gaia.spellchecker.SpellCheckerService;
import com.thinkbuzan.gaia.spellchecker.SpellMouseListener;
import com.thinkbuzan.gaia.spellchecker.model.TextSection;
import com.thinkbuzan.gaia.spellchecker.osgi.I18nService;
import com.thinkbuzan.gaia.spellchecker.wintertree.BackgroundChecker;
import com.thinkbuzan.gaia.spellchecker.wintertree.PropSpellingSession;
import com.wintertree.ssce.LexiconUpdateException;
import com.wintertree.ssce.LicenseKey;
import com.wintertree.ssce.ParameterException;
import com.wintertree.ssce.StringWordParser;
import com.wintertree.ssce.SuggestionSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellCheckerServiceImpl
implements SpellCheckerService {
    private static final Logger LOGGER = Logger.getLogger(SpellCheckerServiceImpl.class);
    private transient BackgroundChecker backgroundChecker = null;
    private static List<Object> iSpellingListeners = new ArrayList<Object>();
    private transient PropSpellingSession sentry;
    private transient Properties properties;
    private transient Locale locale;
    private final transient File shareFile;
    private final transient Map<UUID, String> sentenceMap = new HashMap<UUID, String>();

    public SpellCheckerServiceImpl(Locale localeIn, File shareFileIn) {
        if (null == localeIn) {
            throw new IllegalArgumentException("Locale can not be null.");
        }
        if (null == shareFileIn) {
            throw new IllegalArgumentException("Share file path can not be null.");
        }
        this.locale = localeIn;
        if (!this.jarHasPropertiesForLocale(this.locale)) {
            this.locale = new Locale(this.locale.getLanguage(), this.locale.getCountry());
            if (!this.jarHasPropertiesForLocale(this.locale)) {
                this.locale = new Locale(this.locale.getLanguage());
            }
        }
        this.shareFile = shareFileIn;
        LicenseKey.setKey((int)SpellCheckerService.LICENSE_KEY);
        this.copyLexicon(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jarHasPropertiesForLocale(Locale localeIn) {
        String lowercaseLocale = localeIn.toString().toLowerCase();
        String resourceName = "resources/properties/" + lowercaseLocale + ".properties";
        InputStream input = this.getClass().getResourceAsStream(resourceName);
        try {
            boolean bl = input != null;
            return bl;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException exception) {
                    LOGGER.error((Object)"Caught Exception when closing InputStream", (Throwable)exception);
                }
            }
        }
    }

    @Override
    public final void checkSpelling(UUID uid, String sentenceIn) {
        LOGGER.debug((Object)("checkSpelling called: sentence = " + sentenceIn + ", UUID = " + uid));
        if (uid == null) {
            throw new IllegalArgumentException("The UUID should be not null");
        }
        if (sentenceIn == null) {
            throw new IllegalArgumentException("The sentence should be not null");
        }
        this.sentenceMap.put(uid, sentenceIn);
        if (this.isLexiconExist()) {
            this.checkSpellForSystemComponent(uid, sentenceIn);
        }
    }

    @Override
    public final void checkSpelling(JTextComponent textComponentIn) {
        if (textComponentIn == null) {
            throw new IllegalArgumentException("The JTextComponent should be not null");
        }
        if (this.isLexiconExist()) {
            this.backgroundChecker = new BackgroundChecker(textComponentIn, this.getPropSpellingSession(false));
            textComponentIn.addMouseListener(new SpellMouseListener(this.backgroundChecker));
        }
    }

    @Override
    public final void addWordinLexicon(String wordIn, SpellCheckerService.LexiconAddType lexiconTypeIn) throws SpellCheckerException {
        if (wordIn == null || wordIn.trim().equalsIgnoreCase("")) {
            throw new IllegalArgumentException("The add word should be not empty.");
        }
        if (lexiconTypeIn == null) {
            throw new IllegalArgumentException("The LexiconAddType should be not null.");
        }
        if (lexiconTypeIn == SpellCheckerService.LexiconAddType.Permanent) {
            this.addWordPermanent(wordIn);
        } else if (lexiconTypeIn == SpellCheckerService.LexiconAddType.Temporary) {
            this.addWordTemporary(wordIn);
        }
        this.recheckSentence(wordIn);
    }

    private void recheckSentence(String wordIn) {
        this.sentenceMap.put(UUID.randomUUID(), wordIn);
        if (!this.sentenceMap.isEmpty()) {
            for (Map.Entry<UUID, String> entry : this.sentenceMap.entrySet()) {
                if (!entry.getValue().equals(wordIn) && entry.getValue().indexOf(wordIn) <= -1) continue;
                this.checkSpellForSystemComponent(entry.getKey(), entry.getValue());
            }
        }
    }

    private void checkSpellForSystemComponent(UUID uid, String sentenceIn) {
        PropSpellingSession spellingSession = this.getPropSpellingSession(false);
        StringWordParser parser = new StringWordParser(sentenceIn, !spellingSession.getOption(4096));
        ArrayList<Integer> errorIndex = new ArrayList<Integer>();
        while (parser.hasMoreElements()) {
            int result = spellingSession.check(parser.getWord());
            if (result != 0) {
                errorIndex.add(parser.getCursor());
                errorIndex.add(parser.getCursor() + parser.getWord().length());
            }
            parser.nextWord();
        }
        this.fireISpellingListenerChanged(new TextSection(errorIndex, uid));
    }

    @Override
    public final List<String> getSuggestions(String word) {
        if (word == null || word.trim().equals("")) {
            throw new IllegalArgumentException("The word should be not empty");
        }
        SuggestionSet suggestionset = new SuggestionSet(SpellCheckerService.NUMBER_OF_SUGGESTION_WORDS.intValue());
        this.getPropSpellingSession(false).suggest(word, this.getPropSpellingSession(false).getMinSuggestDepth(), this.getPropSpellingSession(false).getComparator(), suggestionset);
        ArrayList<String> suggestionWords = new ArrayList<String>();
        for (int i = 0; i < suggestionset.size(); ++i) {
            suggestionWords.add(suggestionset.wordAt(i));
        }
        if (suggestionWords.isEmpty()) {
            suggestionWords.add(I18nService.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.noSuggestions"));
        }
        return suggestionWords;
    }

    @Override
    public final boolean isLexiconExist() {
        String language = this.locale.toString().toLowerCase();
        File toFilePath = new File(this.shareFile + File.separator + language);
        return toFilePath.exists() && toFilePath.list().length > 0;
    }

    @Override
    public final void addListener(ISpellingListener listenerIn) {
        if (!iSpellingListeners.contains(listenerIn)) {
            iSpellingListeners.add(listenerIn);
        }
    }

    @Override
    public final void setLocale(Locale localeIn) {
        if (localeIn == null) {
            throw new IllegalArgumentException("The locale should be not null");
        }
        this.locale = localeIn;
        this.copyLexicon(true);
    }

    @Override
    public final void romoveListener(ISpellingListener listenerIn) {
        if (iSpellingListeners.contains(listenerIn)) {
            iSpellingListeners.remove(listenerIn);
        }
    }

    public final PropSpellingSession getPropSpellingSession(boolean reFetch) {
        if (this.sentry == null || reFetch) {
            this.sentry = new PropSpellingSession(this.getProperties(false), this.shareFile + File.separator + this.locale.toString().toLowerCase() + File.separator);
        }
        return this.sentry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(boolean reFetch) {
        if (this.properties == null || reFetch) {
            this.properties = new Properties();
            String local = this.locale.toString().toLowerCase();
            InputStream is = this.getClass().getResourceAsStream("resources/properties/" + local + ".properties");
            if (is != null) {
                try {
                    this.properties.load(is);
                }
                catch (IOException e) {
                    LOGGER.debug((Object)e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOGGER.debug((Object)e);
                    }
                }
            }
        }
        return this.properties;
    }

    private void copyLexicon(boolean localeChanged) {
        int i;
        String localeString = this.locale.toString().toLowerCase();
        File toFilePath = new File(this.shareFile, localeString);
        String[] fileNames = this.getLexiconFileNames(this.getProperties(localeChanged));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"About to write the following files to disk: ");
            for (i = 0; i < fileNames.length; ++i) {
                LOGGER.debug((Object)fileNames[i]);
            }
            LOGGER.debug((Object)"-- end file list");
        }
        if (fileNames.length > 0) {
            if (!toFilePath.exists()) {
                toFilePath.mkdirs();
                LOGGER.debug((Object)"Made dirs");
            }
            for (i = 0; i < fileNames.length; ++i) {
                this.writeFileToDisk(localeString, toFilePath, fileNames[i]);
            }
        }
        this.getPropSpellingSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileToDisk(String localeString, File toFilePath, String fileName) {
        File targetFile = new File(toFilePath, fileName);
        if (targetFile.exists()) {
            LOGGER.debug((Object)("File already exists " + targetFile));
            return;
        }
        InputStream inStream = this.getClass().getResourceAsStream("resources/lex/" + localeString + "/" + fileName);
        if (inStream != null) {
            FileOutputStream fs = null;
            try {
                fs = new FileOutputStream(targetFile);
                IOUtils.copy((InputStream)inStream, (OutputStream)fs);
                LOGGER.debug((Object)("Written file to: " + targetFile));
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error when writing lexicon file: " + fileName), (Throwable)ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inStream);
                IOUtils.closeQuietly((OutputStream)fs);
            }
        } else {
            LOGGER.warn((Object)("File not found: resources/lex/" + localeString + "/" + fileName));
        }
    }

    private String[] getLexiconFileNames(Properties propertiesIn) {
        String[] fileNames = new String[propertiesIn.size()];
        int index = 0;
        for (int i = 1; i <= propertiesIn.size(); ++i) {
            String userFileName = propertiesIn.getProperty("UserLexicon" + i);
            String mainFileName = propertiesIn.getProperty("MainLexicon" + i);
            if (userFileName == null && mainFileName == null) break;
            if (userFileName != null) {
                StringTokenizer userFileNametokenizer = new StringTokenizer(userFileName, ",");
                fileNames[index++] = userFileNametokenizer.nextToken();
            }
            if (mainFileName == null) continue;
            StringTokenizer mainFileNametokenizer = new StringTokenizer(mainFileName, ",");
            fileNames[index++] = mainFileNametokenizer.nextToken();
        }
        String[] tempFileNames = new String[index];
        System.arraycopy(fileNames, 0, tempFileNames, 0, index);
        return tempFileNames;
    }

    private void addWordPermanent(String wordIn) throws SpellCheckerException {
        if (this.sentry.getUserLexicons() == null) {
            return;
        }
        int number = 105;
        try {
            this.sentry.getUserLexicons()[0].addWord(wordIn, 105, null);
        }
        catch (LexiconUpdateException e) {
            throw new SpellCheckerException(e);
        }
        catch (ParameterException e) {
            throw new SpellCheckerException(e);
        }
    }

    private void addWordTemporary(String wordIn) throws SpellCheckerException {
        try {
            this.sentry.getTempLexicon().addWord(wordIn);
        }
        catch (LexiconUpdateException e) {
            throw new SpellCheckerException(e);
        }
    }

    private void fireISpellingListenerChanged(TextSection textSectionIn) {
        ISpellingListener l = null;
        for (int i = 0; i < iSpellingListeners.size(); ++i) {
            l = (ISpellingListener)iSpellingListeners.get(i);
            l.spellCheckComplete(textSectionIn);
        }
    }
}

