/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.spellchecker.wintertree;

import com.thinkbuzan.gaia.spellchecker.wintertree.PropSpellingSession;
import com.wintertree.ssce.EditableLexicon;
import com.wintertree.ssce.FileTextLexicon;
import com.wintertree.ssce.StringWordParser;
import com.wintertree.ssce.SuggestionSet;
import com.wintertree.ssce.WordParser;
import com.wintertree.util.UniCharacter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;

public class BackgroundChecker
implements DocumentListener,
CaretListener {
    private static final Logger LOG = Logger.getLogger(BackgroundChecker.class);
    private transient boolean busy;
    private transient JTextComponent component;
    private transient int caretPos;
    private final transient Vector<MisspelledWord> misspelledWords = new Vector();
    private final transient Highlighter.HighlightPainter highlightPainter;
    private final transient PropSpellingSession sentry;
    private EditableLexicon userDictionary;

    public BackgroundChecker(JTextComponent componentIn, PropSpellingSession sentryIn) {
        this.component = componentIn;
        if (this.component == null) {
            this.component = new JTextArea();
        }
        this.sentry = sentryIn;
        this.highlightPainter = new ZigZagHighlightPainter(Color.red);
        FileTextLexicon[] userLex = this.sentry.getUserLexicons();
        this.userDictionary = userLex != null ? userLex[0] : null;
        this.caretPos = this.component.getCaret().getDot();
        this.resume();
    }

    public final void addMisspelledWord(String word, int offset) throws BadLocationException {
        Enumeration<MisspelledWord> e = this.misspelledWords.elements();
        while (e.hasMoreElements()) {
            MisspelledWord mw = e.nextElement();
            if (offset < mw.getOffset() || offset >= mw.getOffset() + mw.getLen()) continue;
            mw.setLen(word.length());
            return;
        }
        MisspelledWord mw = new MisspelledWord(word, offset);
        this.misspelledWords.addElement(mw);
    }

    public final void caretUpdate(CaretEvent ev) {
        if (this.busy) {
            return;
        }
        this.busy = true;
        int cp = ev.getDot();
        if (cp == this.caretPos) {
            this.busy = false;
            return;
        }
        boolean recheckWord = false;
        StringBuffer word = new StringBuffer();
        int wordStartPos = this.getWordAt(this.caretPos, word);
        if (wordStartPos >= 0 && (cp < wordStartPos || cp > wordStartPos + word.length())) {
            recheckWord = true;
        }
        if (cp == this.caretPos + 1) {
            String t = null;
            try {
                if (this.caretPos > 0) {
                    t = this.component.getDocument().getText(this.caretPos - 1, 2);
                }
            }
            catch (BadLocationException e) {
                LOG.debug((Object)e);
            }
            if (t != null && this.isWordChar(t.charAt(0)) && !this.isWordChar(t.charAt(1))) {
                wordStartPos = this.getWordAt(this.caretPos - 1, word);
                recheckWord = true;
            }
        }
        if (recheckWord) {
            this.checkWord(word.toString(), wordStartPos);
        }
        this.caretPos = cp;
        this.busy = false;
    }

    public void changedUpdate(DocumentEvent junk) {
    }

    public final boolean checkWord(String word, int offset) {
        StringBuffer otherWord = new StringBuffer();
        int result = this.sentry.check(word, otherWord);
        if ((result & 1) != 0) {
            result &= 0xFFFFFFFE;
            result |= 2;
        }
        if ((result & 0x10) != 0 || (result & 2) != 0) {
            try {
                this.addMisspelledWord(word, offset);
            }
            catch (BadLocationException e) {
                LOG.debug((Object)("Can't happen!" + e));
            }
            return true;
        }
        if (result == 0 && this.isInMisspelledWord(offset, offset + word.length())) {
            this.removeMisspelledWord(offset);
        }
        return false;
    }

    public final JPopupMenu createPopupMenu(int x, int y, int maxSuggestions, String ignoreAllLabel, String addLabel, String noSuggestionsLabel) {
        if (!this.isInWord(x, y)) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        this.fillPopupMenu(menu, x, y, maxSuggestions, ignoreAllLabel, addLabel, noSuggestionsLabel);
        return menu;
    }

    public final boolean fillPopupMenu(JPopupMenu menu, int x, int y, int maxSuggestions, String ignoreAllLabel, String addLabel, String noSuggestionsLabel) {
        TextUI ui = this.component.getUI();
        Point pt = new Point(x, y);
        int offset = ui.viewToModel(this.component, pt);
        StringBuffer word = new StringBuffer();
        int wordStartPos = this.getWordAt(offset, word);
        SuggestionSet suggestions = new SuggestionSet(maxSuggestions);
        this.sentry.suggest(word.toString(), this.sentry.getMinSuggestDepth(), this.sentry.getComparator(), suggestions);
        if (suggestions.size() > 0) {
            for (int i = 0; i < suggestions.size(); ++i) {
                menu.add(new ReplaceWordAction(suggestions.wordAt(i), wordStartPos, word.length()));
            }
            menu.addSeparator();
        } else if (noSuggestionsLabel != null) {
            JMenuItem item = new JMenuItem(noSuggestionsLabel);
            item.setEnabled(false);
            menu.add(item);
            menu.addSeparator();
        }
        if (ignoreAllLabel != null) {
            menu.add(new IgnoreAllAction(ignoreAllLabel, word.toString()));
        }
        if (addLabel != null && this.userDictionary != null) {
            menu.add(new AddWordAction(addLabel, word.toString()));
        }
        return wordStartPos >= 0;
    }

    public final void insertUpdate(DocumentEvent ev) {
        if (this.busy) {
            return;
        }
        this.busy = true;
        int nInserted = ev.getLength();
        int cp = ev.getOffset();
        if (nInserted == 1) {
            int prevCp = cp - nInserted;
            StringBuffer word = new StringBuffer();
            int wordStartPos = -1;
            char cPrev = '\u0000';
            char cTyped = '\u0000';
            try {
                if (prevCp >= 0) {
                    cPrev = this.component.getText(prevCp, 1).charAt(0);
                }
                if (cp >= 0) {
                    cTyped = this.component.getText(cp, 1).charAt(0);
                }
            }
            catch (BadLocationException e) {
                LOG.debug((Object)e);
            }
            boolean cPrevIsWord = this.isWordChar(cPrev);
            boolean cTypedIsWord = this.isWordChar(cTyped);
            boolean recheckWord = false;
            int wordPos = cp;
            if (cTypedIsWord) {
                if (this.isInMisspelledWord(prevCp, cp)) {
                    recheckWord = true;
                } else if (!this.isInMisspelledWord(cp) && this.findMisspelledWord(cp + 1, cp + 1) != null) {
                    recheckWord = true;
                    try {
                        this.findMisspelledWord(cp + 1, cp + 1).setOffset(cp);
                    }
                    catch (BadLocationException e) {
                        LOG.debug((Object)("Can't happen!: " + e));
                    }
                }
            } else if (cPrevIsWord) {
                wordPos = prevCp;
                recheckWord = true;
                char cNext = '\u0000';
                try {
                    cNext = this.component.getText(cp + 1, 1).charAt(0);
                }
                catch (BadLocationException e) {
                    LOG.debug((Object)e);
                }
                if (this.isWordChar(cNext)) {
                    wordStartPos = this.getWordAt(cp + 1, word);
                    this.checkWord(word.toString(), wordStartPos);
                }
            }
            if (recheckWord) {
                wordStartPos = this.getWordAt(wordPos, word);
                this.checkWord(word.toString(), wordStartPos);
            }
        } else {
            this.onInsertText(cp, nInserted);
        }
        this.busy = false;
    }

    public final boolean isInMisspelledWord(Point pt) {
        TextUI ui = this.component.getUI();
        int offset = ui.viewToModel(this.component, pt);
        return this.isInMisspelledWord(offset);
    }

    public final void recheckAll() {
        String text = null;
        try {
            text = this.component.getDocument().getText(0, this.component.getDocument().getLength());
        }
        catch (BadLocationException e) {
            return;
        }
        StringWordParser parser = new StringWordParser(text, !this.sentry.getOption(4096));
        while (parser.hasMoreElements()) {
            this.checkWord(parser.getWord(), parser.getCursor());
            parser.nextWord();
        }
    }

    public final void removeMisspelledWord(int offset) {
        Enumeration<MisspelledWord> e = this.misspelledWords.elements();
        while (e.hasMoreElements()) {
            MisspelledWord mw = e.nextElement();
            int o = mw.getOffset();
            int len = mw.getLen();
            if (offset < o || offset >= o + len) continue;
            mw.hide();
            this.misspelledWords.removeElement(mw);
            break;
        }
    }

    public final void removeUpdate(DocumentEvent ev) {
        if (this.busy) {
            return;
        }
        this.busy = true;
        int cp = ev.getOffset();
        boolean recheckWord = false;
        int wordPos = cp;
        if (this.isInMisspelledWord(cp)) {
            recheckWord = true;
        }
        if (cp > 0 && this.isInMisspelledWord(cp - 1)) {
            wordPos = cp - 1;
            recheckWord = true;
        }
        if (recheckWord) {
            StringBuffer word = new StringBuffer();
            int wordStartPos = this.getWordAt(wordPos, word);
            this.checkWord(word.toString(), wordStartPos);
        }
        this.busy = false;
    }

    public final void resume() {
        this.component.getDocument().addDocumentListener(this);
        this.component.addCaretListener(this);
    }

    public final void setUserDictionary(EditableLexicon lex) {
        this.userDictionary = lex;
    }

    public final void stop() {
        this.component.getDocument().removeDocumentListener(this);
        this.component.removeCaretListener(this);
    }

    protected final MisspelledWord findMisspelledWord(int start, int end) {
        Enumeration<MisspelledWord> e = this.misspelledWords.elements();
        while (e.hasMoreElements()) {
            MisspelledWord word = e.nextElement();
            int o = word.getOffset();
            int len = word.getLen();
            if (!(start >= o && start < o + len || end >= o && end < o + len || o >= start && o <= end) && (o + len - 1 < start || o + len - 1 > end)) continue;
            return word;
        }
        return null;
    }

    protected final int getWordAt(int offset, StringBuffer word) {
        int start;
        if (offset < 0 || offset >= this.component.getDocument().getLength()) {
            return -1;
        }
        int maxWordLen = 100;
        int chunkStart = Math.max(0, offset - 100);
        int chunkLen = Math.min(this.component.getDocument().getLength() - chunkStart, 200);
        String chunk = "";
        try {
            chunk = this.component.getText(chunkStart, chunkLen);
        }
        catch (BadLocationException e) {
            return -1;
        }
        word.setLength(0);
        int relOffset = offset - chunkStart;
        if (!this.isWordChar(chunk.charAt(relOffset))) {
            return -1;
        }
        for (start = relOffset; start >= 0 && this.isWordChar(chunk.charAt(start)); --start) {
        }
        if (start < 0) {
            start = 0;
        }
        while (start < chunk.length() && !UniCharacter.isLetterOrDigit((char)chunk.charAt(start))) {
            ++start;
        }
        boolean containsEmbeddedPeriods = false;
        for (int i = start; i < chunk.length() && this.isWordChar(chunk.charAt(i)); ++i) {
            char c = chunk.charAt(i);
            word.append(c);
            if (c != '.' || i <= 0 || !UniCharacter.isLetterOrDigit((char)chunk.charAt(i - 1)) || i >= chunk.length() - 1 || !UniCharacter.isLetterOrDigit((char)chunk.charAt(i + 1))) continue;
            containsEmbeddedPeriods = true;
        }
        boolean isInitialism = false;
        if (containsEmbeddedPeriods) {
            int nWordChars = 0;
            isInitialism = true;
            for (int i = 0; i < word.length(); ++i) {
                if (UniCharacter.isLetterOrDigit((char)word.charAt(i))) {
                    if (++nWordChars <= 2) continue;
                    isInitialism = false;
                    break;
                }
                nWordChars = 0;
            }
        }
        boolean wordChanged = true;
        while (wordChanged && word.length() > 0) {
            char lastChar = word.charAt(word.length() - 1);
            wordChanged = false;
            if (UniCharacter.isApostrophe((char)lastChar) && word.length() > 1 && Character.toLowerCase(word.charAt(word.length() - 2)) != 's') {
                word.setLength(word.length() - 1);
                wordChanged = true;
            }
            if (lastChar != '.' || isInitialism) continue;
            word.setLength(word.length() - 1);
            wordChanged = true;
        }
        return start + chunkStart;
    }

    protected final boolean isInMisspelledWord(int start, int end) {
        return this.findMisspelledWord(start, end) != null;
    }

    protected final boolean isInMisspelledWord(int offset) {
        return this.isInMisspelledWord(offset, offset);
    }

    protected final boolean isInWord(int x, int y) {
        Point pt;
        TextUI ui = this.component.getUI();
        int offset = ui.viewToModel(this.component, pt = new Point(x, y));
        if (offset == -1) {
            return false;
        }
        String text = null;
        try {
            text = this.component.getText(offset, 1);
        }
        catch (BadLocationException e) {
            LOG.debug((Object)e);
        }
        return text != null && text.length() != 0 && this.isWordChar(text.charAt(0));
    }

    protected final boolean isWordChar(char c) {
        return UniCharacter.isLetterOrDigit((char)c) || UniCharacter.isApostrophe((char)c) || c == '.';
    }

    protected final void onInsertText(int offset, int nChars) {
        StringBuffer firstWord = new StringBuffer();
        StringBuffer lastWord = new StringBuffer();
        int firstWordStartPos = this.getWordAt(offset, firstWord);
        int lastWordStartPos = this.getWordAt(offset + nChars - 1, lastWord);
        int start = offset;
        int end = offset + nChars;
        if (firstWordStartPos >= 0) {
            start = firstWordStartPos;
        }
        if (lastWordStartPos >= 0) {
            end = lastWordStartPos + lastWord.length();
        }
        if (firstWordStartPos >= 0 && lastWordStartPos >= 0 && firstWordStartPos == lastWordStartPos) {
            this.checkWord(firstWord.toString(), firstWordStartPos);
            return;
        }
        String text = null;
        try {
            text = this.component.getText(start, end - start);
        }
        catch (BadLocationException e) {
            LOG.debug((Object)("Can't happen! " + e));
            return;
        }
        StringWordParser parser = new StringWordParser(text, !this.sentry.getOption(4096));
        StringBuffer otherWord = new StringBuffer();
        while (this.sentry.check((WordParser)parser, otherWord) != 8) {
            this.checkWord(parser.getWord(), offset + parser.getCursor());
            parser.nextWord();
        }
    }

    public final void recheckAll(String word) {
        String text = null;
        try {
            text = this.component.getDocument().getText(0, this.component.getDocument().getLength());
        }
        catch (BadLocationException e) {
            return;
        }
        StringBuffer tmpWord = new StringBuffer();
        int i = text.indexOf(word);
        while (i >= 0) {
            int wordStartPos = this.getWordAt(i, tmpWord);
            this.checkWord(tmpWord.toString(), wordStartPos);
            i = text.indexOf(word, i + word.length());
        }
    }

    public final EditableLexicon getUserDictionary() {
        return this.userDictionary;
    }

    public final Highlighter.HighlightPainter getHighlightPainter() {
        return this.highlightPainter;
    }

    class ReplaceWordAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final transient int len;
        private final transient int offset;

        public ReplaceWordAction(String word, int offsetIn, int lenIn) {
            super(word);
            this.offset = offsetIn;
            this.len = lenIn;
        }

        public void actionPerformed(ActionEvent e) {
            BackgroundChecker.this.removeMisspelledWord(this.offset);
            AttributeSet attrs = null;
            if (BackgroundChecker.this.component.getDocument() instanceof StyledDocument) {
                attrs = ((StyledDocument)BackgroundChecker.this.component.getDocument()).getCharacterElement(this.offset).getAttributes();
            }
            try {
                BackgroundChecker.this.component.getDocument().remove(this.offset, this.len);
                BackgroundChecker.this.component.getDocument().insertString(this.offset, e.getActionCommand(), attrs);
            }
            catch (BadLocationException ex) {
                LOG.info((Object)e);
            }
        }
    }

    class IgnoreAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final transient String word;

        public IgnoreAllAction(String label, String wordIn) {
            super(label);
            this.word = wordIn;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                BackgroundChecker.this.sentry.getTempLexicon().addWord(this.word);
            }
            catch (Exception ex) {
                LOG.error((Object)("Can't add " + this.word + ": " + ex));
            }
            BackgroundChecker.this.recheckAll(this.word);
        }
    }

    class AddWordAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final transient String word;

        public AddWordAction(String label, String wordIn) {
            super(label);
            this.word = wordIn;
        }

        public void actionPerformed(ActionEvent e) {
            if (BackgroundChecker.this.userDictionary == null) {
                return;
            }
            try {
                BackgroundChecker.this.userDictionary.addWord(this.word, 105, null);
            }
            catch (Exception ex) {
                LOG.error((Object)("Can't add " + this.word + ": " + ex));
            }
            BackgroundChecker.this.recheckAll(this.word);
        }
    }

    protected static class ZigZagHighlightPainter
    implements Highlighter.HighlightPainter {
        private static final int ZIGZAG_HEIGHT = 3;
        private Color color;

        public ZigZagHighlightPainter(Color c) {
            this.color = c;
        }

        public final void paint(Graphics g, int start, int end, Shape bounds, JTextComponent component) {
            TextUI ui = component.getUI();
            try {
                Rectangle rStart = ui.modelToView(component, start);
                Rectangle rEnd = ui.modelToView(component, end);
                Rectangle rBounds = bounds.getBounds();
                int xStart = rStart.x;
                int xEnd = rEnd.x;
                int yStart = rStart.y;
                int yEnd = rEnd.y;
                int yStartBase = yStart + rStart.height - 3;
                int yEndBase = yEnd + rEnd.height - 3;
                g.setColor(this.color);
                if (yStart == yEnd || rStart.height == 0) {
                    this.zigzag(g, xStart, xEnd, yStartBase);
                } else {
                    this.zigzag(g, xStart, rBounds.x + rBounds.width - xStart, yStartBase);
                    for (int line = yStartBase + 1 + rStart.height; line < yEnd; line += rStart.height) {
                        this.zigzag(g, rBounds.x, rBounds.x + rBounds.width, line - 1);
                    }
                    this.zigzag(g, rBounds.x, xEnd, yEndBase);
                }
            }
            catch (BadLocationException e) {
                LOG.debug((Object)e);
            }
        }

        public final void setColor(Color c) {
            this.color = c;
        }

        protected final void zigzag(Graphics g, int xStart, int xEnd, int y) {
            for (int x = xStart; x < xEnd; x += 2) {
                g.drawLine(x, y, Math.min(x + 3 - 1, xEnd), y + 3 - 1);
                g.drawLine(x += 2, y + 3 - 1, Math.min(x + 3 - 1, xEnd), y);
            }
        }
    }

    public class MisspelledWord {
        private int len;
        private transient Position pos;
        private final transient Object tag;

        public MisspelledWord(String word, int offset) throws BadLocationException {
            this.pos = BackgroundChecker.this.component.getDocument().createPosition(offset);
            this.tag = BackgroundChecker.this.component.getHighlighter().addHighlight(offset, offset + word.length(), BackgroundChecker.this.highlightPainter);
            this.len = word.length();
        }

        public final int getLen() {
            return this.len;
        }

        public final int getOffset() {
            return this.pos.getOffset();
        }

        public final String getWord() {
            String w = "";
            try {
                w = BackgroundChecker.this.component.getText(this.pos.getOffset(), this.len);
            }
            catch (BadLocationException e) {
                LOG.error((Object)e);
            }
            return w;
        }

        public final void hide() {
            BackgroundChecker.this.component.getHighlighter().removeHighlight(this.tag);
            this.len = 0;
        }

        public final void setLen(int lenIn) throws BadLocationException {
            this.len = lenIn;
            int o = this.getOffset();
            BackgroundChecker.this.component.getHighlighter().changeHighlight(this.tag, o, o + lenIn);
        }

        public final void setOffset(int offset) throws BadLocationException {
            this.pos = BackgroundChecker.this.component.getDocument().createPosition(offset);
        }
    }
}

