/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.spellchecker.wintertree;

import com.wintertree.ssce.CompressedLexicon;
import com.wintertree.ssce.EnglishPhoneticComparator;
import com.wintertree.ssce.FileTextLexicon;
import com.wintertree.ssce.Lexicon;
import com.wintertree.ssce.MemTextLexicon;
import com.wintertree.ssce.SpellingSession;
import com.wintertree.ssce.TypographicalComparator;
import com.wintertree.ssce.WordComparator;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class PropSpellingSession
extends SpellingSession {
    private static final Logger LOG = Logger.getLogger(PropSpellingSession.class);
    private static final long serialVersionUID = 1L;
    private transient URL codeBase;
    private WordComparator comparator;
    private transient String mainLexPath = null;
    private int minSuggestDepth;
    private transient Properties properties;
    private transient String propertyPrefix = "";
    private transient int tempLexiconX;
    private transient FileTextLexicon[] userLexicons;
    private transient String userLexPath = null;

    public PropSpellingSession(Properties properties1, String lexPath) {
        String s5;
        String s4;
        this.properties = properties1;
        this.codeBase = null;
        this.propertyPrefix = null;
        this.mainLexPath = null;
        this.userLexPath = null;
        ArrayList<Object> vector = new ArrayList<Object>();
        MemTextLexicon memtextlexicon = new MemTextLexicon();
        vector.add(memtextlexicon);
        this.tempLexiconX = 0;
        String s3 = "";
        ArrayList<Lexicon> vector1 = new ArrayList<Lexicon>();
        for (int i = 1; i < 99 && null != (s4 = properties1.getProperty("UserLexicon" + i)); ++i) {
            StringTokenizer stringtokenizer = new StringTokenizer(s4, ",");
            String s7 = "";
            if (lexPath != null) {
                s7 = lexPath;
            }
            s7 = s7 + stringtokenizer.nextToken();
            String s9 = "file";
            if (stringtokenizer.hasMoreTokens()) {
                s9 = stringtokenizer.nextToken();
            }
            String s11 = "T";
            Lexicon lexicon = this.openLex(s7, s9, "T", null);
            if (lexicon == null) continue;
            vector.add(lexicon);
            if (!(lexicon instanceof FileTextLexicon)) continue;
            vector1.add(lexicon);
        }
        this.userLexicons = null;
        if (!vector1.isEmpty()) {
            this.userLexicons = new FileTextLexicon[vector1.size()];
            vector1.toArray(this.userLexicons);
        }
        for (int j = 1; j < 99 && null != (s5 = properties1.getProperty("MainLexicon" + j)); ++j) {
            String s12;
            Lexicon lexicon1;
            StringTokenizer stringtokenizer1 = new StringTokenizer(s5, ",");
            String s8 = "";
            if (lexPath != null) {
                s8 = lexPath;
            }
            s8 = s8 + stringtokenizer1.nextToken();
            String s10 = "file";
            if (stringtokenizer1.hasMoreTokens()) {
                s10 = stringtokenizer1.nextToken();
            }
            if ((lexicon1 = this.openLex(s8, s10, s12 = null, null)) == null) continue;
            vector.add(lexicon1);
        }
        Lexicon[] alexicon = new Lexicon[vector.size()];
        vector.toArray(alexicon);
        this.setLexicons(alexicon);
        String s6 = properties1.getProperty("CASE_SENSITIVE_OPT");
        if (s6 != null) {
            this.setOption(1, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("IGNORE_ALL_CAPS_WORD_OPT")) != null) {
            this.setOption(2, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("IGNORE_CAPPED_WORD_OPT")) != null) {
            this.setOption(4, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("IGNORE_MIXED_CASE_OPT")) != null) {
            this.setOption(8, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("IGNORE_MIXED_DIGITS_OPT")) != null) {
            this.setOption(16, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("IGNORE_NON_ALPHA_WORD_OPT")) != null) {
            this.setOption(32, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("REPORT_DOUBLED_WORD_OPT")) != null) {
            this.setOption(64, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("REPORT_MIXED_CASE_OPT")) != null) {
            this.setOption(128, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("REPORT_MIXED_DIGITS_OPT")) != null) {
            this.setOption(256, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("REPORT_UNCAPPED_OPT")) != null) {
            this.setOption(1024, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("SPLIT_CONTRACTED_WORDS_OPT")) != null) {
            this.setOption(2048, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("SPLIT_HYPHENATED_WORDS_OPT")) != null) {
            this.setOption(4096, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("SPLIT_WORDS_OPT")) != null) {
            this.setOption(8192, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("STRIP_POSSESSIVES_OPT")) != null) {
            this.setOption(16384, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("SUGGEST_SPLIT_WORDS_OPT")) != null) {
            this.setOption(32768, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("IGNORE_DOMAIN_NAMES_OPT")) != null) {
            this.setOption(65536, Boolean.parseBoolean(s6));
        }
        if ((s6 = properties1.getProperty("ALLOW_ACCENTED_CAPS_OPT")) != null) {
            this.setOption(131072, Boolean.parseBoolean(s6));
        }
        this.minSuggestDepth = 50;
        s6 = properties1.getProperty("MinSuggestDepth");
        if (s6 != null) {
            this.minSuggestDepth = Integer.parseInt(s6);
        }
        this.comparator = (s6 = properties1.getProperty("Suggestions")) != null && s6.equalsIgnoreCase("Phonetic") ? new EnglishPhoneticComparator() : new TypographicalComparator();
    }

    public final Object clone() {
        PropSpellingSession propspellingsession = (PropSpellingSession)((Object)super.clone());
        propspellingsession.codeBase = this.codeBase;
        propspellingsession.comparator = this.comparator;
        propspellingsession.mainLexPath = this.mainLexPath;
        propspellingsession.minSuggestDepth = this.minSuggestDepth;
        propspellingsession.tempLexiconX = this.tempLexiconX;
        propspellingsession.properties = this.properties != null ? new Properties(this.properties) : null;
        propspellingsession.propertyPrefix = this.propertyPrefix;
        if (this.userLexicons != null) {
            propspellingsession.userLexicons = new FileTextLexicon[this.userLexicons.length];
            System.arraycopy(this.userLexicons, 0, propspellingsession.userLexicons, 0, propspellingsession.userLexicons.length);
        } else {
            propspellingsession.userLexicons = null;
        }
        propspellingsession.userLexPath = this.userLexPath;
        return propspellingsession;
    }

    public final WordComparator getComparator() {
        return this.comparator;
    }

    public final int getMinSuggestDepth() {
        return this.minSuggestDepth;
    }

    public final Properties getProperties() {
        this.properties.put("CASE_SENSITIVE_OPT", String.valueOf(this.getOption(1)));
        this.properties.put("IGNORE_ALL_CAPS_WORD_OPT", String.valueOf(this.getOption(2)));
        this.properties.put("IGNORE_CAPPED_WORD_OPT", String.valueOf(this.getOption(4)));
        this.properties.put("IGNORE_MIXED_CASE_OPT", String.valueOf(this.getOption(8)));
        this.properties.put("IGNORE_MIXED_DIGITS_OPT", String.valueOf(this.getOption(16)));
        this.properties.put("IGNORE_NON_ALPHA_WORD_OPT", String.valueOf(this.getOption(32)));
        this.properties.put("REPORT_DOUBLED_WORD_OPT", String.valueOf(this.getOption(64)));
        this.properties.put("REPORT_MIXED_CASE_OPT", String.valueOf(this.getOption(128)));
        this.properties.put("REPORT_MIXED_DIGITS_OPT", String.valueOf(this.getOption(256)));
        this.properties.put("REPORT_UNCAPPED_OPT", String.valueOf(this.getOption(1024)));
        this.properties.put("SPLIT_CONTRACTED_WORDS_OPT", String.valueOf(this.getOption(2048)));
        this.properties.put("SPLIT_HYPHENATED_WORDS_OPT", String.valueOf(this.getOption(4096)));
        this.properties.put("SPLIT_WORDS_OPT", String.valueOf(this.getOption(8192)));
        this.properties.put("STRIP_POSSESSIVES_OPT", String.valueOf(this.getOption(16384)));
        this.properties.put("SUGGEST_SPLIT_WORDS_OPT", String.valueOf(this.getOption(32768)));
        this.properties.put("IGNORE_DOMAIN_NAMES_OPT", String.valueOf(this.getOption(65536)));
        this.properties.put("ALLOW_ACCENTED_CAPS_OPT", String.valueOf(this.getOption(131072)));
        this.properties.put("MinSuggestDepth", String.valueOf(this.minSuggestDepth));
        if (this.comparator instanceof EnglishPhoneticComparator) {
            this.properties.put("Comparator", "Phonetic");
        } else {
            this.properties.put("Comparator", "Typographical");
        }
        return this.properties;
    }

    public final MemTextLexicon getTempLexicon() {
        Lexicon[] alexicon = this.getLexicons();
        return (MemTextLexicon)alexicon[this.tempLexiconX];
    }

    public final FileTextLexicon[] getUserLexicons() {
        return this.userLexicons;
    }

    public final void setComparator(WordComparator wordcomparator) {
        this.comparator = wordcomparator;
    }

    public final void setLexicons(Lexicon[] alexicon) {
        Lexicon[] alexicon1 = new Lexicon[alexicon.length + 1];
        System.arraycopy(alexicon, 0, alexicon1, 0, alexicon.length);
        this.tempLexiconX = alexicon.length;
        alexicon1[this.tempLexiconX] = new MemTextLexicon();
        super.setLexicons(alexicon1);
    }

    public final void setMinSuggestDepth(int i) {
        this.minSuggestDepth = i;
    }

    protected final Lexicon openLex(String s, String s1, String s2, String s3) {
        Object obj = null;
        try {
            if (s1.equalsIgnoreCase("file")) {
                String tempS = s;
                String tempS2 = s2;
                String tempS3 = s3;
                if (s3 != null && s.indexOf(File.separator) < 0) {
                    if (!s3.endsWith(File.separator)) {
                        tempS3 = s3 + File.separator;
                    }
                    tempS = tempS3 + tempS;
                }
                if (tempS2 == null) {
                    tempS2 = CompressedLexicon.isCompressedLexicon((String)s) ? "c" : "t";
                }
                obj = tempS2.equalsIgnoreCase("c") ? new CompressedLexicon(tempS, 0) : new FileTextLexicon(tempS);
            }
        }
        catch (Exception exception) {
            LOG.debug((Object)exception);
        }
        return (Lexicon)obj;
    }
}

