/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.svg.impl;

import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.IExporterListener;
import com.thinkbuzan.gaia.export.IFileType;
import com.thinkbuzan.gaia.export.svg.impl.TextConstants;
import com.thinkbuzan.gaia.export.svg.license.IBundleLicenser;
import com.thinkbuzan.gaia.export.svg.ui.SVGExporterOptionsPanel;
import com.thinkbuzan.gaia.export.unlicensed.TrialExporterPanel;
import com.thinkbuzan.gaia.export.unlicensed.UnlicensedExporterPanel;
import com.thinkbuzan.pascal.services.editor.IPainter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.ImageHandlerPNGEncoder;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SVGExporter
implements IExporter,
IFileType {
    private static final Icon ICON = new ImageIcon(SVGExporter.class.getResource("/resources/icon.png"));
    private static final String SVG_EXPORTER_ID = "com.thinkbuzan.gaia.export.svg";
    private static final String SVG_NAME_SPACE = "http://www.w3.org/2000/svg";
    private static final String SVG_NAME = "svg";
    private static final String SVG_EXTENSION = "svg";
    private static final String SVGZ_EXTENSION = "svgz";
    private static final String SVG_DESCRIPTION = "Scalable Vector Graphics File (*.svg)";
    private static final String SVGZ_DESCRIPTION = "Scalable Vector Graphics Compressed File (*.svgz)";
    private static final String IMAGES_DIR_SUFFIX = "_data";
    private static final int PROGRESS_TEN = 10;
    private static final int PROGRESS_TWENTY = 20;
    private static final int PROGRESS_THIRTY = 30;
    private static final int PROGRESS_SIXTY = 60;
    private static final int PROGRESS_COMPLETE = 100;
    private transient SVGExporterOptionsPanel optionsPanel;
    private final transient IBundleLicenser licenser;

    public SVGExporter(IBundleLicenser licenserIn) {
        this.licenser = licenserIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(IEditorComponent editorComponent, File file, IExporterListener listener) {
        this.validateNullArgument(editorComponent, "editorComponent can't be null");
        this.validateNullArgument(file, "file can't be null");
        this.validateNullArgument(listener, "listener can't be null");
        String correctedExtension = FilenameUtils.removeExtension((String)file.getAbsolutePath());
        correctedExtension = this.optionsPanel.isCompressSVG() ? correctedExtension + "." + SVGZ_EXTENSION : correctedExtension + "." + "svg";
        File outFile = new File(correctedExtension);
        IPainter painter = editorComponent.createPainter(true, false);
        painter.setBackgroundPainted(true);
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(SVG_NAME_SPACE, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        listener.exportProgress(10.0f);
        this.setEmbeddedFonts(ctx);
        listener.exportProgress(20.0f);
        try {
            this.setLinkedImages(ctx, outFile);
        }
        catch (IOException e) {
            listener.exportProgress(100.0f);
            listener.exportErrorOccurred(e.getMessage());
            return;
        }
        listener.exportProgress(30.0f);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(ctx, false);
        svgGenerator.setSVGCanvasSize(painter.getPaintBounds().getBounds().getSize());
        painter.paint((Graphics2D)svgGenerator);
        listener.exportProgress(60.0f);
        try {
            this.output(svgGenerator, outFile);
        }
        catch (IOException e) {
            listener.exportErrorOccurred(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.message.svg_export_failed"));
        }
        finally {
            listener.exportProgress(100.0f);
        }
    }

    public void export(IEditorComponent editorComponent, File outputFileIn, IExporterListener exporterListenerIn, Object ... objects) {
        boolean fontsEmbedded = false;
        boolean linksEmbedded = false;
        boolean compress = false;
        if (objects.length > 0 && objects[0] instanceof Boolean) {
            fontsEmbedded = (Boolean)objects[0];
        }
        if (objects.length > 1 && objects[1] instanceof Boolean) {
            linksEmbedded = (Boolean)objects[1];
        }
        if (objects.length > 2 && objects[2] instanceof Boolean) {
            compress = (Boolean)objects[2];
        }
        if (this.getComponent() instanceof SVGExporterOptionsPanel) {
            SVGExporterOptionsPanel exporterPanel = (SVGExporterOptionsPanel)this.getComponent();
            exporterPanel.setEmbeddedFonts(fontsEmbedded);
            exporterPanel.setEmbeddedImages(linksEmbedded);
            exporterPanel.setCompressSvg(compress);
        }
        this.export(editorComponent, outputFileIn, exporterListenerIn);
    }

    public JComponent getComponent() {
        switch (this.getLicenseState()) {
            case full: {
                if (this.optionsPanel == null) {
                    this.optionsPanel = new SVGExporterOptionsPanel();
                }
                return this.optionsPanel;
            }
            case trial: {
                return TrialExporterPanel.getInstance((I18n)TextConstants.getI18n());
            }
        }
        return UnlicensedExporterPanel.getInstance((I18n)TextConstants.getI18n());
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getId() {
        return SVG_EXPORTER_ID;
    }

    public String getName() {
        return TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.text.name");
    }

    public IFileType getOutputFileType() {
        return this;
    }

    public List<String> getDescription() {
        if (this.optionsPanel != null && this.optionsPanel.isCompressSVG()) {
            return Arrays.asList(SVGZ_DESCRIPTION);
        }
        return Arrays.asList(SVG_DESCRIPTION);
    }

    public List<String> getExtensions(String description) {
        ArrayList<String> extensions = new ArrayList<String>();
        if (this.optionsPanel != null && this.optionsPanel.isCompressSVG()) {
            extensions.add(SVGZ_EXTENSION);
        } else {
            extensions.add("svg");
        }
        return extensions;
    }

    public boolean isFolder() {
        return false;
    }

    private void setEmbeddedFonts(SVGGeneratorContext ctx) {
        if (this.optionsPanel == null || this.optionsPanel.isEmbeddedFonts()) {
            ctx.setEmbeddedFontsOn(true);
        } else {
            ctx.setEmbeddedFontsOn(false);
        }
    }

    private void setLinkedImages(SVGGeneratorContext ctx, File svgFile) throws IOException {
        if (this.optionsPanel != null && !this.optionsPanel.isEmbeddedImages()) {
            File imagesFile = this.getOutputImagesFile(svgFile);
            if (imagesFile.exists()) {
                throw new IOException(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.message.output_images_dir_exists"));
            }
            if (!imagesFile.mkdirs()) {
                throw new IOException(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.message.create_images_dir_failed"));
            }
            try {
                ctx.setImageHandler((ImageHandler)new ImageHandlerPNGEncoder(imagesFile.getPath(), null));
            }
            catch (SVGGraphics2DIOException ex) {
                ex.printStackTrace();
                throw new IOException(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.message.create_images_dir_failed"));
            }
        }
    }

    private File getOutputImagesFile(File svgFile) {
        String dirName = svgFile.getName();
        int index = dirName.lastIndexOf(46);
        if (index > -1) {
            dirName = dirName.substring(0, index);
        }
        return new File(svgFile.getParentFile(), dirName + IMAGES_DIR_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(SVGGraphics2D svgGenerator, File svgFile) throws IOException {
        OutputStream os = null;
        try {
            os = new FileOutputStream(svgFile);
            if (this.optionsPanel != null && this.optionsPanel.isCompressSVG()) {
                os = new GZIPOutputStream(os);
            }
            svgGenerator.stream((Writer)new OutputStreamWriter(os, "UTF-8"), false);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        }
    }

    private void validateNullArgument(Object arg, String message) {
        if (arg == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public Category.CategoryId getCategoryId() {
        return Category.CategoryId.SVG;
    }

    public IExporter.LicenseState getLicenseState() {
        return this.licenser.getSVGExporterState();
    }
}

