/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.svg.impl;

import com.thinkbuzan.chaos.internationalization.I18n;

public final class TextConstants {
    public static final String NAEME_TEXT_KEY = "com.thinkbuzan.i18n.svgexport.text.name";
    public static final String DESCRIPTION_TEXT_KEY = "com.thinkbuzan.i18n.svgexport.text.description";
    public static final String EMBEDDING_TEXT_KEY = "com.thinkbuzan.i18n.svgexport.text.embedding";
    public static final String FONTS_TEXT_KEY = "com.thinkbuzan.i18n.svgexport.text.fonts";
    public static final String IMAGES_TEXT_KEY = "com.thinkbuzan.i18n.svgexport.text.Images";
    public static final String EMBEDDED_TEXT_KEY = "com.thinkbuzan.i18n.svgexport.text.embedded";
    public static final String LINK_TEXT_KEY = "com.thinkbuzan.i18n.svgexport.text.link";
    public static final String COMPRESSION_TEXT_KEY = "com.thinkbuzan.i18n.svgexport.text.compression";
    public static final String COMPRESS_TEXT_KEY = "com.thinkbuzan.i18n.svgexport.text.compress";
    public static final String FONTS_EMBEDDED_TOOLTIP_KEY = "com.thinkbuzan.i18n.svgexport.tooltip.fonts_embedded";
    public static final String FONTS_LINK_TOOLTIP_KEY = "com.thinkbuzan.i18n.svgexport.tooltip.fonts_link";
    public static final String IMAGES_IMBEDDED_TOOLTIP_KEY = "com.thinkbuzan.i18n.svgexport.tooltip.images_embedded";
    public static final String IMAGES_LINK_TOOLTIP_KEY = "com.thinkbuzan.i18n.svgexport.tooltip.images_link";
    public static final String COMPRESS_TOOLTIP_KEY = "com.thinkbuzan.i18n.svgexport.tooltip.compress";
    public static final String IMAGES_DIR_EXISTS_MSG_KEY = "com.thinkbuzan.i18n.svgexport.message.output_images_dir_exists";
    public static final String CREATE_IMAGES_DIR_FAILED_MSG_KEY = "com.thinkbuzan.i18n.svgexport.message.create_images_dir_failed";
    public static final String EXPORT_SVG_FAILED_MSG_KEY = "com.thinkbuzan.i18n.svgexport.message.svg_export_failed";
    private static I18n i18n;

    private TextConstants() {
    }

    public static void setI18n(I18n i18nIn) {
        TextConstants.validateNullArgument(i18nIn, "i18n can not be null");
        i18n = i18nIn;
    }

    public static I18n getI18n() {
        return i18n;
    }

    public static String getLocalizedText(String key) {
        TextConstants.validateEmptyString(key, "key can not be null or empty string");
        if (i18n != null) {
            return i18n.getLocalizedText(key);
        }
        return "!" + key + "!";
    }

    private static void validateNullArgument(Object arg, String message) {
        if (arg == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void validateEmptyString(String arg, String message) {
        if (arg == null || arg.equals("")) {
            throw new IllegalArgumentException(message);
        }
    }
}

