/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.svg.osgi;

import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.export.ExportManager;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.svg.impl.SVGExporter;
import com.thinkbuzan.gaia.export.svg.impl.TextBundleImpl;
import com.thinkbuzan.gaia.export.svg.impl.TextConstants;
import com.thinkbuzan.gaia.export.svg.license.BundleLicenser;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class OSGiManager
implements BundleActivator {
    public void start(BundleContext context) {
        long start = System.currentTimeMillis();
        BundleLicenser licenser = new BundleLicenser(context);
        OSGiService i18nService = new OSGiService(context, I18n.class);
        I18n i18n = (I18n)i18nService.get();
        i18n.register((ITextBundle)new TextBundleImpl());
        TextConstants.setI18n(i18n);
        OSGiService exportManagerService = new OSGiService(context, ExportManager.class);
        ((ExportManager)exportManagerService.get()).register((IExporter)new SVGExporter(licenser));
        i18nService.close();
        exportManagerService.close();
        long end = System.currentTimeMillis();
        Logger.getLogger(OSGiManager.class).debug((Object)String.format("[BUNDLESTARTTIME] duration=%s, start=%s, end=%s", end - start, start, end));
    }

    public void stop(BundleContext context) {
    }
}

