/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.svg.ui;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.export.svg.impl.TextConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class SVGExporterOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -9038846905867932482L;
    private static final int HORIZONTAL_GAP = 5;
    private static final int SECTION_TITLE_LABEL_FONT_STYLE = 0;
    private static final float SECTION_TITLE_LABEL_FONT_SIZE = 14.0f;
    private static final Color SECTION_TITLE_LABEL_COLOUR = Color.decode("#484852");
    private static final Dimension VERTICAL_RIGID_COMPONENT_SPACING = new Dimension(0, 30);
    private static final Dimension VERTICAL_RIGID_AREA_SPACING = new Dimension(0, 4);
    private transient JRadioButton embeddedFonts;
    private transient JRadioButton linkFonts;
    private transient JRadioButton embeddedImages;
    private transient JRadioButton linkImages;
    private transient JCheckBox compressSVG;

    public SVGExporterOptionsPanel() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.initComponents();
        this.setDefaultOptions();
        JPanel outerPanel = new JPanel(new GridLayout(1, 2), false);
        outerPanel.setOpaque(false);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.setOpaque(false);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setOpaque(false);
        mainPanel.add(this.makeEmbeddingPanel());
        mainPanel.add(Box.createRigidArea(VERTICAL_RIGID_COMPONENT_SPACING));
        mainPanel.add(this.makeCompressionPanel());
        mainPanel.add(Box.createVerticalGlue());
        leftPanel.add((Component)mainPanel, "North");
        outerPanel.add(leftPanel);
        this.add(outerPanel);
    }

    public void setDefaultOptions() {
        this.embeddedFonts.setSelected(true);
        this.embeddedImages.setSelected(true);
        this.compressSVG.setSelected(false);
    }

    public boolean isEmbeddedFonts() {
        return this.embeddedFonts.isSelected();
    }

    public boolean isEmbeddedImages() {
        return this.embeddedImages.isSelected();
    }

    public boolean isCompressSVG() {
        return this.compressSVG.isSelected();
    }

    public void setEmbeddedFonts(boolean selected) {
        this.embeddedFonts.setSelected(selected);
    }

    public void setEmbeddedImages(boolean selected) {
        this.embeddedImages.setSelected(selected);
    }

    public void setCompressSvg(boolean selected) {
        this.compressSVG.setSelected(selected);
    }

    private void initComponents() {
        this.embeddedFonts = CoreUIFactory.createRadioButton((String)TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.text.embedded"));
        this.embeddedFonts.setToolTipText(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.tooltip.fonts_embedded"));
        this.embeddedFonts.setName("embedded_fonts");
        this.linkFonts = CoreUIFactory.createRadioButton((String)TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.text.link"));
        this.linkFonts.setToolTipText(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.tooltip.fonts_link"));
        this.linkFonts.setName("link_fonts");
        this.embeddedImages = CoreUIFactory.createRadioButton((String)TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.text.embedded"));
        this.embeddedImages.setToolTipText(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.tooltip.images_embedded"));
        this.embeddedImages.setName("embedded_images");
        this.linkImages = CoreUIFactory.createRadioButton((String)TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.text.link"));
        this.linkImages.setToolTipText(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.tooltip.images_link"));
        this.linkImages.setName("link_images");
        this.compressSVG = CoreUIFactory.createCheckBox((String)TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.text.compress"));
        this.compressSVG.setToolTipText(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.tooltip.compress"));
        this.compressSVG.setName("compress");
        ButtonGroup fontsButtonGroup = new ButtonGroup();
        ButtonGroup imagesButtonGroup = new ButtonGroup();
        fontsButtonGroup.add(this.embeddedFonts);
        fontsButtonGroup.add(this.linkFonts);
        imagesButtonGroup.add(this.embeddedImages);
        imagesButtonGroup.add(this.linkImages);
        this.embeddedFonts.setOpaque(false);
        this.linkFonts.setOpaque(false);
        this.embeddedImages.setOpaque(false);
        this.linkImages.setOpaque(false);
        this.compressSVG.setOpaque(false);
    }

    private JPanel makeEmbeddingPanel() {
        JPanel embeddingPanel = new JPanel();
        embeddingPanel.setOpaque(false);
        embeddingPanel.setLayout(new BoxLayout(embeddingPanel, 1));
        JPanel titlePanel = new JPanel(new FlowLayout(0, 0, 0), false);
        titlePanel.setOpaque(false);
        JLabel titleLabel = new JLabel(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.text.embedding"));
        titleLabel.setForeground(SECTION_TITLE_LABEL_COLOUR);
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        titlePanel.add(titleLabel);
        JLabel fontsLabel = new JLabel(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.text.fonts"));
        JLabel imagesLabel = new JLabel(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.text.Images"));
        if (fontsLabel.getPreferredSize().width < imagesLabel.getPreferredSize().width) {
            fontsLabel.setPreferredSize(imagesLabel.getPreferredSize());
        } else {
            imagesLabel.setPreferredSize(fontsLabel.getPreferredSize());
        }
        fontsLabel.setMinimumSize(fontsLabel.getPreferredSize());
        fontsLabel.setMaximumSize(fontsLabel.getPreferredSize());
        imagesLabel.setMaximumSize(imagesLabel.getPreferredSize());
        imagesLabel.setMinimumSize(imagesLabel.getPreferredSize());
        JPanel fontsPanel = new JPanel();
        fontsPanel.setOpaque(false);
        fontsPanel.setLayout(new BoxLayout(fontsPanel, 0));
        fontsPanel.add(Box.createHorizontalStrut(5));
        fontsPanel.add(fontsLabel);
        fontsPanel.add(Box.createHorizontalStrut(5));
        fontsPanel.add(this.embeddedFonts);
        fontsPanel.add(Box.createHorizontalStrut(5));
        fontsPanel.add(this.linkFonts);
        fontsPanel.add(Box.createHorizontalGlue());
        JPanel imagesPanel = new JPanel();
        imagesPanel.setOpaque(false);
        imagesPanel.setLayout(new BoxLayout(imagesPanel, 0));
        imagesPanel.add(Box.createHorizontalStrut(5));
        imagesPanel.add(imagesLabel);
        imagesPanel.add(Box.createHorizontalStrut(5));
        imagesPanel.add(this.embeddedImages);
        imagesPanel.add(Box.createHorizontalStrut(5));
        imagesPanel.add(this.linkImages);
        imagesPanel.add(Box.createHorizontalGlue());
        embeddingPanel.add(titlePanel);
        embeddingPanel.add(Box.createRigidArea(VERTICAL_RIGID_AREA_SPACING));
        embeddingPanel.add(fontsPanel);
        embeddingPanel.add(imagesPanel);
        return embeddingPanel;
    }

    private JPanel makeCompressionPanel() {
        JPanel compressionPanel = new JPanel();
        compressionPanel.setDoubleBuffered(false);
        compressionPanel.setOpaque(false);
        compressionPanel.setLayout(new BoxLayout(compressionPanel, 1));
        JPanel titlePanel = new JPanel(new FlowLayout(0, 0, 0), false);
        titlePanel.setOpaque(false);
        JLabel titleLabel = new JLabel(TextConstants.getLocalizedText("com.thinkbuzan.i18n.svgexport.text.compression"));
        titleLabel.setForeground(SECTION_TITLE_LABEL_COLOUR);
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        titlePanel.add(titleLabel);
        JPanel compressionWrapPanel = new JPanel(new FlowLayout(0, 0, 0), false);
        compressionWrapPanel.setOpaque(false);
        compressionWrapPanel.add(this.compressSVG);
        compressionPanel.add(titlePanel);
        compressionPanel.add(Box.createRigidArea(VERTICAL_RIGID_AREA_SPACING));
        compressionPanel.add(compressionWrapPanel);
        return compressionPanel;
    }
}

