/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.startuplogger;

import com.thinkbuzan.chaos.startuplogger.SlowStartupCheck;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    protected static final transient String PREFIX = "[INFORMATION]";

    public void start(final BundleContext context) throws Exception {
        Thread loggingThread = new Thread("LoggingThread"){

            public void run() {
                Activator.this.doLogging(context);
            }
        };
        loggingThread.start();
    }

    public void stop(BundleContext context) throws Exception {
    }

    private void doLogging(BundleContext context) {
        Logger logger = Logger.getLogger(Activator.class);
        Level priority = Level.WARN;
        if (logger.isWarnEnabled()) {
            this.logSystemProperties(logger, priority);
            this.logOSGiBundles(logger, priority, context);
            this.logPrinters(logger, priority);
            this.logRuntimeInformation(logger, priority);
        }
        Thread startupCheck = new Thread((Runnable)new SlowStartupCheck(context, logger), "startup_time_check");
        startupCheck.setDaemon(true);
        startupCheck.start();
    }

    private void logRuntimeInformation(Logger logger, Level priority) {
        Runtime runtime = Runtime.getRuntime();
        double free = (double)runtime.freeMemory() / 1024.0 / 1024.0;
        double max = (double)runtime.maxMemory() / 1024.0 / 1024.0;
        double total = (double)runtime.totalMemory() / 1024.0 / 1024.0;
        String message = "%s availableProcessors=%s, freeMemory=%sMb, maxMemory=%sMb, totalMemory=%sMb";
        message = String.format(message, PREFIX, runtime.availableProcessors(), free, max, total);
        logger.log((Priority)priority, (Object)message);
        try {
            String osgiInstanceArea = System.getProperty("osgi.instance.area");
            if (osgiInstanceArea == null || "".equals(osgiInstanceArea.trim())) {
                return;
            }
            URI uri = new URI(osgiInstanceArea);
            File file = new File(uri);
            Method getFreeSpaceMethod = File.class.getDeclaredMethod("getFreeSpace", new Class[0]);
            message = "%s Free Space in \"%s\": %sMb";
            message = String.format(message, PREFIX, file, (double)((Long)getFreeSpaceMethod.invoke((Object)file, new Object[0])).longValue() / 1024.0 / 1024.0);
            logger.log((Priority)priority, (Object)message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logSystemProperties(Logger logger, Level priority) {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("os.name");
        properties.add("os.version");
        properties.add("os.arch");
        properties.add("user.language");
        properties.add("java.version");
        properties.add("java.vm.version");
        properties.add("java.runtime.version");
        properties.add("java.io.tmpdir");
        properties.add("sun.cpu.endian");
        properties.add("user.home");
        properties.add("osgi.instance.area");
        properties.add("com.thinkbuzan.chaos.install.location");
        properties.add("com.thinkbuzan.chaos.provision.location");
        properties.add("sun.java2d.d3d");
        String message = "%s \"%s\" = %s";
        for (String property : properties) {
            String value = System.getProperty(property);
            String valueString = value == null ? "null" : String.format("\"%s\"", value);
            logger.log((Priority)priority, (Object)String.format("%s \"%s\" = %s", PREFIX, property, valueString));
        }
        logger.log((Priority)priority, (Object)String.format("%s \"%s\" = %s", PREFIX, "licensing.licensepath", String.valueOf(System.getProperty("com.thinkbuzan.phoenix.licensing.licensepath"))));
    }

    private void logOSGiBundles(Logger logger, Level priority, BundleContext context) {
        if (context == null) {
            return;
        }
        Bundle[] bundles = context.getBundles();
        logger.log((Priority)priority, (Object)String.format("%s There are %s Bundles", PREFIX, bundles.length));
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            String message = this.bundleToString(bundle);
            logger.log((Priority)priority, (Object)String.format("%s Bundle %s = %s", PREFIX, i, message));
        }
    }

    private void logPrinters(Logger logger, Level priority) {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        logger.log((Priority)priority, (Object)String.format("%s There are %s PrintServices", PREFIX, printServices.length));
        for (int i = 0; i < printServices.length; ++i) {
            String printServiceName = printServices[i] == null ? "null" : printServices[i].getName();
            String message = String.format("%s PrintService %s = \"%s\"", PREFIX, i, printServiceName);
            logger.log((Priority)priority, (Object)message);
        }
    }

    private String bundleToString(Bundle bundle) {
        String message;
        if (bundle == null) {
            message = "null";
        } else {
            String symbolicName = bundle.getSymbolicName();
            String stateString = this.getStateString(bundle.getState());
            String version = bundle.getVersion() == null ? "null" : bundle.getVersion().toString();
            String location = bundle.getLocation();
            message = String.format("state=%s, symbolicName=%s, version=%s, location=%s", stateString, symbolicName, version, location);
        }
        return message;
    }

    private String getStateString(int state) {
        String stateString = state == 1 ? "UNINSTALLED" : (state == 2 ? "INSTALLED  " : (state == 4 ? "RESOLVED   " : (state == 8 ? "STARTING   " : (state == 16 ? "STOPPED    " : (state == 32 ? "ACTIVE     " : "UNKNOWN    ")))));
        return stateString;
    }
}

