/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.startuplogger;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.phoenix.licensing.storage.PublicSecureStorage;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public final class SlowStartupCheck
implements Runnable {
    private static final long SLOW_START_THRESHOLD = 150000L;
    private static final String IMAGE_ID = "slowstartup";
    private static final String SLOWNESS_KEY = "com.thinkbuzan.startuplogger.slowStart";
    private final transient BundleContext context;
    private final transient Logger logger;
    private PreferencesService preferences;

    public SlowStartupCheck(BundleContext contextIn, Logger loggerIn) {
        if (contextIn == null) {
            throw new IllegalArgumentException("contextIn cannot be null!");
        }
        if (loggerIn == null) {
            throw new IllegalArgumentException("loggerIn cannot be null!");
        }
        this.context = contextIn;
        this.logger = loggerIn;
    }

    public void run() {
        PublicSecureStorage secureStorage = (PublicSecureStorage)new OSGiService(this.context, PublicSecureStorage.class).get();
        boolean iprShowing = Boolean.valueOf(System.getProperty("com.thinkbuzan.gaia.ipr.show", "false")) != false && Boolean.valueOf(secureStorage.getProperty("ipr.registered", "false")) == false;
        boolean startDelayed = Boolean.valueOf(System.getProperty("start.delayed", "false"));
        OSGiService preferenceService = new OSGiService(this.context, PreferencesService.class);
        this.preferences = (PreferencesService)preferenceService.get();
        if (!iprShowing && !startDelayed) {
            this.maybeDisplaySlowStartupInfo(System.currentTimeMillis());
        }
    }

    private boolean maybeDisplaySlowStartupInfo(long loadedTime) {
        boolean didShow = false;
        try {
            Object launchTimeService = null;
            this.logger.debug((Object)"About to create tracker to wait for LaunchTime service");
            ServiceTracker tracker = new ServiceTracker(this.context, "com.buzanonline.chaos.launcher.LaunchTime", null);
            tracker.open();
            this.logger.debug((Object)"waiting for LaunchTime service");
            launchTimeService = tracker.waitForService(Long.MAX_VALUE);
            this.logger.debug((Object)("waited for LaunchTime service=" + launchTimeService));
            if (launchTimeService != null) {
                Class<?> clazz = launchTimeService.getClass();
                Method method = clazz.getMethod("getTimeLaunched", new Class[0]);
                method.setAccessible(true);
                Object launchTimeObj = method.invoke(launchTimeService, new Object[0]);
                long launchTime = Long.parseLong(launchTimeObj.toString());
                if (launchTime > 0L) {
                    long totalTime = loadedTime - launchTime;
                    String value = this.preferences.getCurrentUserPreferences().get(SLOWNESS_KEY, "false");
                    boolean alreadyShown = Boolean.parseBoolean(value);
                    boolean showNotification = totalTime > 150000L && !alreadyShown;
                    this.logger.warn((Object)("[INFORMATION] totalLaunchTime = " + totalTime + " milliseconds"));
                    this.logger.debug((Object)String.format("guiShownTime=%s, launchTime=%s, Threshold=%s, showDialog=%s", loadedTime, launchTime, 150000L, showNotification));
                    if (showNotification) {
                        this.preferences.getCurrentUserPreferences().put(SLOWNESS_KEY, "true");
                        this.showSlowStartNotification();
                        didShow = true;
                    }
                } else {
                    this.logger.warn((Object)"[INFORMATION] totalLaunchTime = n/a (first launch)");
                }
            }
        }
        catch (Exception exception) {
            this.logger.warn((Object)"Exception caught displaying slow startup info box", (Throwable)exception);
        }
        return didShow;
    }

    private void showSlowStartNotification() {
        this.logger.warn((Object)"[INFORMATION] showing slow startup notification");
        OSGiService actionService = new OSGiService(this.context, ActionManager.class);
        ActionManager actionManager = (ActionManager)actionService.get();
        actionService.close();
        actionManager.runAction("com.thinkbuzan.gaia.actions.ShowSlowStartNotificationAction", new Object[0]);
    }
}

