/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.projectmanagementsync;

import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.gaia.projectmanagementsync.ExternalApplicationSynchronizer;
import com.thinkbuzan.gaia.projectmanagementsync.windows.OutlookSynchronizer;
import org.apache.log4j.Logger;

public final class SynchronizerFactory {
    private static final Logger LOGGER = Logger.getLogger(SynchronizerFactory.class);
    private static final SynchronizerFactory INSTANCE = new SynchronizerFactory();
    private transient ExternalApplicationSynchronizer externalApplicationSynchronizer;

    private SynchronizerFactory() {
    }

    public static SynchronizerFactory getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalApplicationSynchronizer getExternalApplicationSynchronizer() {
        SynchronizerFactory synchronizerFactory = INSTANCE;
        synchronized (synchronizerFactory) {
            if (this.externalApplicationSynchronizer == null) {
                if (SystemInfo.isWindows()) {
                    this.externalApplicationSynchronizer = OutlookSynchronizer.getInstance();
                } else {
                    LOGGER.warn((Object)"External app sync requested on unsupported platform");
                }
            }
        }
        return this.externalApplicationSynchronizer;
    }

    public void setExternalApplicationSynchronizer(ExternalApplicationSynchronizer externalApplicationSynchronizerIn) {
        this.externalApplicationSynchronizer = externalApplicationSynchronizerIn;
    }
}

