/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.projectmanagementsync.actions;

import com.buzanonline.chaos.systemstate.ISystemState;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.util.PropertyUtilities;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.entities.Milestone;
import com.thinkbuzan.gaia.entities.Task;
import com.thinkbuzan.gaia.projectmanagementsync.ExternalAppException;
import com.thinkbuzan.gaia.projectmanagementsync.ExternalApplicationSynchronizer;
import com.thinkbuzan.gaia.projectmanagementsync.ProjectManagementSync;
import com.thinkbuzan.gaia.projectmanagementsync.actions.AbstractOutlookAction;
import com.thinkbuzan.gaia.projectmanagementsync.osgi.OsgiServices;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class SendMilestonesToOutlookAction
extends AbstractOutlookAction {
    private static final Logger LOGGER = Logger.getLogger(SendMilestonesToOutlookAction.class);
    private static final Lock LOCK = new ReentrantLock();

    public SendMilestonesToOutlookAction(ProjectManagementSync syncService) {
        super(syncService);
    }

    public final String getId() {
        return "com.thinkbuzan.gaia.actions.SendMilestonesToOutlookAction";
    }

    public final void runAction(Object ... parameters) {
        EditorManager editorManager = OsgiServices.getEditorManager();
        if (editorManager != null) {
            IEditorComponent editorComp = null;
            try {
                editorComp = editorManager.getCurrentEditorComponent();
            }
            catch (IllegalStateException ex) {
                return;
            }
            ExternalApplicationSynchronizer externalAppSync = this.getProjectSyncService().getExternalSynchronizer();
            if (editorComp != null && externalAppSync != null) {
                SyncMilestoneThread syncMilestones = new SyncMilestoneThread(externalAppSync, editorComp);
                syncMilestones.setDaemon(true);
                syncMilestones.start();
            }
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    private final class SyncMilestoneThread
    extends Thread {
        private final transient ExternalApplicationSynchronizer externalAppSync;
        private final transient IEditorComponent editorComp;

        public SyncMilestoneThread(ExternalApplicationSynchronizer externalAppSyncIn, IEditorComponent editorCompIn) {
            super("SyncMilestoneThread");
            this.externalAppSync = externalAppSyncIn;
            this.editorComp = editorCompIn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (LOCK.tryLock()) {
                try {
                    this.sendAllMilestonesToExternal();
                }
                catch (ExternalAppException ex) {
                    SendMilestonesToOutlookAction.this.showErrorDialog();
                    LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Exception ex) {
                    SendMilestonesToOutlookAction.this.showErrorDialog();
                    LOGGER.error((Object)"Something unexpected happened", (Throwable)ex);
                }
                finally {
                    this.externalAppSync.disposeConnector();
                    LOCK.unlock();
                }
            } else {
                LOGGER.info((Object)("Ignored request to run " + this.getName() + " as already running"));
            }
        }

        private void sendAllMilestonesToExternal() throws ExternalAppException {
            List floatingIdeas = this.editorComp.getFloatingIdeas();
            ArrayList structureCells = new ArrayList();
            for (mmFloatingIdeaCell floatingIdea : floatingIdeas) {
                structureCells.addAll(floatingIdea.getDescendantsStructures());
            }
            for (mmIStructureCell structureCell : structureCells) {
                Task task = PropertyUtilities.getStructureTaskNotNull((mmIStructureCell)structureCell);
                if (!task.isMilestone() || !task.isEnabledForProjectManager()) continue;
                this.externalAppSync.synchronizeMilestone(this.getMilestoneFromTask(task));
            }
        }

        private Milestone getMilestoneFromTask(Task toConvert) {
            Milestone converted = new Milestone();
            converted.setBody(toConvert.getBody());
            converted.setChanged(toConvert.isChanged());
            converted.setDuration(0);
            converted.setHidden(toConvert.getHidden());
            converted.setNote(toConvert.getNote());
            converted.setStartTime(toConvert.getStartDate());
            converted.setSubject(toConvert.getBody());
            return converted;
        }
    }
}

