/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.projectmanagementsync.osgi;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.action.IAction;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.projectmanagementsync.ProjectManagementSync;
import com.thinkbuzan.gaia.projectmanagementsync.actions.ImportContactsFromOutlookAction;
import com.thinkbuzan.gaia.projectmanagementsync.actions.SendMilestonesToOutlookAction;
import com.thinkbuzan.gaia.projectmanagementsync.actions.SendTasksToOutlookAction;
import com.thinkbuzan.gaia.projectmanagementsync.impl.ProjectManagementSyncImpl;
import com.thinkbuzan.gaia.projectmanagementsync.license.BundleLicenser;
import com.thinkbuzan.gaia.projectmanagementsync.osgi.OsgiServices;
import com.thinkbuzan.gaia.projectmanagementsync.ui.I18nService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ProjectManagementSyncManager
implements BundleActivator {
    protected static final String BASE_NAME_OF_MESSAGES_FILE = "/i18nproperties/ProjectManagmentSyncMessages";
    private static final String UNLICENSED_ACTION_ID = "com.thinkbuzan.gaia.actions.CreateUnlicensedActionAction";
    private static final String IMPORT_CONTACTS_ACTION_ID = "com.thinkbuzan.gaia.actions.ImportContactsFromOutlookAction";
    private static final String SEND_CONTACTS_TO_OUTLOOK_ACTION_ID = "com.thinkbuzan.gaia.actions.SendTasksToOutlookAction";
    private static final String SEND_MILESTONES_TO_OUTLOOK_ACTION_ID = "com.thinkbuzan.gaia.actions.SendMilestonesToOutlookAction";

    public final void start(BundleContext context) {
        OSGiService actionManagerService = new OSGiService(context, ActionManager.class);
        OSGiService editorManagerService = new OSGiService(context, EditorManager.class);
        OsgiServices.setEditorManager((EditorManager)editorManagerService.get());
        BundleLicenser licenser = new BundleLicenser(context);
        if (licenser.isOutlookSyncLicensed()) {
            this.initI18n(context);
            ProjectManagementSyncImpl sync = new ProjectManagementSyncImpl();
            context.registerService(ProjectManagementSync.class.getName(), (Object)sync, null);
            this.registerActions((ActionManager)actionManagerService.get(), sync);
        } else {
            this.addUnlicensedActions((ActionManager)actionManagerService.get());
        }
        actionManagerService.close();
    }

    private void initI18n(BundleContext context) {
        ITextBundle bundle = new ITextBundle(){

            public ClassLoader getClassLoader() {
                return this.getClass().getClassLoader();
            }

            public String getPropertyFileBaseName() {
                return ProjectManagementSyncManager.BASE_NAME_OF_MESSAGES_FILE;
            }
        };
        OSGiService service = new OSGiService(context, I18n.class);
        I18n i18n = (I18n)service.get();
        i18n.register(bundle);
        I18nService.getInstance().put(i18n);
    }

    public void stop(BundleContext context) {
    }

    private void addUnlicensedActions(ActionManager actionManagerIn) {
        actionManagerIn.runAction(UNLICENSED_ACTION_ID, new Object[]{IMPORT_CONTACTS_ACTION_ID});
        actionManagerIn.runAction(UNLICENSED_ACTION_ID, new Object[]{SEND_CONTACTS_TO_OUTLOOK_ACTION_ID});
        actionManagerIn.runAction(UNLICENSED_ACTION_ID, new Object[]{SEND_MILESTONES_TO_OUTLOOK_ACTION_ID});
    }

    private void registerActions(ActionManager actionManagerIn, ProjectManagementSync syncServiceIn) {
        actionManagerIn.addAction((IAction)new ImportContactsFromOutlookAction(syncServiceIn));
        actionManagerIn.addAction((IAction)new SendTasksToOutlookAction(syncServiceIn));
        actionManagerIn.addAction((IAction)new SendMilestonesToOutlookAction(syncServiceIn));
    }
}

