/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.projectmanagementsync.ui;

import com.jidesoft.utils.SwingWorker;
import com.thinkbuzan.apollo.ui.core.win.component.DialogButton;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.entities.Contact;
import com.thinkbuzan.gaia.projectmanagementsync.ExternalAppException;
import com.thinkbuzan.gaia.projectmanagementsync.ExternalApplicationSynchronizer;
import com.thinkbuzan.gaia.projectmanagementsync.SynchronizerFactory;
import com.thinkbuzan.gaia.projectmanagementsync.osgi.OsgiServices;
import com.thinkbuzan.gaia.projectmanagementsync.ui.AbstractContactManagementDialog;
import com.thinkbuzan.gaia.projectmanagementsync.ui.FilterListModel;
import com.thinkbuzan.gaia.projectmanagementsync.ui.I18nService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactManagementDialog
extends AbstractContactManagementDialog {
    private static final long serialVersionUID = 2124726921393921976L;
    private static final Logger LOGGER = Logger.getLogger(ContactManagementDialog.class);
    private static final Dimension DIALOG_DIMENSION = new Dimension(600, 450);
    private static final int CONTACT_LIST_WIDHT = 150;
    private static final int CONTACT_LIST_HEIGHT = 300;
    private static final int COMMON_HORIZONTAL_BORDER_WIDHT = 10;
    private static final int COMMON_VERTICAL_BORDER_WIDHT = 20;
    private static final int MIDDLE_BUTTON_PANEL_WIDTH = 100;
    private static final int MIDDLE_BUTTON_LITTLE_GAP = 6;
    private static final int MIDDLE_BUTTON_MIDDLE_GAP = 24;
    private static final int MIDDLE_BUTTON_TOP_GAP = 40;
    private transient DialogButton addButton;
    private transient DialogButton addAllButton;
    private transient DialogButton removeButton;
    private transient DialogButton removeAllButton;
    private transient FilterListModel externalListModel;
    private transient DefaultListModel mapListModel;
    private transient JList mapContactList;
    private transient JList externalContactList;

    public ContactManagementDialog(Frame owner) {
        super(owner, I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.taskinfopanel.resource.loadFromOutlook"));
        this.setMinimumSize(DIALOG_DIMENSION);
    }

    @Override
    protected final JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setOpaque(false);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setOpaque(false);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 10, 20));
        mainPanel.add((Component)centerPanel, "Center");
        JPanel leftListPanel = new JPanel(new BorderLayout(6, 6));
        leftListPanel.setOpaque(false);
        centerPanel.add((Component)leftListPanel, "West");
        final JTextField filter = new JTextField();
        filter.setName("filter");
        leftListPanel.add((Component)filter, "North");
        this.externalListModel = new FilterListModel();
        this.mapListModel = new DefaultListModel();
        this.mapContactList = new JList(this.mapListModel);
        this.mapContactList.setName("mapContactList");
        this.externalContactList = new JList(this.externalListModel);
        this.externalContactList.setName("externalContactList");
        leftListPanel.add((Component)new JScrollPane(this.externalContactList), "Center");
        filter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ContactManagementDialog.this.externalListModel.filter(filter.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                ContactManagementDialog.this.externalListModel.filter(filter.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                ContactManagementDialog.this.externalListModel.filter(filter.getText());
            }
        });
        JPanel mainMiddleButtonPanel = new JPanel(new BorderLayout());
        mainMiddleButtonPanel.setOpaque(false);
        mainMiddleButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        centerPanel.add((Component)mainMiddleButtonPanel, "Center");
        JPanel middleButtonPanel = new JPanel();
        middleButtonPanel.setOpaque(false);
        mainMiddleButtonPanel.add((Component)middleButtonPanel, "North");
        middleButtonPanel.setLayout(new BoxLayout(middleButtonPanel, 1));
        this.addButton = new DialogButton(I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.projectmanagementsync.contactManagementDialog.add"), this.makeAddAction(this.externalListModel, this.externalContactList, this.mapListModel), DialogButton.DialogButtonColour.brightGrey);
        this.addButton.setName("addButton");
        this.addAllButton = new DialogButton(I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.projectmanagementsync.contactManagementDialog.addAll"), this.makeAddAllAction(this.externalListModel, this.mapListModel), DialogButton.DialogButtonColour.brightGrey);
        this.addAllButton.setName("addAllButton");
        this.removeButton = new DialogButton(I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.projectmanagementsync.contactManagementDialog.remove"), this.makeRemoveAction(this.externalListModel, this.mapListModel, this.mapContactList), DialogButton.DialogButtonColour.brightGrey);
        this.removeButton.setName("removeButton");
        this.removeAllButton = new DialogButton(I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.projectmanagementsync.contactManagementDialog.removeAll"), this.makeRemoveAllAction(this.externalListModel, this.mapListModel), DialogButton.DialogButtonColour.brightGrey);
        this.removeAllButton.setName("removeAllButton");
        middleButtonPanel.add(Box.createRigidArea(new Dimension(0, 40)));
        middleButtonPanel.add((Component)this.addButton);
        middleButtonPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        middleButtonPanel.add((Component)this.addAllButton);
        middleButtonPanel.add(Box.createRigidArea(new Dimension(0, 24)));
        middleButtonPanel.add((Component)this.removeButton);
        middleButtonPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        middleButtonPanel.add((Component)this.removeAllButton);
        middleButtonPanel.add(Box.createVerticalGlue());
        JPanel rightListPanel = new JPanel(new BorderLayout());
        rightListPanel.setOpaque(false);
        centerPanel.add((Component)rightListPanel, "East");
        rightListPanel.add((Component)new JScrollPane(this.mapContactList), "Center");
        this.setAgreementPreferredSize2ListPanel(leftListPanel, rightListPanel);
        this.populateContacts();
        this.makeBottomButtonPanel(mainPanel);
        return mainPanel;
    }

    private void populateContacts() {
        ArrayList<Contact> externalContacts = new ArrayList<Contact>();
        ArrayList<Contact> mapContacts = new ArrayList();
        if (OsgiServices.getEditorManager() != null && OsgiServices.getEditorManager().getCurrentEditorComponent() != null) {
            mapContacts = OsgiServices.getEditorManager().getCurrentEditorComponent().getMapResources();
        }
        this.loadContacts(this.externalListModel, this.mapListModel, externalContacts, mapContacts);
    }

    private ActionListener makeAddAllAction(final FilterListModel externalListModelIn, final DefaultListModel mapListModelIn) {
        ActionListener addAll = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (Object temp : externalListModelIn.getFilterItems()) {
                    externalListModelIn.removeElement(temp);
                    if (mapListModelIn.contains(temp)) continue;
                    mapListModelIn.addElement(temp);
                }
                ContactManagementDialog.this.checkButtonsState();
            }
        };
        return addAll;
    }

    private void checkButtonsState() {
        this.removeAllButton.setEnabled(this.mapListModel.size() > 0);
        this.addAllButton.setEnabled(this.externalListModel.size() > 0);
        this.addButton.setEnabled(this.externalContactList.getSelectedIndex() != -1);
        this.removeButton.setEnabled(this.mapContactList.getSelectedIndex() != -1);
    }

    private ActionListener makeRemoveAllAction(final FilterListModel externalListModelIn, final DefaultListModel mapListModelIn) {
        ActionListener removeAll = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object temp = null;
                Enumeration mapContact = mapListModelIn.elements();
                while (mapContact.hasMoreElements()) {
                    temp = mapContact.nextElement();
                    if (externalListModelIn.contains(temp)) continue;
                    externalListModelIn.addElement((Object)temp);
                }
                mapListModelIn.removeAllElements();
                ContactManagementDialog.this.checkButtonsState();
            }
        };
        return removeAll;
    }

    private ActionListener makeRemoveAction(final FilterListModel externalListModelIn, final DefaultListModel mapListModelIn, final JList mapContactListIn) {
        ActionListener remove = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object selectedMapContact = mapContactListIn.getSelectedValue();
                if (selectedMapContact == null) {
                    return;
                }
                mapListModelIn.removeElement(selectedMapContact);
                if (!externalListModelIn.contains(selectedMapContact)) {
                    externalListModelIn.addElement(selectedMapContact);
                }
                ContactManagementDialog.this.checkButtonsState();
            }
        };
        return remove;
    }

    private ActionListener makeAddAction(final FilterListModel externalListModelIn, final JList externalContactListIn, final DefaultListModel mapListModelIn) {
        ActionListener add = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object selectedExternalContact = externalContactListIn.getSelectedValue();
                if (selectedExternalContact == null) {
                    return;
                }
                externalListModelIn.removeElement(selectedExternalContact);
                if (!mapListModelIn.contains(selectedExternalContact)) {
                    mapListModelIn.addElement(selectedExternalContact);
                }
                ContactManagementDialog.this.checkButtonsState();
            }
        };
        return add;
    }

    private void loadContacts(final FilterListModel externalListModelIn, final DefaultListModel mapListModelIn, final List<Contact> externalContactsIn, final List<Contact> mapContactsIn) {
        SwingWorker<Void, Void> task = new SwingWorker<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doInBackground() {
                ExternalApplicationSynchronizer extAppSync = SynchronizerFactory.getInstance().getExternalApplicationSynchronizer();
                if (extAppSync != null) {
                    try {
                        ContactManagementDialog.this.fillContacts(externalContactsIn, mapContactsIn, extAppSync.getContacts(), extAppSync.getMapDataSynchronizer().getContacts());
                    }
                    catch (ExternalAppException ex) {
                        this.showErrorDialog();
                        LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    catch (Exception ex) {
                        this.showErrorDialog();
                        LOGGER.error((Object)"Something unexpected happened", (Throwable)ex);
                    }
                    finally {
                        extAppSync.disposeConnector();
                    }
                }
                return null;
            }

            protected final void showErrorDialog() {
                JOptionPane.showMessageDialog((Component)((Object)ContactManagementDialog.this), I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.projectmanagementsync.syncerror"), I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.projectmanagementsync.syncerrortitle"), 0);
            }

            protected void done() {
                externalListModelIn.removeAllElements();
                mapListModelIn.removeAllElements();
                for (Contact temp : externalContactsIn) {
                    externalListModelIn.addElement(temp);
                }
                for (Contact temp : mapContactsIn) {
                    mapListModelIn.addElement(temp);
                }
                ContactManagementDialog.this.checkButtonsState();
            }
        };
        externalListModelIn.addElement(I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.projectmanagementsync.contactManagementDialog.loading"));
        task.execute();
    }

    private void setAgreementPreferredSize2ListPanel(JComponent externalContactListIn, JComponent mapContactListIn) {
        externalContactListIn.setMinimumSize(new Dimension(150, 300));
        externalContactListIn.setPreferredSize(new Dimension(150, 300));
        externalContactListIn.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        mapContactListIn.setMinimumSize(new Dimension(150, 300));
        mapContactListIn.setPreferredSize(new Dimension(150, 300));
        mapContactListIn.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    private void setAgreementPreferredSize2Buttons(JButton ... buttons) {
        int maxWidth = 0;
        int maxHeight = 0;
        for (JButton temp : buttons) {
            if (temp.getPreferredSize().height > maxHeight) {
                maxHeight = temp.getPreferredSize().height;
            }
            if (temp.getPreferredSize().width <= maxWidth) continue;
            maxWidth = temp.getPreferredSize().width;
        }
        for (JButton temp : buttons) {
            temp.setMinimumSize(new Dimension(maxWidth, maxHeight));
            temp.setPreferredSize(new Dimension(maxWidth, maxHeight));
            temp.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        }
    }

    private void makeBottomButtonPanel(JPanel mainPanel) {
        this.addConfirmActionListener(I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.common.ok"), new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ExternalApplicationSynchronizer extAppSync = SynchronizerFactory.getInstance().getExternalApplicationSynchronizer();
                if (extAppSync != null) {
                    ArrayList source = new ArrayList();
                    Object[] srcArray = ContactManagementDialog.this.mapListModel.toArray();
                    source.addAll(ContactManagementDialog.this.getGenericTypeList(srcArray, new Contact[srcArray.length]));
                    EditorManager editorManager = OsgiServices.getEditorManager();
                    if (editorManager != null) {
                        IEditorComponent editorComponent = null;
                        try {
                            editorComponent = editorManager.getCurrentEditorComponent();
                        }
                        catch (IllegalStateException ex) {
                            return;
                        }
                        editorComponent.setMapResources(source);
                    }
                }
                ContactManagementDialog.this.dispose();
            }
        });
        this.addDeclineActionListener(I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.common.cancel"), new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ContactManagementDialog.this.dispose();
            }
        });
        ListSelectionListener l = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ContactManagementDialog.this.checkButtonsState();
            }
        };
        this.mapContactList.addListSelectionListener(l);
        this.externalContactList.addListSelectionListener(l);
    }

    private <T> List<T> getGenericTypeList(Object[] src, T[] dest) {
        System.arraycopy(src, 0, dest, 0, src.length);
        List<T> temps = Arrays.asList(dest);
        ArrayList<T> results = new ArrayList<T>(temps.size());
        for (int i = 0; i < temps.size(); ++i) {
            results.add(temps.get(i));
        }
        return results;
    }

    private void fillContacts(List<Contact> externalContacts, List<Contact> mapContacts, List<Contact> src, List<Contact> dest) {
        boolean achieveMaximum = false;
        for (Contact temp : src) {
            if (dest.contains(temp)) {
                mapContacts.add(temp);
                continue;
            }
            if (externalContacts.size() == 100) {
                achieveMaximum = true;
            }
            externalContacts.add(temp);
        }
        if (achieveMaximum) {
            this.showMaxExternalContactsConfirmDialog();
        }
    }

    private void showMaxExternalContactsConfirmDialog() {
        EDTUtilities.runOnEDT((Runnable)new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog((Component)((Object)ContactManagementDialog.this), I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.projectmanagementsync.maxContainsMessageDialog.message", 100), I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.projectmanagementsync.maxContainsMessageDialog.title"), 1);
            }
        });
    }
}

