/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.projectmanagementsync.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterListModel
extends DefaultListModel {
    private static final long serialVersionUID = 1L;
    protected static final int EXTERNAL_CONTACTS_MAXIMUM = 100;
    private final transient List<Object> filterItems = new ArrayList<Object>();
    private transient String filterText = null;

    @Override
    public final Object getElementAt(int index) {
        if (index < this.filterItems.size()) {
            return this.filterItems.get(index);
        }
        return null;
    }

    @Override
    public final int getSize() {
        return this.filterItems.size();
    }

    public final void addElement(Object o) {
        super.addElement(o);
        this.filter(this.filterText);
    }

    @Override
    public final boolean removeElement(Object obj) {
        boolean rv = super.removeElement(obj);
        this.filter(this.filterText);
        return rv;
    }

    @Override
    public final void removeAllElements() {
        super.removeAllElements();
        this.filter(this.filterText);
    }

    public final void filter(String text) {
        this.filterText = text == null ? null : text.trim().toLowerCase();
        this.filterItems.clear();
        Enumeration enu = super.elements();
        Object temp = null;
        while (enu.hasMoreElements()) {
            temp = enu.nextElement();
            if (this.filterItems.size() == 100) break;
            if (this.filterText != null && this.filterText.length() > 0) {
                if (temp == null || temp.toString().toLowerCase().indexOf(this.filterText) == -1) continue;
                this.filterItems.add(temp);
                continue;
            }
            this.filterItems.add(temp);
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public final List<Object> getFilterItems() {
        ArrayList<Object> copied = new ArrayList<Object>(this.filterItems);
        Collections.copy(copied, this.filterItems);
        return copied;
    }
}

