/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.projectmanagementsync.windows;

import com.moyosoft.connector.com.ComponentObjectModelException;
import com.moyosoft.connector.exception.LibraryNotFoundException;
import com.moyosoft.connector.ms.outlook.Outlook;
import com.moyosoft.connector.ms.outlook.appointment.OutlookAppointment;
import com.moyosoft.connector.ms.outlook.contact.OutlookContact;
import com.moyosoft.connector.ms.outlook.folder.FolderType;
import com.moyosoft.connector.ms.outlook.item.ItemType;
import com.moyosoft.connector.ms.outlook.item.ItemsCollection;
import com.moyosoft.connector.ms.outlook.item.ItemsIterator;
import com.moyosoft.connector.ms.outlook.item.OutlookItem;
import com.moyosoft.connector.ms.outlook.properties.UserPropertyType;
import com.moyosoft.connector.ms.outlook.recipient.RecipientsCollection;
import com.moyosoft.connector.ms.outlook.task.OutlookTask;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.entities.Contact;
import com.thinkbuzan.gaia.entities.Milestone;
import com.thinkbuzan.gaia.entities.Resource;
import com.thinkbuzan.gaia.entities.Task;
import com.thinkbuzan.gaia.projectmanagementsync.ExternalAppException;
import com.thinkbuzan.gaia.projectmanagementsync.ExternalApplicationSynchronizer;
import com.thinkbuzan.gaia.projectmanagementsync.MapDataSynchronizer;
import com.thinkbuzan.gaia.projectmanagementsync.impl.DefaultMapDataSynchronizer;
import com.thinkbuzan.gaia.projectmanagementsync.osgi.OsgiServices;
import com.thinkbuzan.gaia.projectmanagementsync.ui.I18nService;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutlookSynchronizer
implements ExternalApplicationSynchronizer {
    private static final Logger LOGGER = Logger.getLogger(OutlookSynchronizer.class);
    private static final String UUID_USER_PROPERTY_KEY = "imm5UUID";
    private static final byte[] LOCK = new byte[0];
    private static transient OutlookSynchronizer instance;
    private transient Outlook outlookConn;
    private transient MapDataSynchronizer mapDataSynchronizer = new DefaultMapDataSynchronizer();

    private OutlookSynchronizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutlookSynchronizer getInstance() {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            if (instance == null) {
                instance = new OutlookSynchronizer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void setMapDataSynchronizer(MapDataSynchronizer mapDataSync) {
        this.mapDataSynchronizer = mapDataSync;
    }

    @Override
    public MapDataSynchronizer getMapDataSynchronizer() {
        return this.mapDataSynchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Outlook getOutlookConnector() throws LibraryNotFoundException {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            if (this.outlookConn == null) {
                this.outlookConn = new Outlook();
                LOGGER.info((Object)("Outlook Version: " + this.outlookConn.getOutlookVersion()));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.outlookConn;
        }
    }

    private ItemsCollection getItemsCollection(FolderType folderType) throws ExternalAppException {
        ItemsCollection outlookItems = null;
        try {
            outlookItems = this.getOutlookConnector().getDefaultFolder(folderType).getItems();
        }
        catch (ComponentObjectModelException ex) {
            throw new ExternalAppException("Could not communicate with outlook", ex);
        }
        catch (LibraryNotFoundException ex) {
            throw new ExternalAppException("Could not find outlook required libs", ex);
        }
        catch (Exception ex) {
            throw new ExternalAppException("Something went wrong while getting info from outlook", ex);
        }
        return outlookItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeConnector() {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            if (this.outlookConn != null) {
                this.outlookConn.dispose();
                this.outlookConn = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Contact> getContacts() throws ExternalAppException {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            ItemsCollection contactItems = this.getItemsCollection(FolderType.CONTACTS);
            if (contactItems != null) {
                ItemsIterator it = contactItems.iterator();
                while (it.hasNext()) {
                    OutlookItem item = it.nextItem();
                    if (!(item instanceof OutlookContact) || !item.getType().isContact()) continue;
                    contacts.add(this.createContact((OutlookContact)item));
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return contacts;
        }
    }

    private Contact createContact(OutlookContact item) {
        return new Contact(item.getFullName(), item.getEmail1Address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean synchronizeMilestone(Milestone source) throws ExternalAppException {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            ItemsCollection calendarItems = this.getItemsCollection(FolderType.CALENDAR);
            if (calendarItems != null) {
                OutlookAppointment syncedMilestone = this.getSynchronisedItem(source.getHidden(), calendarItems, OutlookAppointment.class);
                if (syncedMilestone == null) {
                    OutlookAppointment newOutlookAppointment = (OutlookAppointment)calendarItems.createNew(ItemType.APPOINTMENT);
                    source.setBody(this.getPrependedMilestoneBody(source.getBody()));
                    this.copyAttributes(source, newOutlookAppointment);
                    newOutlookAppointment.save();
                } else {
                    if (source.isChanged()) {
                        this.copyAttributes(source, syncedMilestone);
                        syncedMilestone.save();
                        source.setChanged(false);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return true;
                    }
                    if (this.isOutlookAppointmentChanged(syncedMilestone, source)) {
                        this.copyAttributes(syncedMilestone, source);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return true;
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    private String getPrependedMilestoneBody(String body) {
        return I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.projectmanagementsync.appointment.body.firstLine") + System.getProperty("line.separator") + body;
    }

    private boolean isOutlookAppointmentChanged(OutlookAppointment source, Milestone dest) {
        return !source.getSubject().equals(dest.getSubject()) || !source.getStart().equals(dest.getStartTime());
    }

    private void copyAttributes(OutlookAppointment source, Milestone dest) {
        dest.setSubject(source.getSubject());
        dest.setStartTime(source.getStart());
    }

    private void copyAttributes(Milestone source, OutlookAppointment dest) {
        dest.setSubject(source.getSubject());
        dest.setStart(source.getStartTime());
        dest.setDuration(source.getDuration());
        dest.setBody(source.getBody());
        dest.getUserProperties().add(UUID_USER_PROPERTY_KEY, UserPropertyType.TEXT).setValue(source.getHidden());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean synchronizeTask(Task source) throws ExternalAppException {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            ItemsCollection taskItems = this.getItemsCollection(FolderType.TASKS);
            if (taskItems != null) {
                OutlookTask outlookTask = this.getSynchronisedItem(source.getHidden(), taskItems, OutlookTask.class);
                if (outlookTask == null) {
                    OutlookTask newOutlookTask = this.createNewOutlookTask(source, taskItems);
                    this.assignAndSend(source, newOutlookTask, null);
                } else {
                    if (source.isChanged()) {
                        OutlookTask newOutlookTask = this.createNewOutlookTask(source, taskItems);
                        if (newOutlookTask.getRecipients().getCount() > 0) {
                            this.assignAndSend(source, newOutlookTask, null);
                        }
                        taskItems.deleteItem(outlookTask.getItemId());
                        source.setChanged(false);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return true;
                    }
                    if (this.isOutlookTaskChanged(outlookTask, source)) {
                        this.copyAttributes(outlookTask, source);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return true;
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    private <T extends OutlookItem> T getSynchronisedItem(String uuid, ItemsCollection itemsCollection, Class<T> clazz) {
        String criteria = "@SQL=\"http://schemas.microsoft.com/mapi/string/{00020329-0000-0000-C000-000000000046}/imm5UUID/0000001f\" = '" + uuid + "'";
        ItemsIterator it = itemsCollection.findItems(criteria);
        if (it != null) {
            while (it.hasNext()) {
                OutlookItem item = it.nextItem();
                if (!clazz.isInstance(item)) continue;
                return (T)((OutlookItem)clazz.cast(item));
            }
        }
        LOGGER.debug((Object)("No outlook item found for UUID " + uuid));
        return null;
    }

    private OutlookTask createNewOutlookTask(Task source, ItemsCollection taskItems) {
        OutlookTask newOutlookTask = (OutlookTask)taskItems.createNew(ItemType.TASK);
        this.copyAttributes(source, newOutlookTask);
        newOutlookTask.save();
        return newOutlookTask;
    }

    private void assignAndSend(Task source, OutlookTask newOutlookTask, String oldRecipientName) {
        if (source.getTo() != null && source.getTo().length() > 0 && !source.getTo().equals(oldRecipientName)) {
            newOutlookTask.assign();
            newOutlookTask.send();
        }
    }

    private boolean isOutlookTaskChanged(OutlookTask source, Task dest) {
        return !source.getStartDate().equals(dest.getStartDate()) || !source.getDueDate().equals(dest.getDueDate()) || source.getPercentComplete() != (int)dest.getCompletion();
    }

    private void copyAttributes(OutlookTask source, Task dest) {
        dest.setStartDate(source.getStartDate());
        dest.setDueDate(source.getDueDate());
        dest.setCompletion((double)source.getPercentComplete());
        dest.setChanged(false);
    }

    private void copyAttributes(Task source, OutlookTask dest) {
        dest.setStartDate(source.getStartDate());
        dest.setDueDate(source.getDueDate());
        dest.setSubject(source.getBody());
        dest.setBody(this.getPrependedTaskBody(source.getBody()));
        dest.setPercentComplete((int)source.getCompletion());
        RecipientsCollection recipient = dest.getRecipients();
        List<Contact> contacts = this.getMapResources();
        if (!contacts.isEmpty()) {
            for (Resource tempResource : source.getResources()) {
                String resourceEmailAddress;
                if (tempResource.getResourceName() == null || (resourceEmailAddress = this.getResourceEmailAddress(tempResource.getResourceName(), contacts)) == null) continue;
                recipient.createNew(resourceEmailAddress);
                source.setTo(resourceEmailAddress);
            }
        }
        dest.getUserProperties().add(UUID_USER_PROPERTY_KEY, UserPropertyType.TEXT).setValue(source.getHidden());
    }

    private String getResourceEmailAddress(String resourceName, List<Contact> contactList) {
        for (Contact tempContact : contactList) {
            if (!tempContact.getUserName().equals(resourceName) || "".equals(tempContact.getEmailAddress())) continue;
            return tempContact.getEmailAddress();
        }
        return null;
    }

    private List<Contact> getMapResources() {
        EditorManager editorManager = OsgiServices.getEditorManager();
        if (editorManager != null) {
            IEditorComponent editorComponent = null;
            try {
                editorComponent = editorManager.getCurrentEditorComponent();
            }
            catch (IllegalStateException ex) {
                return new ArrayList<Contact>();
            }
            if (editorComponent != null) {
                return editorComponent.getMapResources();
            }
        }
        return new ArrayList<Contact>();
    }

    private String getPrependedTaskBody(String body) {
        return I18nService.getInstance().getLocalizedText("com.thinkbuzan.i18n.projectmanagementsync.task.body.firstLine") + System.getProperty("line.separator") + body;
    }
}

