/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.projectmgmt.impl;

import com.jidesoft.utils.SystemInfo;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.util.PropertyUtilities;
import com.mxgraph.mindmap.util.mmUtils;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.entities.Task;
import com.thinkbuzan.gaia.entities.TaskStatus;
import com.thinkbuzan.gaia.entities.TimelineInfo;
import com.thinkbuzan.gaia.export.BasicExportPanel;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.FileType;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.IExporterListener;
import com.thinkbuzan.gaia.export.IFileType;
import com.thinkbuzan.gaia.export.projectmgmt.license.IBundleLicenser;
import com.thinkbuzan.gaia.export.projectmgmt.resource.ImageResourceManager;
import com.thinkbuzan.gaia.export.unlicensed.TrialExporterPanel;
import com.thinkbuzan.gaia.export.unlicensed.UnlicensedExporterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpx.MPXWriter;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.utility.DateUtility;
import org.apache.log4j.Logger;

public final class ProjectMgmtExporter
implements IExporter {
    private static final Logger LOGGER = Logger.getLogger(ProjectMgmtExporter.class);
    private static final String ICON_NAME = "mpx.png";
    private static final String MPX = "mpx";
    private static final String MPDI = "xml";
    private static final String[] MSPDI_FILE_EXT = new String[]{"xml"};
    private static final String[] MPX_FILE_EXT = new String[]{"mpx"};
    protected static final String MPX_DESC = "MS Project Exchange File (*.mpx)";
    protected static final String MSPDI_DESC = "MS Project XML File (*.xml)";
    private final transient Map<String, List<String>> descExtMap = new HashMap<String, List<String>>();
    private final transient IFileType fileType;
    private static final float COMPLETE = 100.0f;
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int MINUTES_IN_HOUR = 60;
    private static final int HOURS_IN_DAY = 24;
    private final transient I18n i18n;
    private final transient IBundleLicenser licenser;
    private transient JComboBox<String> combo;
    private transient JRadioButton timeMap;
    private transient JRadioButton project;

    public ProjectMgmtExporter(I18n i18nIn, IBundleLicenser licenserIn) {
        this.i18n = i18nIn;
        this.licenser = licenserIn;
        this.descExtMap.put(MSPDI_DESC, Arrays.asList(MSPDI_FILE_EXT));
        this.descExtMap.put(MPX_DESC, Arrays.asList(MPX_FILE_EXT));
        this.fileType = new FileType(Arrays.asList(MSPDI_DESC, MPX_DESC), this.descExtMap);
    }

    public JComponent getComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)this.lazyGetOptions(), "North");
        switch (this.getLicenseState()) {
            case full: {
                panel.add((Component)new BasicExportPanel(this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.exportProjectManagement"), true), "Center");
                break;
            }
            case trial: {
                panel.add((Component)TrialExporterPanel.getInstance((I18n)this.i18n), "Center");
                break;
            }
            default: {
                panel.add((Component)UnlicensedExporterPanel.getInstance((I18n)this.i18n), "Center");
            }
        }
        return panel;
    }

    public Icon getIcon() {
        return ImageResourceManager.getImageIcon(ICON_NAME);
    }

    public String getId() {
        return "com.thinkbuzan.gaia.export.ProjectMgmtExporter";
    }

    public String getName() {
        return this.i18n.getLocalizedText("com.thinkbuzan.i18n.projectexport.text.name");
    }

    public IFileType getOutputFileType() {
        if (SystemInfo.isAnyMac()) {
            return new FileType(Arrays.asList((String)this.combo.getSelectedItem()), this.descExtMap);
        }
        return this.fileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JPanel lazyGetOptions() {
        ProjectMgmtExporter projectMgmtExporter = this;
        synchronized (projectMgmtExporter) {
            JPanel container = new JPanel(new BorderLayout());
            container.setOpaque(false);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.setOpaque(false);
            if (SystemInfo.isAnyMac()) {
                JPanel labelWrap = new JPanel(new BorderLayout());
                labelWrap.setOpaque(false);
                labelWrap.add((Component)new JLabel(this.i18n.getLocalizedText("com.thinkbuzan.i18n.exportManager.commons.exportto")), "West");
                panel.add(labelWrap);
                panel.add(Box.createVerticalStrut(5));
                this.combo = new JComboBox();
                this.combo.setOpaque(false);
                for (String key : this.descExtMap.keySet()) {
                    this.combo.addItem(key);
                }
                JPanel comboWrap = new JPanel(new BorderLayout());
                comboWrap.setOpaque(false);
                comboWrap.add(this.combo, "West");
                panel.add(comboWrap);
                panel.add(Box.createVerticalStrut(15));
            }
            JPanel infoWrap = new JPanel(new BorderLayout());
            infoWrap.setOpaque(false);
            infoWrap.add((Component)new JLabel(this.i18n.getLocalizedText("com.thinkbuzan.i18n.taskinfopanel.general.taskinfolabel")), "West");
            panel.add(infoWrap);
            this.timeMap = new JRadioButton(this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.timeline"));
            this.timeMap.setOpaque(false);
            JPanel timeWrap = new JPanel(new BorderLayout());
            timeWrap.setOpaque(false);
            timeWrap.add((Component)this.timeMap, "West");
            this.project = new JRadioButton(this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.project"));
            this.project.setOpaque(false);
            JPanel projectWrap = new JPanel(new BorderLayout());
            projectWrap.setOpaque(false);
            projectWrap.add((Component)this.project, "West");
            ButtonGroup group = new ButtonGroup();
            group.add(this.timeMap);
            group.add(this.project);
            this.timeMap.setSelected(true);
            panel.add(timeWrap);
            panel.add(projectWrap);
            panel.add(Box.createVerticalStrut(50));
            panel.add(Box.createVerticalGlue());
            container.add((Component)panel, "Center");
            return container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(IEditorComponent editorComponent, File file, IExporterListener exporterListener) {
        try {
            ProjectFile project = this.createProjectFile();
            List centralIdeas = editorComponent.getFloatingIdeas();
            mmUtils.sortByOrder((List)centralIdeas);
            Date projectStartDate = this.buildProject(editorComponent, exporterListener, project, centralIdeas);
            ProjectHeader header = project.getProjectHeader();
            header.setStartDate(projectStartDate);
            Object writer = MPX.equalsIgnoreCase(this.getFileType(file)) ? new MPXWriter() : new MSPDIWriter();
            writer.write(project, file);
        }
        catch (Exception ex) {
            exporterListener.exportErrorOccurred(ex.getMessage());
            LOGGER.warn((Object)"Problem exporting to project", (Throwable)ex);
        }
        finally {
            exporterListener.exportProgress(100.0f);
        }
    }

    private Date buildProject(IEditorComponent editorComponent, IExporterListener exporterListener, ProjectFile project, List<mmFloatingIdeaCell> centralIdeas) {
        Date projectStartDate = new Date();
        if (this.timeMap.isSelected()) {
            for (mmFloatingIdeaCell centralIdea : centralIdeas) {
                TimelineInfo task = this.getTimelineInfoByBranch((mmICell)centralIdea);
                if (task == null || !task.isIncludeInTimeline()) continue;
                net.sf.mpxj.Task projectTask = project.addTask();
                projectTask.setName(PropertyUtilities.getText((mmICell)centralIdea));
                projectTask.setMilestone(task.isMilestone());
                projectTask.setStart(task.getStart());
                projectTask.setActualStart(task.getStart());
                projectTask.setFinish(task.getEnd());
                Date start = task.getStart();
                Date end = task.getEnd();
                projectTask.setDuration(Duration.getInstance((double)this.calculateDuration(start, end), (TimeUnit)TimeUnit.DAYS));
                if (TaskStatus.COMPLETED == task.getStatus()) {
                    projectTask.setPercentageComplete((Number)100);
                }
                projectTask.setTaskMode(TaskMode.MANUALLY_SCHEDULED);
                projectTask.setCalendar(project.getCalendarByName("7DayWorkWeek"));
                if (task.getStart().before(projectStartDate)) {
                    projectStartDate = task.getStart();
                }
                exporterListener.exportProgress(1.0f);
                this.getTaskEntries(editorComponent, (mmIStructureCell)centralIdea, projectTask, true, start);
            }
        } else {
            for (mmFloatingIdeaCell centralIdea : centralIdeas) {
                Task task = this.getEntityInfoByBranch((mmICell)centralIdea);
                if (task == null || !task.isEnabledForProjectManager()) continue;
                net.sf.mpxj.Task projectTask = project.addTask();
                projectTask.setName(PropertyUtilities.getText((mmICell)centralIdea));
                projectTask.setMilestone(task.isMilestone());
                projectTask.setStart(task.getStartDate());
                projectTask.setActualStart(task.getStartDate());
                projectTask.setDuration(Duration.getInstance((double)task.calculateDuration(), (TimeUnit)TimeUnit.DAYS));
                projectTask.setPercentageComplete((Number)task.getCompletion());
                projectTask.setTaskMode(TaskMode.MANUALLY_SCHEDULED);
                projectTask.setCalendar(project.getCalendarByName("7DayWorkWeek"));
                if (task.getStartDate().before(projectStartDate)) {
                    projectStartDate = task.getStartDate();
                }
                exporterListener.exportProgress(1.0f);
                this.getTaskEntries(editorComponent, (mmIStructureCell)centralIdea, projectTask, false, task.getStartDate());
            }
        }
        return projectStartDate;
    }

    public void export(IEditorComponent editorComponent, File outputFile, IExporterListener exporterListener, Object ... objects) {
        this.export(editorComponent, outputFile, exporterListener);
    }

    private ProjectFile createProjectFile() {
        ProjectFile project = new ProjectFile();
        project.setAutoTaskID(true);
        project.setAutoTaskUniqueID(true);
        project.setAutoResourceID(true);
        project.setAutoResourceUniqueID(true);
        project.setAutoOutlineLevel(true);
        project.setAutoOutlineNumber(true);
        project.setAutoWBS(true);
        ProjectCalendar pc = project.addDefaultBaseCalendar();
        pc.setName("7DayWorkWeek");
        pc.setWorkingDay(Day.SUNDAY, true);
        pc.setWorkingDay(Day.MONDAY, true);
        pc.setWorkingDay(Day.TUESDAY, true);
        pc.setWorkingDay(Day.WEDNESDAY, true);
        pc.setWorkingDay(Day.THURSDAY, true);
        pc.setWorkingDay(Day.FRIDAY, true);
        pc.setWorkingDay(Day.SATURDAY, true);
        Date defaultStart1 = DateUtility.getTime((int)8, (int)0);
        Date defaultStart2 = DateUtility.getTime((int)13, (int)0);
        Date defaultEnd1 = DateUtility.getTime((int)12, (int)0);
        Date defaultEnd2 = DateUtility.getTime((int)17, (int)0);
        ProjectCalendarHours h1 = pc.addCalendarHours(Day.SUNDAY);
        h1.addRange(new DateRange(defaultStart1, defaultEnd1));
        h1.addRange(new DateRange(defaultStart2, defaultEnd2));
        ProjectCalendarHours h2 = pc.addCalendarHours(Day.MONDAY);
        h2.addRange(new DateRange(defaultStart1, defaultEnd1));
        h2.addRange(new DateRange(defaultStart2, defaultEnd2));
        ProjectCalendarHours h3 = pc.addCalendarHours(Day.TUESDAY);
        h3.addRange(new DateRange(defaultStart1, defaultEnd1));
        h3.addRange(new DateRange(defaultStart2, defaultEnd2));
        ProjectCalendarHours h4 = pc.addCalendarHours(Day.WEDNESDAY);
        h4.addRange(new DateRange(defaultStart1, defaultEnd1));
        h4.addRange(new DateRange(defaultStart2, defaultEnd2));
        ProjectCalendarHours h5 = pc.addCalendarHours(Day.THURSDAY);
        h5.addRange(new DateRange(defaultStart1, defaultEnd1));
        h5.addRange(new DateRange(defaultStart2, defaultEnd2));
        ProjectCalendarHours h6 = pc.addCalendarHours(Day.FRIDAY);
        h6.addRange(new DateRange(defaultStart1, defaultEnd1));
        h6.addRange(new DateRange(defaultStart2, defaultEnd2));
        ProjectCalendarHours h7 = pc.addCalendarHours(Day.SATURDAY);
        h7.addRange(new DateRange(defaultStart1, defaultEnd1));
        h7.addRange(new DateRange(defaultStart2, defaultEnd2));
        ProjectHeader ph = project.getProjectHeader();
        ph.setCalendarName(pc.getName());
        ph.setProjectExternallyEdited(true);
        return project;
    }

    private void getTaskEntries(IEditorComponent editorComponent, mmIStructureCell cell, net.sf.mpxj.Task parentTask, boolean isTimeline, Date parentStart) {
        if (editorComponent == null) {
            throw new IllegalArgumentException("The editor component must not be null value");
        }
        if (cell == null) {
            throw new IllegalArgumentException("The branch cell must not be null value");
        }
        List children = cell.getChildStructures();
        mmUtils.sortByOrder((List)children);
        for (mmIStructureCell child : children) {
            net.sf.mpxj.Task subTask;
            TimelineInfo taskEntity;
            if (isTimeline) {
                taskEntity = this.getTimelineInfoByBranch((mmICell)child);
                if (taskEntity == null || !taskEntity.isIncludeInTimeline()) continue;
                subTask = parentTask.addTask();
                subTask.setName(PropertyUtilities.getText((mmICell)child));
                subTask.setMilestone(taskEntity.isMilestone());
                subTask.setStart(taskEntity.getStart());
                subTask.setActualStart(taskEntity.getStart());
                if (taskEntity.getCompletion() == null) {
                    subTask.setPercentageComplete((Number)0);
                } else {
                    subTask.setPercentageComplete((Number)taskEntity.getCompletion());
                }
                Date end = taskEntity.getEnd();
                Date start = taskEntity.getStart() == null ? parentStart : taskEntity.getStart();
                if (end != null) {
                    subTask.setDuration(Duration.getInstance((double)this.calculateDuration(start, end), (TimeUnit)TimeUnit.DAYS));
                    subTask.setFinish(end);
                } else {
                    subTask.setDuration(Duration.getInstance((int)1, (TimeUnit)TimeUnit.DAYS));
                    subTask.setFinish(start);
                }
                if (TaskStatus.COMPLETED == taskEntity.getStatus()) {
                    subTask.setPercentageComplete((Number)100);
                }
                subTask.setTaskMode(TaskMode.MANUALLY_SCHEDULED);
                subTask.setCalendar(parentTask.getCalendar());
                this.getTaskEntries(editorComponent, child, subTask, isTimeline, start);
                continue;
            }
            taskEntity = this.getEntityInfoByBranch((mmICell)child);
            if (taskEntity == null || !taskEntity.isEnabledForProjectManager()) continue;
            subTask = parentTask.addTask();
            subTask.setName(PropertyUtilities.getText((mmICell)child));
            subTask.setMilestone(taskEntity.isMilestone());
            subTask.setStart(taskEntity.getStartDate());
            subTask.setActualStart(taskEntity.getStartDate());
            subTask.setDuration(Duration.getInstance((double)taskEntity.calculateDuration(), (TimeUnit)TimeUnit.DAYS));
            subTask.setPercentageComplete((Number)taskEntity.getCompletion());
            subTask.setTaskMode(TaskMode.MANUALLY_SCHEDULED);
            subTask.setCalendar(parentTask.getCalendar());
            this.getTaskEntries(editorComponent, child, subTask, isTimeline, taskEntity.getStartDate());
        }
    }

    private Task getEntityInfoByBranch(mmICell cell) {
        return (Task)PropertyUtilities.getProperty((mmICell)cell, (String)"com.thinkbuzan.gaia.cell.task", Task.class);
    }

    private TimelineInfo getTimelineInfoByBranch(mmICell cell) {
        return (TimelineInfo)PropertyUtilities.getProperty((mmICell)cell, (String)"TimelineInfo", TimelineInfo.class);
    }

    public Category.CategoryId getCategoryId() {
        return Category.CategoryId.PROJECT;
    }

    public IExporter.LicenseState getLicenseState() {
        return this.licenser.getProjectExporterState();
    }

    private String getFileType(File outputFile) {
        String fileName = outputFile.getName();
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        if (this.isValidExtension(MSPDI_FILE_EXT, extension) || this.isValidExtension(MPX_FILE_EXT, extension)) {
            return extension;
        }
        return null;
    }

    private boolean isValidExtension(String[] validExt, String extension) {
        for (String ext : validExt) {
            if (!extension.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }

    private double calculateDuration(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        Calendar dueCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        dueCalendar.setTime(end);
        long startMillis = startCalendar.getTimeInMillis();
        long dueMillis = dueCalendar.getTimeInMillis();
        long millisecondsDifference = dueMillis - startMillis;
        double daysDifference = millisecondsDifference;
        daysDifference /= 1000.0;
        daysDifference /= 60.0;
        daysDifference /= 60.0;
        return daysDifference /= 24.0;
    }
}

