/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.projectmgmt.osgi;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.action.IAction;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.export.ExportGUIManager;
import com.thinkbuzan.gaia.export.ExportManager;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.projectmgmt.actions.ExportProjectManagementAction;
import com.thinkbuzan.gaia.export.projectmgmt.impl.ProjectMgmtExporter;
import com.thinkbuzan.gaia.export.projectmgmt.license.BundleLicenser;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class OSGIManager
implements BundleActivator {
    private static final String EXPORT_PROJECT_ACTION_ID = "com.thinkbuzan.gaia.actions.ExportProjectManagementAction";
    private static final String UNLICENSED_ACTION_ID = "com.thinkbuzan.gaia.actions.CreateUnlicensedActionAction";

    public void start(BundleContext context) {
        OSGiService actionManager = new OSGiService(context, ActionManager.class);
        BundleLicenser licenser = new BundleLicenser(context);
        I18n i18n = (I18n)new OSGiService(context, I18n.class).get();
        i18n.register((ITextBundle)new TextBundle());
        ProjectMgmtExporter exporter = new ProjectMgmtExporter(i18n, licenser);
        OSGiService exportManagerService = new OSGiService(context, ExportManager.class);
        ((ExportManager)exportManagerService.get()).register((IExporter)exporter);
        exportManagerService.close();
        OSGiService exportGUIManager = new OSGiService(context, ExportGUIManager.class);
        if (IExporter.LicenseState.full.equals((Object)licenser.getProjectExporterState())) {
            ((ActionManager)actionManager.get()).addAction((IAction)new ExportProjectManagementAction((ExportGUIManager)exportGUIManager.get(), exporter.getId()));
        } else {
            this.addUnlicensedActions((ActionManager)actionManager.get());
        }
    }

    private void addUnlicensedActions(ActionManager actionManagerIn) {
        actionManagerIn.runAction(UNLICENSED_ACTION_ID, new Object[]{EXPORT_PROJECT_ACTION_ID});
    }

    public void stop(BundleContext context) {
    }

    public static final class TextBundle
    implements ITextBundle {
        private static final transient String PROPERTIES_BASE_NAME = "i18nproperties/ProjectMgmtExportMessages";

        public ClassLoader getClassLoader() {
            return this.getClass().getClassLoader();
        }

        public String getPropertyFileBaseName() {
            return PROPERTIES_BASE_NAME;
        }
    }
}

