/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.presentation;

import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.export.BranchOrderingOptionPanel;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.ExporterUIConstants;
import com.thinkbuzan.gaia.export.presentation.AbstractPresentationExporter;
import com.thinkbuzan.gaia.export.presentation.template.resources.PresentationExporterResourcesManager;
import com.thinkbuzan.gaia.export.unlicensed.TrialExporterPanel;
import com.thinkbuzan.gaia.export.unlicensed.UnlicensedExporterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractInteractivePresentationExporter
extends AbstractPresentationExporter {
    private final transient I18n i18n;
    private transient JPanel licensedPanel;
    private static final int IMAGE_WIDTH = 244;
    private static final int IMAGE_HEIGHT = 175;

    public AbstractInteractivePresentationExporter(I18n i18nIn) {
        super(i18nIn);
        this.i18n = i18nIn;
    }

    public JComponent getOptionsComponent() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        return panel;
    }

    public JComponent getTemplateComponent() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        return panel;
    }

    public JComponent getComponent() {
        switch (this.getLicenseState()) {
            case full: {
                return this.getLicensedPanel();
            }
            case trial: {
                return TrialExporterPanel.getInstance((I18n)this.i18n);
            }
        }
        return UnlicensedExporterPanel.getInstance((I18n)this.i18n);
    }

    public Category.CategoryId getCategoryId() {
        return Category.CategoryId.INTERACTIVE_PRESENTATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JPanel getLicensedPanel() {
        AbstractInteractivePresentationExporter abstractInteractivePresentationExporter = this;
        synchronized (abstractInteractivePresentationExporter) {
            if (this.licensedPanel == null) {
                this.licensedPanel = new JPanel(new BorderLayout());
                this.licensedPanel.setOpaque(false);
                JLabel title = ExporterUIConstants.createMessageLabel((String)this.i18n.getLocalizedText("com.thinkbuzan.i18n.common.export.presentation.singleslide.description"));
                JLabel image = new JLabel(new ImageIcon(PresentationExporterResourcesManager.getImage("presentation_interactive.png").getScaledInstance(244, 175, 4)));
                JPanel content = new JPanel(new BorderLayout(0, 10));
                content.setOpaque(false);
                content.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
                content.add((Component)title, "North");
                content.add((Component)image, "West");
                JPanel wrapper = new JPanel(new BorderLayout(0, 10));
                wrapper.setOpaque(false);
                wrapper.add((Component)content, "North");
                wrapper.add((Component)new BranchOrderingOptionPanel(), "Center");
                this.licensedPanel.add((Component)wrapper, "West");
            }
            return this.licensedPanel;
        }
    }
}

