/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.presentation;

import com.jidesoft.utils.SystemInfo;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.util.mmUtils;
import com.mxgraph.model.mxICell;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.export.AbstractTemplateExporter;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.ExporterUIConstants;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.IExporterListener;
import com.thinkbuzan.gaia.export.presentation.i18n.PresentationExporterI18N;
import com.thinkbuzan.gaia.export.presentation.options.IPresentationOptions;
import com.thinkbuzan.gaia.export.presentation.options.PresentationOptionsComponent;
import com.thinkbuzan.gaia.export.presentation.template.AbstractPresentationTemplateComponent;
import com.thinkbuzan.gaia.export.presentation.template.IPresentationTemplate;
import com.thinkbuzan.gaia.export.presentation.template.PointsTransition;
import com.thinkbuzan.gaia.export.presentation.template.SlidesTransition;
import com.thinkbuzan.gaia.export.presentation.template.impl.MacPresentationTemplateComponent;
import com.thinkbuzan.gaia.export.presentation.template.impl.PresentationTemplatesLoader;
import com.thinkbuzan.gaia.export.presentation.template.impl.WindowsPresentationTemplateComponent;
import com.thinkbuzan.gaia.export.presentation.util.ProcessProgressor;
import com.thinkbuzan.gaia.export.template.ButtonType;
import com.thinkbuzan.gaia.export.template.ITemplate;
import com.thinkbuzan.gaia.export.template.ITemplateComponentListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPresentationExporter
extends AbstractTemplateExporter {
    private transient List<ITemplate> templates;
    private transient PresentationOptionsComponent optionsComponent;
    private transient AbstractPresentationTemplateComponent templateComponent;
    private final transient ITemplateComponentListener tempCompListener = new PresentationTemplateComponentListener();
    private transient File outputFile;
    private transient IExporterListener exporterListener;
    private transient ProcessProgressor progressor;
    private transient IEditorComponent editorComponent;
    private static final transient String AUTHOR = "iMindMap";

    public AbstractPresentationExporter(I18n i18n) {
        super(i18n);
    }

    public JComponent getComponent() {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setOpaque(false);
        wrapper.add((Component)super.getComponent(), "Center");
        if (IExporter.LicenseState.full.equals((Object)this.getLicenseState())) {
            JPanel titlePanel = new JPanel(new FlowLayout(0, 0, 0));
            titlePanel.setOpaque(false);
            titlePanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
            titlePanel.add((Component)ExporterUIConstants.createMessageLabel((String)PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.export.presentation.bulletslides.description")), "North");
            wrapper.add((Component)titlePanel, "North");
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ITemplate> lazyGetTemplates() {
        if (this.templates == null) {
            AbstractPresentationExporter abstractPresentationExporter = this;
            synchronized (abstractPresentationExporter) {
                if (this.templates == null) {
                    this.templates = this.getSortedTemplatesList();
                }
            }
        }
        return this.templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PresentationOptionsComponent lazyGetOptionsComponent() {
        if (this.optionsComponent == null) {
            AbstractPresentationExporter abstractPresentationExporter = this;
            synchronized (abstractPresentationExporter) {
                if (this.optionsComponent == null) {
                    this.optionsComponent = new PresentationOptionsComponent();
                }
            }
        }
        return this.optionsComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractPresentationTemplateComponent lazyGetTemplatesComponent() {
        if (this.templateComponent == null) {
            AbstractPresentationExporter abstractPresentationExporter = this;
            synchronized (abstractPresentationExporter) {
                if (this.templateComponent == null) {
                    if (SystemInfo.isWindows() || SystemInfo.isLinux()) {
                        this.templateComponent = new WindowsPresentationTemplateComponent();
                    } else if (SystemInfo.isMacOSX()) {
                        this.templateComponent = new MacPresentationTemplateComponent();
                    } else {
                        throw new IllegalStateException(String.format("Unexpected Operating System: %s", SystemInfo.getOS()));
                    }
                }
            }
        }
        return this.templateComponent;
    }

    private List<ITemplate> getSortedTemplatesList() {
        PresentationTemplatesLoader templatesLoader = new PresentationTemplatesLoader();
        List<ITemplate> templateList = templatesLoader.getTemplates();
        ITemplate[] temps = new ITemplate[templateList.size()];
        Arrays.sort(templateList.toArray(temps), new Comparator<ITemplate>(){

            @Override
            public int compare(ITemplate first, ITemplate second) {
                return first.getName().compareTo(second.getName());
            }
        });
        return Arrays.asList(temps);
    }

    public final String getAuthor() {
        return AUTHOR;
    }

    public final ITemplateComponentListener getTemplateComponentListener() {
        return this.tempCompListener;
    }

    public JComponent getOptionsComponent() {
        return this.lazyGetOptionsComponent();
    }

    public JComponent getTemplateComponent() {
        return this.lazyGetTemplatesComponent();
    }

    public final List<ITemplate> getTemplates() {
        return this.lazyGetTemplates();
    }

    public Category.CategoryId getCategoryId() {
        return Category.CategoryId.PRESENTATION;
    }

    public final IPresentationTemplate getChosenTemplate() {
        return this.lazyGetTemplatesComponent().getTemplate();
    }

    public final IPresentationOptions getPresentationOptions() {
        return this.lazyGetOptionsComponent();
    }

    protected IEditorComponent getEditorComponent() {
        return this.editorComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void export(IEditorComponent editorComponentIn, File outputFileIn, IExporterListener expListenerIn) {
        this.validateExport(editorComponentIn, outputFileIn, expListenerIn);
        this.exporterListener = expListenerIn;
        this.editorComponent = editorComponentIn;
        this.outputFile = outputFileIn;
        try {
            this.progressor = new ProcessProgressor(this.getEditorComponent(), this.exporterListener);
            this.progressor.startProcess();
            this.beginDocument();
            this.progressor.beforeProcessing();
            List floatingIdeas = this.getEditorComponent().getFloatingIdeas();
            mmUtils.sortByOrder((List)floatingIdeas);
            for (mmFloatingIdeaCell idea : floatingIdeas) {
                this.beginIdea(idea);
                this.writeBranches(this.getEditorComponent().getBranches((mxICell)idea));
                this.endIdea(idea);
            }
            this.progressor.afterProcessing();
            this.endDocument();
            this.progressor.endProcess();
        }
        catch (Exception e) {
            this.exporterListener.exportErrorOccurred(e.getMessage());
        }
        finally {
            this.editorComponent = null;
            this.exporterListener = null;
        }
    }

    public final void export(IEditorComponent editorCompIn, File outputFileIn, IExporterListener expListenerIn, Object ... objects) {
        String templateName = "";
        boolean exportNotes = false;
        boolean exportImages = false;
        boolean includeQuestions = false;
        if (objects.length > 0 && objects[0] instanceof String) {
            templateName = (String)objects[0];
        }
        if (objects.length > 1 && objects[1] instanceof Boolean) {
            exportNotes = (Boolean)objects[1];
        }
        if (objects.length > 2 && objects[2] instanceof Boolean) {
            exportImages = (Boolean)objects[2];
        }
        if (objects.length > 3 && objects[3] instanceof Boolean) {
            includeQuestions = (Boolean)objects[3];
        }
        this.setTemplate(templateName);
        if (objects.length > 4 && objects[4] instanceof String[]) {
            this.setCustomTemplateOptions((String[])objects[4]);
        }
        if (this.getOptionsComponent() instanceof PresentationOptionsComponent) {
            PresentationOptionsComponent exportComponent = (PresentationOptionsComponent)this.getOptionsComponent();
            exportComponent.setInsertNotes(exportNotes);
            exportComponent.setInsertImages(exportImages);
            exportComponent.setInsertAnyQuestions(includeQuestions);
        }
        this.export(editorCompIn, outputFileIn, expListenerIn);
    }

    private void setCustomTemplateOptions(String[] optionsIn) {
        if (optionsIn.length > 0 && optionsIn[0] != null) {
            this.lazyGetTemplatesComponent().setHeadingsFont(Font.decode(optionsIn[0]));
        }
        if (optionsIn.length > 1 && optionsIn[1] != null) {
            this.lazyGetTemplatesComponent().setPointsFont(Font.decode(optionsIn[1]));
        }
        if (optionsIn.length > 2 && optionsIn[2] != null) {
            boolean titleIntro = false;
            if (optionsIn[2].equalsIgnoreCase("true")) {
                titleIntro = true;
            }
            this.lazyGetTemplatesComponent().setIntroductionTitleSelected(titleIntro);
        }
        if (optionsIn.length > 3 && optionsIn[3] != null) {
            boolean mindMapImageIntro = false;
            if (optionsIn[3].equalsIgnoreCase("true")) {
                mindMapImageIntro = true;
            }
            this.lazyGetTemplatesComponent().setIntroductionImageSelected(mindMapImageIntro);
        }
        if (optionsIn.length > 4 && optionsIn[4] != null) {
            boolean mainBranchesIntro = false;
            if (optionsIn[4].equalsIgnoreCase("true")) {
                mainBranchesIntro = true;
            }
            this.lazyGetTemplatesComponent().setIntroductionMainBranchesSelected(mainBranchesIntro);
        }
        if (optionsIn.length > 5 && optionsIn[5] != null) {
            boolean mainBranchesConclusion = false;
            if (optionsIn[5].equalsIgnoreCase("true")) {
                mainBranchesConclusion = true;
            }
            this.lazyGetTemplatesComponent().setConclusionsMainBranchesSelected(mainBranchesConclusion);
        }
        if (optionsIn.length > 6 && optionsIn[6] != null) {
            boolean mindMapImageConclusion = false;
            if (optionsIn[6].equalsIgnoreCase("true")) {
                mindMapImageConclusion = true;
            }
            this.lazyGetTemplatesComponent().setConclusionsImageSelected(mindMapImageConclusion);
        }
        if (optionsIn.length > 7 && optionsIn[7] != null) {
            boolean titleConclusion = false;
            if (optionsIn[7].equalsIgnoreCase("true")) {
                titleConclusion = true;
            }
            this.lazyGetTemplatesComponent().setConclusionsTitleSelected(titleConclusion);
        }
        if (optionsIn.length > 8 && optionsIn[8] != null) {
            String slidesTransition = optionsIn[8];
            if ("FADE".equals(slidesTransition)) {
                this.lazyGetTemplatesComponent().setSlidesTransition(SlidesTransition.FADE);
            } else if ("WIPE".equals(slidesTransition)) {
                this.lazyGetTemplatesComponent().setSlidesTransition(SlidesTransition.WIPE);
            } else if ("COVER".equals(slidesTransition)) {
                this.lazyGetTemplatesComponent().setSlidesTransition(SlidesTransition.COVER);
            } else if ("UNCOVER".equals(slidesTransition)) {
                this.lazyGetTemplatesComponent().setSlidesTransition(SlidesTransition.UNCOVER);
            } else if ("PUSH".equals(slidesTransition)) {
                this.lazyGetTemplatesComponent().setSlidesTransition(SlidesTransition.PUSH);
            }
        }
        if (optionsIn.length > 9 && optionsIn[9] != null) {
            String pointsTransition = optionsIn[9];
            if ("ZOOM".equals(pointsTransition)) {
                this.lazyGetTemplatesComponent().setPointsTransition(PointsTransition.ZOOM);
            } else if ("ENTER_FROM_LEFT".equals(pointsTransition)) {
                this.lazyGetTemplatesComponent().setPointsTransition(PointsTransition.ENTER_FROM_LEFT);
            } else if ("BOX_OUT".equals(pointsTransition)) {
                this.lazyGetTemplatesComponent().setPointsTransition(PointsTransition.BOX_OUT);
            } else if ("SPIRAL".equals(pointsTransition)) {
                this.lazyGetTemplatesComponent().setPointsTransition(PointsTransition.SPIRAL);
            } else if ("STRETCH_LEFT".equals(pointsTransition)) {
                this.lazyGetTemplatesComponent().setPointsTransition(PointsTransition.STRETCH_LEFT);
            }
        }
    }

    private void setTemplate(String templateName) {
        if (this.getTemplateComponent() instanceof AbstractPresentationTemplateComponent) {
            AbstractPresentationTemplateComponent templateComp = (AbstractPresentationTemplateComponent)this.getTemplateComponent();
            PresentationTemplatesLoader templatesLoader = new PresentationTemplatesLoader();
            List<ITemplate> templatesList = templatesLoader.getTemplates();
            for (int i = 0; i < templatesList.size(); ++i) {
                if (!templatesList.get(i).getName().equalsIgnoreCase(templateName) || !(templatesList.get(i) instanceof IPresentationTemplate)) continue;
                templateComp.setTemplate((IPresentationTemplate)templatesList.get(i));
                break;
            }
        }
    }

    private void validateExport(IEditorComponent editorComponentIn, File outputFileIn, IExporterListener exporterListenerIn) {
        if (editorComponentIn == null) {
            throw new IllegalArgumentException("Editor component can't be null!");
        }
        if (outputFileIn == null) {
            throw new IllegalArgumentException("Out put file can't be null!");
        }
        if (exporterListenerIn == null) {
            throw new IllegalArgumentException("Exporter listener can't be null!");
        }
    }

    private void writeBranches(List<mmBranchCell> branches) {
        if (null == branches || branches.isEmpty()) {
            return;
        }
        ArrayList<mmBranchCell> branchesToOrder = new ArrayList<mmBranchCell>();
        branchesToOrder.addAll(branches);
        mmUtils.sortByOrder(branchesToOrder);
        for (mmIStructureCell mmIStructureCell2 : branchesToOrder) {
            if (!(mmIStructureCell2 instanceof mmBranchCell)) continue;
            this.writeBranch((mmBranchCell)mmIStructureCell2);
        }
    }

    public final IExporterListener getExporterListener() {
        return this.exporterListener;
    }

    public final File getOutputFile() {
        return this.outputFile;
    }

    public final void updateProgress() {
        this.progressor.processing();
    }

    protected abstract void beginDocument();

    protected abstract void endIdea(mmFloatingIdeaCell var1);

    protected abstract void beginIdea(mmFloatingIdeaCell var1);

    protected abstract void writeBranch(mmBranchCell var1);

    protected abstract void endDocument();

    private class PresentationTemplateComponentListener
    implements ITemplateComponentListener {
        private PresentationTemplateComponentListener() {
        }

        public void buttonClicked(ButtonType buttonType) {
            this.validateButtonClicked(buttonType);
            AbstractPresentationExporter.this.lazyGetTemplatesComponent().buttonClicked(buttonType);
        }

        private void validateButtonClicked(ButtonType buttonType) {
            if (buttonType == null) {
                throw new IllegalArgumentException("Button type can't be null!");
            }
        }

        public void setTemplate(String name) {
            this.validateSetTemplate(name);
            for (ITemplate template : AbstractPresentationExporter.this.lazyGetTemplates()) {
                if (!name.equalsIgnoreCase(template.getName())) continue;
                AbstractPresentationExporter.this.lazyGetTemplatesComponent().setTemplate((IPresentationTemplate)template);
                break;
            }
        }

        private void validateSetTemplate(String name) {
            if (name == null || "".equals(name.trim())) {
                throw new IllegalArgumentException("Template name can't be null!");
            }
        }

        public void resetTemplate(String name) {
            this.validateSetTemplate(name);
            for (ITemplate template : AbstractPresentationExporter.this.lazyGetTemplates()) {
                if (!name.equalsIgnoreCase(template.getName())) continue;
                AbstractPresentationExporter.this.lazyGetTemplatesComponent().resetTemplate((IPresentationTemplate)template);
                break;
            }
        }
    }
}

