/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.presentation.template;

import com.thinkbuzan.gaia.export.presentation.i18n.PresentationExporterI18N;
import com.thinkbuzan.gaia.export.presentation.template.IPresentationTemplate;
import com.thinkbuzan.gaia.export.presentation.template.PointsTransition;
import com.thinkbuzan.gaia.export.presentation.template.PresentationColor;
import com.thinkbuzan.gaia.export.presentation.template.PresentationFont;
import com.thinkbuzan.gaia.export.presentation.template.SlidesTransition;
import com.thinkbuzan.gaia.export.presentation.template.TemplateComponentSlides;
import com.thinkbuzan.gaia.export.presentation.template.impl.JFontDialog;
import com.thinkbuzan.gaia.export.presentation.template.impl.PresentationTemplate;
import com.thinkbuzan.gaia.export.template.ButtonType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AbstractPresentationTemplateComponent
extends JComponent {
    private static final long serialVersionUID = -7225609984792498589L;
    private static final int SIZE_FIVE = 5;
    private transient IPresentationTemplate template;
    private final transient JTextField headingsText = new JTextField();
    private final transient JTextField pointsText = new JTextField();
    private final transient JComboBox slidesCbx = new JComboBox<SlidesTransition>(SlidesTransition.values());
    private final transient JComboBox pointsCbx = new JComboBox<PointsTransition>(PointsTransition.values());
    private transient Font headingsFont;
    private transient Color headingsColor;
    private transient Font pointsFont;
    private transient Color pointsColor;
    private transient JPanel fontPanel;
    private transient JPanel transitionsPanel;
    private transient JLabel headingslabel;
    private transient TemplateComponentSlides componentSlides;
    private static final transient int LABEL_LENGTH = 100;

    public AbstractPresentationTemplateComponent() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.initComponent();
    }

    public final void setHeadingsFont(Font headingsFontIn) {
        this.headingsFont = headingsFontIn;
        this.saveConfigValues();
    }

    public final void setPointsFont(Font pointsFontIn) {
        this.pointsFont = pointsFontIn;
        this.saveConfigValues();
    }

    public final void setIntroductionTitleSelected(boolean selected) {
        this.componentSlides.setIntroductionTitleSelected(selected);
        this.saveConfigValues();
    }

    public final void setIntroductionImageSelected(boolean selected) {
        this.componentSlides.setIntroductionImageSelected(selected);
        this.saveConfigValues();
    }

    public final void setIntroductionMainBranchesSelected(boolean selected) {
        this.componentSlides.setIntroductionMainBranchesSelected(selected);
        this.saveConfigValues();
    }

    public final void setConclusionsMainBranchesSelected(boolean selected) {
        this.componentSlides.setConclusionsMainBranchesSelected(selected);
        this.saveConfigValues();
    }

    public final void setConclusionsImageSelected(boolean selected) {
        this.componentSlides.setConclusionsImageSelected(selected);
        this.saveConfigValues();
    }

    public final void setConclusionsTitleSelected(boolean selected) {
        this.componentSlides.setConclusionsTitleSelected(selected);
        this.saveConfigValues();
    }

    public final void setSlidesTransition(SlidesTransition transition) {
        this.slidesCbx.setSelectedItem((Object)transition);
        this.saveConfigValues();
    }

    public final void setPointsTransition(PointsTransition transition) {
        this.pointsCbx.setSelectedItem((Object)transition);
        this.saveConfigValues();
    }

    private void initComponent() {
        this.add((Component)this.initFontPanel(), "North");
        this.componentSlides = new TemplateComponentSlides();
        this.add((Component)this.componentSlides, "Center");
        this.add((Component)this.initTransitionsPanel(), "South");
    }

    private JPanel initTransitionsPanel() {
        this.transitionsPanel = new JPanel(new BorderLayout());
        Box vbox = Box.createVerticalBox();
        Box hSlidesbox = Box.createHorizontalBox();
        Box hPointsbox = Box.createHorizontalBox();
        JLabel betweenSlidesLabel = new JLabel(PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.presentationexporter.template.transitions.betweenSlides"), 4);
        JLabel betweenPointsLabel = new JLabel(PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.presentationexporter.template.transitions.betweenPoints"), 4);
        hSlidesbox.add(Box.createHorizontalStrut(5));
        hSlidesbox.add(betweenSlidesLabel);
        hSlidesbox.add(Box.createHorizontalStrut(6));
        hSlidesbox.add(this.slidesCbx);
        hPointsbox.add(Box.createHorizontalStrut(5));
        hPointsbox.add(betweenPointsLabel);
        hPointsbox.add(Box.createHorizontalStrut(5));
        hPointsbox.add(this.pointsCbx);
        vbox.add(hSlidesbox);
        vbox.add(Box.createVerticalStrut(5));
        vbox.add(hPointsbox);
        this.transitionsPanel.add((Component)vbox, "West");
        return this.transitionsPanel;
    }

    private JPanel initPointsPanel() {
        JPanel pointsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(pointsPanel, 0);
        pointsPanel.setLayout(layout);
        JLabel pointslabel = new JLabel(PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.presentationexporter.template.fonts.points"), 4);
        pointslabel.setPreferredSize(this.headingslabel.getPreferredSize());
        JButton chooseDownBtn = new JButton(PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.choose"));
        chooseDownBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractPresentationTemplateComponent.this.executePointsChoose();
            }
        });
        this.pointsText.setEditable(false);
        pointsPanel.add(Box.createHorizontalStrut(5));
        pointsPanel.add(pointslabel);
        pointsPanel.add(Box.createHorizontalStrut(5));
        pointsPanel.add(this.pointsText);
        pointsPanel.add(Box.createHorizontalStrut(5));
        pointsPanel.add(chooseDownBtn);
        pointsPanel.add(Box.createHorizontalStrut(5));
        return pointsPanel;
    }

    private JPanel initHeadingsPanel() {
        JPanel headingsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(headingsPanel, 0);
        headingsPanel.setLayout(layout);
        this.headingslabel = new JLabel(PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.headings"), 4);
        this.headingslabel.setPreferredSize(new Dimension(100, this.headingslabel.getHeight()));
        JButton chooseUpBtn = new JButton(PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.choose"));
        chooseUpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractPresentationTemplateComponent.this.executeHeadingsChoose();
            }
        });
        this.headingsText.setEditable(false);
        headingsPanel.add(Box.createHorizontalStrut(5));
        headingsPanel.add(this.headingslabel);
        headingsPanel.add(Box.createHorizontalStrut(5));
        headingsPanel.add(this.headingsText);
        headingsPanel.add(Box.createHorizontalStrut(5));
        headingsPanel.add(chooseUpBtn);
        headingsPanel.add(Box.createHorizontalStrut(5));
        return headingsPanel;
    }

    private JPanel initFontPanel() {
        this.fontPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.fontPanel, 1);
        this.fontPanel.setLayout(boxLayout);
        this.fontPanel.add(this.initHeadingsPanel());
        this.fontPanel.add(Box.createVerticalStrut(5));
        this.fontPanel.add(this.initPointsPanel());
        this.fontPanel.add(Box.createVerticalStrut(5));
        return this.fontPanel;
    }

    public final void setTemplate(IPresentationTemplate templateIn) {
        this.template = templateIn;
        if (this.template != null) {
            this.updateUIData(false);
        }
    }

    private void updateUIData(boolean base) {
        this.updateFontPanel(base);
        this.updateSlidesPanel(base);
        this.updateTransitionsPanel(base);
    }

    private void updateTransitionsPanel(boolean base) {
        this.slidesCbx.setSelectedItem((Object)this.template.getTransitionBetweenSlides());
        this.pointsCbx.setSelectedItem((Object)this.template.getTransitionBetweenPoints());
    }

    private void updateSlidesPanel(boolean base) {
        this.componentSlides.updateUI(this.template, base);
    }

    private void updateFontPanel(boolean base) {
        this.updateHeadingsValues(base);
        this.updatePointsValues(base);
    }

    public final IPresentationTemplate getTemplate() {
        return this.template;
    }

    public final void buttonClicked(ButtonType buttonType) {
        if (buttonType == ButtonType.OK) {
            if (this.template == null) {
                return;
            }
            this.saveConfigValues();
        }
    }

    private void saveConfigValues() {
        PresentationTemplate presentationTemplate = null;
        if (this.template instanceof PresentationTemplate) {
            presentationTemplate = (PresentationTemplate)this.template;
        }
        if (presentationTemplate != null) {
            this.componentSlides.saveConfigure(presentationTemplate);
            if (presentationTemplate.getFont(PresentationFont.BASE_HEADINGS) == null) {
                presentationTemplate.getFontMap().put(PresentationFont.BASE_HEADINGS, presentationTemplate.getFont(PresentationFont.HEADINGS));
                presentationTemplate.getFontMap().put(PresentationFont.BASE_POINTS, presentationTemplate.getFont(PresentationFont.POINTS));
                presentationTemplate.getColorMap().put(PresentationColor.BASE_HEADINGS, presentationTemplate.getColor(PresentationColor.HEADINGS));
                presentationTemplate.getColorMap().put(PresentationColor.BASE_POINTS, presentationTemplate.getColor(PresentationColor.POINTS));
                presentationTemplate.setTransitionBetweenPoints(presentationTemplate.getTransitionBetweenPoints());
                presentationTemplate.setTransitionBetweenSlides(presentationTemplate.getTransitionBetweenSlides());
            }
            presentationTemplate.getFontMap().put(PresentationFont.HEADINGS, this.headingsFont);
            presentationTemplate.getFontMap().put(PresentationFont.POINTS, this.pointsFont);
            presentationTemplate.getColorMap().put(PresentationColor.HEADINGS, this.headingsColor);
            presentationTemplate.getColorMap().put(PresentationColor.POINTS, this.pointsColor);
            presentationTemplate.setTransitionBetweenPoints((PointsTransition)((Object)this.pointsCbx.getSelectedItem()));
            presentationTemplate.setTransitionBetweenSlides((SlidesTransition)((Object)this.slidesCbx.getSelectedItem()));
        }
    }

    private void executeHeadingsChoose() {
        JFontDialog fontChooser = new JFontDialog(this.headingsFont, this.headingsColor);
        fontChooser.setVisible(true);
        if (fontChooser.isCancelled()) {
            return;
        }
        Font newFont = fontChooser.getFont();
        if (newFont != null) {
            Color newColor;
            this.headingsFont = newFont;
            this.headingsColor = newColor = fontChooser.getFontColor();
            StringBuilder fontText = new StringBuilder();
            fontText.append(newFont.getFamily()).append(",");
            fontText.append(newFont.getSize()).append(",");
            fontText.append(this.strStyle(newFont));
            this.headingsText.setText(fontText.toString());
            this.headingsText.setForeground(newColor);
        }
    }

    private void executePointsChoose() {
        JFontDialog fontChooser = new JFontDialog(this.pointsFont, this.pointsColor);
        fontChooser.setVisible(true);
        if (fontChooser.isCancelled()) {
            return;
        }
        Font newFont = fontChooser.getFont();
        if (newFont != null) {
            Color newColor;
            this.pointsFont = newFont;
            this.pointsColor = newColor = fontChooser.getFontColor();
            StringBuilder fontText = new StringBuilder();
            fontText.append(newFont.getFamily()).append(",");
            fontText.append(newFont.getSize()).append(",");
            fontText.append(this.strStyle(newFont));
            this.pointsText.setText(fontText.toString());
            this.pointsText.setForeground(newColor);
        }
    }

    private void updateHeadingsValues(boolean base) {
        if (base && this.template.getFont(PresentationFont.BASE_HEADINGS) != null) {
            this.headingsFont = this.template.getFont(PresentationFont.BASE_HEADINGS);
            this.headingsColor = this.template.getColor(PresentationColor.BASE_HEADINGS);
        } else {
            this.headingsFont = this.template.getFont(PresentationFont.HEADINGS);
            this.headingsColor = this.template.getColor(PresentationColor.HEADINGS);
        }
        this.headingsText.setText(this.getViewText(this.headingsFont));
        this.headingsText.setForeground(this.headingsColor);
    }

    private void updatePointsValues(boolean base) {
        if (base && this.template.getFont(PresentationFont.BASE_HEADINGS) != null) {
            this.pointsFont = this.template.getFont(PresentationFont.BASE_POINTS);
            this.pointsColor = this.template.getColor(PresentationColor.BASE_POINTS);
        } else {
            this.pointsFont = this.template.getFont(PresentationFont.POINTS);
            this.pointsColor = this.template.getColor(PresentationColor.POINTS);
        }
        this.pointsText.setText(this.getViewText(this.pointsFont));
        this.pointsText.setForeground(this.pointsColor);
    }

    private String getViewText(Font font) {
        if (font == null) {
            return "";
        }
        StringBuilder fontText = new StringBuilder();
        fontText.append(font.getFamily()).append(",");
        fontText.append(font.getSize()).append(",");
        fontText.append(this.strStyle(font));
        return fontText.toString();
    }

    private String strStyle(Font font) {
        String strStyle = font.isBold() ? (font.isItalic() ? "bold-italic" : "bold") : (font.isItalic() ? "italic" : "plain");
        return strStyle;
    }

    public final JPanel getFontPanel() {
        return this.fontPanel;
    }

    public final JPanel getSlidesPanel() {
        return this.componentSlides;
    }

    public final JPanel getTransitionsPanel() {
        return this.transitionsPanel;
    }

    public final void resetTemplate(IPresentationTemplate templateIn) {
        this.template = templateIn;
        if (this.template != null) {
            this.updateUIData(true);
        }
    }
}

