/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.presentation.template;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.gaia.export.presentation.i18n.PresentationExporterI18N;
import com.thinkbuzan.gaia.export.presentation.template.IPresentationTemplate;
import com.thinkbuzan.gaia.export.presentation.template.PresentationBoolean;
import com.thinkbuzan.gaia.export.presentation.template.PresentationFont;
import com.thinkbuzan.gaia.export.presentation.template.impl.PresentationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TemplateComponentSlides
extends JPanel {
    private static final long serialVersionUID = -3083427979236076736L;
    private final transient JCheckBox titleCkb = CoreUIFactory.createCheckBox((String)PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.title"));
    private final transient JCheckBox mainBranchesCkb = CoreUIFactory.createCheckBox((String)PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.presentationexporter.template.slides.mainBranches"));
    private final transient JCheckBox mindMapCkb = CoreUIFactory.createCheckBox((String)PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.presentationexporter.template.slides.mindMapimage"));
    private final transient JCheckBox titleUpCkb = CoreUIFactory.createCheckBox((String)PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.title"));
    private final transient JCheckBox mainBranchesUpCkb = CoreUIFactory.createCheckBox((String)PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.presentationexporter.template.slides.mainBranches"));
    private final transient JCheckBox mindMapUpCkb = CoreUIFactory.createCheckBox((String)PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.presentationexporter.template.slides.mindMapimage"));
    private transient JLabel introductionLabel;
    private static final int SIZE_FIVE = 5;

    public TemplateComponentSlides() {
        this.initSlidesPanel();
    }

    public final void setIntroductionTitleSelected(boolean selected) {
        this.titleUpCkb.setSelected(selected);
    }

    public final void setIntroductionImageSelected(boolean selected) {
        this.mindMapUpCkb.setSelected(selected);
    }

    public final void setIntroductionMainBranchesSelected(boolean selected) {
        this.mainBranchesUpCkb.setSelected(selected);
    }

    public final void setConclusionsMainBranchesSelected(boolean selected) {
        this.mainBranchesCkb.setSelected(selected);
    }

    public final void setConclusionsImageSelected(boolean selected) {
        this.mindMapCkb.setSelected(selected);
    }

    public final void setConclusionsTitleSelected(boolean selected) {
        this.titleCkb.setSelected(selected);
    }

    public final void updateUI(IPresentationTemplate template, boolean base) {
        if (base && template.getFont(PresentationFont.BASE_HEADINGS) != null) {
            this.titleUpCkb.setSelected(template.getBoolean(PresentationBoolean.BASE_INTRODUCTION_TITLE));
            this.mainBranchesUpCkb.setSelected(template.getBoolean(PresentationBoolean.BASE_INTRODUCTION_MAIN_BRANCHES));
            this.mindMapUpCkb.setSelected(template.getBoolean(PresentationBoolean.BASE_INTRODUCTION_MIND_MAP_IMAGE));
            this.titleCkb.setSelected(template.getBoolean(PresentationBoolean.BASE_CONCLUSION_TITLE));
            this.mainBranchesCkb.setSelected(template.getBoolean(PresentationBoolean.BASE_CONCLUSION_MAIN_BRANCHES));
            this.mindMapCkb.setSelected(template.getBoolean(PresentationBoolean.BASE_CONCLUSION_MIND_MAP_IMAGE));
        } else {
            this.titleUpCkb.setSelected(template.getBoolean(PresentationBoolean.INTRODUCTION_TITLE));
            this.mainBranchesUpCkb.setSelected(template.getBoolean(PresentationBoolean.INTRODUCTION_MAIN_BRANCHES));
            this.mindMapUpCkb.setSelected(template.getBoolean(PresentationBoolean.INTRODUCTION_MIND_MAP_IMAGE));
            this.titleCkb.setSelected(template.getBoolean(PresentationBoolean.CONCLUSION_TITLE));
            this.mainBranchesCkb.setSelected(template.getBoolean(PresentationBoolean.CONCLUSION_MAIN_BRANCHES));
            this.mindMapCkb.setSelected(template.getBoolean(PresentationBoolean.CONCLUSION_MIND_MAP_IMAGE));
        }
    }

    private JPanel initSlidesPanel() {
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        this.add(this.initIntroductionSlides());
        this.add(this.initConclusionSlides());
        return this;
    }

    private JPanel initConclusionSlides() {
        JLabel conclusionLabel = new JLabel(PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.presentationexporter.template.slides.conclusion"), 2);
        conclusionLabel.setPreferredSize(this.introductionLabel.getPreferredSize());
        JPanel conclusionPanel = new JPanel(new BorderLayout());
        JPanel checkBoxPanel = new JPanel(new FlowLayout());
        conclusionLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        conclusionPanel.add((Component)conclusionLabel, "First");
        checkBoxPanel.add(this.mainBranchesCkb);
        checkBoxPanel.add(this.mindMapCkb);
        checkBoxPanel.add(this.titleCkb);
        checkBoxPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        conclusionPanel.add((Component)checkBoxPanel, "Before");
        return conclusionPanel;
    }

    private JPanel initIntroductionSlides() {
        this.introductionLabel = new JLabel(PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.presentationexporter.template.slides.introduction"), 2);
        JPanel introductionPanel = new JPanel(new BorderLayout());
        JPanel checkBoxPanel = new JPanel(new FlowLayout());
        this.introductionLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        introductionPanel.add((Component)this.introductionLabel, "First");
        checkBoxPanel.add(this.titleUpCkb);
        checkBoxPanel.add(this.mindMapUpCkb);
        checkBoxPanel.add(this.mainBranchesUpCkb);
        checkBoxPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        introductionPanel.add((Component)checkBoxPanel, "Before");
        return introductionPanel;
    }

    public final void saveConfigure(IPresentationTemplate template) {
        PresentationTemplate presentationTemplate = (PresentationTemplate)template;
        if (presentationTemplate.getFont(PresentationFont.BASE_HEADINGS) == null) {
            presentationTemplate.getBooleanMap().put(PresentationBoolean.BASE_INTRODUCTION_TITLE, presentationTemplate.getBoolean(PresentationBoolean.INTRODUCTION_TITLE));
            presentationTemplate.getBooleanMap().put(PresentationBoolean.BASE_INTRODUCTION_MAIN_BRANCHES, presentationTemplate.getBoolean(PresentationBoolean.INTRODUCTION_MAIN_BRANCHES));
            presentationTemplate.getBooleanMap().put(PresentationBoolean.BASE_INTRODUCTION_MIND_MAP_IMAGE, presentationTemplate.getBoolean(PresentationBoolean.INTRODUCTION_MIND_MAP_IMAGE));
            presentationTemplate.getBooleanMap().put(PresentationBoolean.BASE_CONCLUSION_TITLE, presentationTemplate.getBoolean(PresentationBoolean.CONCLUSION_TITLE));
            presentationTemplate.getBooleanMap().put(PresentationBoolean.BASE_CONCLUSION_MAIN_BRANCHES, presentationTemplate.getBoolean(PresentationBoolean.CONCLUSION_MAIN_BRANCHES));
            presentationTemplate.getBooleanMap().put(PresentationBoolean.BASE_CONCLUSION_MIND_MAP_IMAGE, presentationTemplate.getBoolean(PresentationBoolean.CONCLUSION_MIND_MAP_IMAGE));
        }
        presentationTemplate.getBooleanMap().put(PresentationBoolean.INTRODUCTION_TITLE, this.titleUpCkb.isSelected());
        presentationTemplate.getBooleanMap().put(PresentationBoolean.INTRODUCTION_MAIN_BRANCHES, this.mainBranchesUpCkb.isSelected());
        presentationTemplate.getBooleanMap().put(PresentationBoolean.INTRODUCTION_MIND_MAP_IMAGE, this.mindMapUpCkb.isSelected());
        presentationTemplate.getBooleanMap().put(PresentationBoolean.CONCLUSION_TITLE, this.titleCkb.isSelected());
        presentationTemplate.getBooleanMap().put(PresentationBoolean.CONCLUSION_MAIN_BRANCHES, this.mainBranchesCkb.isSelected());
        presentationTemplate.getBooleanMap().put(PresentationBoolean.CONCLUSION_MIND_MAP_IMAGE, this.mindMapCkb.isSelected());
    }
}

