/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.presentation.template.impl;

import com.thinkbuzan.gaia.export.presentation.i18n.PresentationExporterI18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class JFontDialog
extends JDialog {
    private static final long serialVersionUID = -2719422175776167358L;
    private static final Logger LOG = Logger.getLogger(JFontDialog.class);
    private static final int DIALOG_WIDTH = 450;
    private static final int DIALOG_HEIGHT = 400;
    private transient JList fontFamilyList = null;
    private transient JList fontStyleList = null;
    private transient JList fontSizeList = null;
    private transient JColorChooser colorChooser = null;
    private static JLabel previewLabel;
    private transient Font font = null;
    private transient Color fontColor = null;
    private transient boolean cancelled;

    public JFontDialog(Font fontIn, Color colorIn) {
        super(JOptionPane.getRootFrame(), PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.documentexporter.component.fontdialog.title"), true);
        this.initial(fontIn, colorIn);
        this.setLocationRelativeTo(JOptionPane.getRootFrame());
    }

    public JFontDialog(JDialog parent, Font fontIn, Color colorIn) {
        super(parent, PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.documentexporter.component.fontdialog.title"), true);
        this.initial(fontIn, colorIn);
        this.setLocationRelativeTo(parent);
    }

    public JFontDialog(JFrame parent, Font fontIn, Color colorIn) {
        super(parent, PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.documentexporter.component.fontdialog.title"), true);
        this.initial(fontIn, colorIn);
        this.setLocationRelativeTo(parent);
    }

    private void initial(Font fontIn, Color colorIn) {
        this.cancelled = true;
        this.fontColor = null == this.fontColor ? Color.BLACK : colorIn;
        if (null == fontIn) {
            int defaultFontSize = 12;
            this.font = new Font("", 1, 12);
        } else {
            this.font = fontIn;
        }
        this.initComponents();
        this.setLayout();
        this.addFontSelectListeners();
        this.initFont();
    }

    private void setLayout() {
        this.setLayout(new BorderLayout());
        this.setSize(450, 400);
        this.setResizable(false);
        this.add((Component)this.getFontChooserPane(), "North");
        this.add((Component)this.getColorPanel(), "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        int southPanelWidth = 100;
        southPanel.setPreferredSize(new Dimension(450, 100));
        southPanel.add((Component)this.getFontPreviewPane(), "North");
        southPanel.add((Component)this.getButtonsPanel(), "South");
        this.add((Component)southPanel, "South");
    }

    private void initComponents() {
        this.initFontLists();
        previewLabel = new JLabel("ABCabc123");
    }

    private void initFontLists() {
        String[] fontStyles = new String[]{"PLAIN", "BOLD", "ITALIC", "ITALIC-BOLD"};
        String[] fontSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "18", "20", "22", "24", "28", "32", "36", "40", "44", "48"};
        String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontFamilyList = new JList<String>(fontFamilies);
        this.fontStyleList = new JList<String>(fontStyles);
        this.fontSizeList = new JList<String>(fontSizes);
    }

    private void initFont() {
        this.fontColorSelection();
        this.fontFamilyList.setSelectedIndex(0);
        this.fontStyleList.setSelectedIndex(this.font.getStyle());
        try {
            this.fontFamilyList.setSelectedValue(this.font.getFamily(), true);
            this.fontSizeList.setSelectedValue(Integer.toString(this.font.getSize()), true);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void addFontSelectListeners() {
        this.fontFamilyList.addListSelectionListener(this.getFontFamilySelectionListener());
        this.fontStyleList.addListSelectionListener(this.getFontStyleSelectionListener());
        this.fontSizeList.addListSelectionListener(this.getFontSizeSelectionListener());
        this.colorChooser.getSelectionModel().addChangeListener(this.getFontColorSelectionListener());
    }

    private ListSelectionListener getFontFamilySelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg) {
                String family = (String)JFontDialog.this.fontFamilyList.getSelectedValue();
                Font tempFont = JFontDialog.this.font;
                JFontDialog.this.font = new Font(family, tempFont.getStyle(), tempFont.getSize());
                previewLabel.setFont(JFontDialog.this.font);
            }
        };
    }

    private ListSelectionListener getFontStyleSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                int style = 0;
                switch (JFontDialog.this.fontStyleList.getSelectedIndex()) {
                    case 0: {
                        style = 0;
                        break;
                    }
                    case 1: {
                        style = 1;
                        break;
                    }
                    case 2: {
                        style = 2;
                        break;
                    }
                    default: {
                        style = 3;
                    }
                }
                Font tempFont = JFontDialog.this.font;
                JFontDialog.this.font = new Font(tempFont.getFamily(), style, tempFont.getSize());
                previewLabel.setFont(JFontDialog.this.font);
            }
        };
    }

    private ListSelectionListener getFontSizeSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                Font tempFont = JFontDialog.this.font;
                int size = Integer.parseInt((String)JFontDialog.this.fontSizeList.getSelectedValue());
                JFontDialog.this.font = new Font(tempFont.getFamily(), tempFont.getStyle(), size);
                previewLabel.setFont(JFontDialog.this.font);
            }
        };
    }

    private ChangeListener getFontColorSelectionListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JFontDialog.this.fontColorSelection();
            }
        };
    }

    private void fontColorSelection() {
        this.fontColor = this.colorChooser.getColor();
        previewLabel.setForeground(this.colorChooser.getColor());
        previewLabel.repaint();
    }

    private JPanel getFontChooserPane() {
        JPanel panel = new JPanel(new GridLayout(1, 3));
        int fontChoosePaneHeight = 110;
        panel.setPreferredSize(new Dimension(450, 110));
        panel.add(this.getFontFamiliesPane());
        panel.add(this.getFontStylesPane());
        panel.add(this.getFontSizesPane());
        return panel;
    }

    private JScrollPane getFontFamiliesPane() {
        JScrollPane scrollPane = new JScrollPane(this.fontFamilyList);
        scrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.family")));
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    private JScrollPane getFontStylesPane() {
        JScrollPane scrollPane = new JScrollPane(this.fontStyleList);
        scrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.style")));
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    private JScrollPane getFontSizesPane() {
        JScrollPane scrollPane = new JScrollPane(this.fontSizeList);
        scrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.size")));
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    private JPanel getFontPreviewPane() {
        JPanel panel = new JPanel(new FlowLayout());
        int fontPreviewPaneHeight = 70;
        panel.setPreferredSize(new Dimension(450, 70));
        panel.add(previewLabel);
        return panel;
    }

    private JPanel getButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 0));
        panel.add(Box.createGlue());
        JButton okButton = new JButton(PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.ok"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JFontDialog.this.cancelled = false;
                JFontDialog.this.setVisible(false);
            }
        });
        panel.add(okButton);
        JButton cancelButton = new JButton(PresentationExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JFontDialog.this.setVisible(false);
            }
        });
        panel.add(cancelButton);
        return panel;
    }

    private JComponent getColorPanel() {
        this.colorChooser = new JColorChooser(this.fontColor);
        this.colorChooser.setPreviewPanel(new JPanel());
        return this.colorChooser;
    }

    public final Font getFont() {
        return this.font;
    }

    public final Color getFontColor() {
        return this.fontColor;
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }
}

