/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.presentation.template.impl;

import com.thinkbuzan.gaia.export.presentation.template.IPresentationTemplate;
import com.thinkbuzan.gaia.export.presentation.template.PointsTransition;
import com.thinkbuzan.gaia.export.presentation.template.PresentationBoolean;
import com.thinkbuzan.gaia.export.presentation.template.PresentationColor;
import com.thinkbuzan.gaia.export.presentation.template.PresentationFont;
import com.thinkbuzan.gaia.export.presentation.template.SlidesTransition;
import com.thinkbuzan.gaia.export.presentation.template.resources.PresentationExporterResourcesManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationTemplate
implements IPresentationTemplate {
    private transient String name;
    private transient String previewImageFilename;
    private transient Image previewImage;
    private transient SlidesTransition slidesTransition;
    private transient PointsTransition pointsTransition;
    private final transient Map<PresentationColor, Color> colorMap = new HashMap<PresentationColor, Color>();
    private final transient Map<PresentationFont, Font> fontMap = new HashMap<PresentationFont, Font>();
    private final transient Map<PresentationBoolean, Boolean> booleanMap = new HashMap<PresentationBoolean, Boolean>();
    private static final transient Logger LOGGER = Logger.getLogger(PresentationTemplate.class);

    @Override
    public final boolean getBoolean(PresentationBoolean booleanType) {
        this.validateGetBoolean(booleanType);
        Boolean b = this.booleanMap.get((Object)booleanType);
        if (b == null) {
            return false;
        }
        return b;
    }

    private void validateGetBoolean(PresentationBoolean booleanType) {
        if (booleanType == null) {
            throw new IllegalArgumentException("PresentationBoolean can't be null!");
        }
    }

    @Override
    public final Color getColor(PresentationColor colorType) {
        this.validateGetColor(colorType);
        return this.colorMap.get((Object)colorType);
    }

    private void validateGetColor(PresentationColor colorType) {
        if (colorType == null) {
            throw new IllegalArgumentException("PresentationColor can't be null!");
        }
    }

    @Override
    public final Font getFont(PresentationFont fontType) {
        this.validateGetFont(fontType);
        return this.fontMap.get((Object)fontType);
    }

    private void validateGetFont(PresentationFont fontType) {
        if (fontType == null) {
            throw new IllegalArgumentException("PresentationFont can't be null!");
        }
    }

    @Override
    public final PointsTransition getTransitionBetweenPoints() {
        return this.pointsTransition;
    }

    @Override
    public final SlidesTransition getTransitionBetweenSlides() {
        return this.slidesTransition;
    }

    public final String getName() {
        return this.name;
    }

    public final void setTransitionBetweenSlides(SlidesTransition slidesTransitionIn) {
        this.validateSetTransitionBetweenSlides(slidesTransitionIn);
        LOGGER.debug((Object)("setTransitionsBetweenSlides Called: " + (Object)((Object)slidesTransitionIn)));
        this.slidesTransition = slidesTransitionIn;
    }

    private void validateSetTransitionBetweenSlides(SlidesTransition slidesTransitionIn) {
        if (slidesTransitionIn == null) {
            throw new IllegalArgumentException("slides transition can't be sent to null");
        }
    }

    public final void setTransitionBetweenPoints(PointsTransition pointsTransitionIn) {
        this.validateSetTransitionBetweenPoints(pointsTransitionIn);
        LOGGER.debug((Object)("setTransitionsBetweenPoints Called: " + (Object)((Object)pointsTransitionIn)));
        this.pointsTransition = pointsTransitionIn;
    }

    private void validateSetTransitionBetweenPoints(PointsTransition pointsTransitionIn) {
        if (pointsTransitionIn == null) {
            throw new IllegalArgumentException("PointsTransition can't be setted to null!");
        }
    }

    public final Map<PresentationColor, Color> getColorMap() {
        return this.colorMap;
    }

    public final Map<PresentationBoolean, Boolean> getBooleanMap() {
        return this.booleanMap;
    }

    public final Map<PresentationFont, Font> getFontMap() {
        return this.fontMap;
    }

    public final void setName(String nameIn) {
        this.validateSetName(nameIn);
        this.name = nameIn;
    }

    private void validateSetName(String nameIn) {
        if (nameIn == null || "".equals(nameIn.trim())) {
            throw new IllegalArgumentException("Template name can't be set to null!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Image getPreviewImage() {
        PresentationTemplate presentationTemplate = this;
        synchronized (presentationTemplate) {
            if (this.previewImage == null) {
                this.previewImage = PresentationExporterResourcesManager.getImage(this.previewImageFilename);
            }
            return this.previewImage;
        }
    }

    public String createBase64PNGStringPreviewImage() {
        try {
            InputStream input = PresentationExporterResourcesManager.class.getResourceAsStream(this.previewImageFilename);
            byte[] bytes = IOUtils.toByteArray((InputStream)input);
            return Base64.encodeBase64String((byte[])bytes);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Caught Exception", (Throwable)exception);
            return "";
        }
    }

    public final void setPreviewImageFilename(String previewImageFilenameIn) {
        this.previewImageFilename = previewImageFilenameIn;
    }
}

