/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.presentation.template.impl;

import com.thinkbuzan.gaia.export.presentation.i18n.PresentationExporterI18N;
import com.thinkbuzan.gaia.export.presentation.template.IPresentationTemplate;
import com.thinkbuzan.gaia.export.presentation.template.PointsTransition;
import com.thinkbuzan.gaia.export.presentation.template.PresentationBoolean;
import com.thinkbuzan.gaia.export.presentation.template.PresentationColor;
import com.thinkbuzan.gaia.export.presentation.template.PresentationFont;
import com.thinkbuzan.gaia.export.presentation.template.SlidesTransition;
import com.thinkbuzan.gaia.export.presentation.template.impl.PresentationTemplate;
import com.thinkbuzan.gaia.export.presentation.template.resources.PresentationExporterResourcesManager;
import com.thinkbuzan.gaia.export.template.ITemplate;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PresentationTemplatesLoader {
    private static final String TEMPLATE_TAG = "PresentationTemplate";
    private static final String TEMPLATE_NAME_ATT = "name";
    private static final String TEMPLATE_IMAGEFILE_ATT = "imagefile";
    private static final String BOOLEAN_TAG = "PresentationBoolean";
    private static final String BOOLEAN_TYPE_ATT = "type";
    private static final String BOOLEAN_VALUE_ATT = "value";
    private static final String FONT_TAG = "PresentationFont";
    private static final String FONT_TYPE_ATT = "type";
    private static final String FONT_FONT_TAG = "Font";
    private static final String FONT_FONT_NAME_ATT = "name";
    private static final String FONT_FONT_SIZE_ATT = "size";
    private static final String FONT_FONT_STYLE_ATT = "style";
    private static final String COLOR_TAG = "PresentationColor";
    private static final String COLOR_TYPE_ATT = "type";
    private static final String COLOR_COLOR_TAG = "Color";
    private static final String COLOR_COLOR_R_ATT = "r";
    private static final String COLOR_COLOR_G_ATT = "g";
    private static final String COLOR_COLOR_B_ATT = "b";
    private static final String SLIDES_TAG = "PresentationTransitionBetweenSlides";
    private static final String SLIDES_VALUE_ATT = "value";
    private static final String POINTS_TAG = "PresentationTransitionBetweenPoints";
    private static final String POINTS_VALUE_ATT = "value";
    private final transient List<ITemplate> presentationTemplates = new ArrayList<ITemplate>();

    public PresentationTemplatesLoader() {
        Document doc = PresentationExporterResourcesManager.getTemplateDocument();
        Element root = doc.getRootElement();
        List templates = root.getChildren(TEMPLATE_TAG);
        for (Element template : templates) {
            IPresentationTemplate presentationTemplate = this.processTemplateElement(template);
            this.presentationTemplates.add(presentationTemplate);
        }
    }

    private IPresentationTemplate processTemplateElement(Element template) {
        Element point;
        PresentationTemplate presentationTemplate = new PresentationTemplate();
        String templateName = template.getAttributeValue("name");
        presentationTemplate.setName(PresentationExporterI18N.getLocalizedText(templateName));
        String iconName = template.getAttributeValue(TEMPLATE_IMAGEFILE_ATT);
        presentationTemplate.setPreviewImageFilename(iconName);
        List presentationBooleans = template.getChildren(BOOLEAN_TAG);
        for (Element docBoolean : presentationBooleans) {
            this.processPresentationBoolean(presentationTemplate, docBoolean);
        }
        List presentationFonts = template.getChildren(FONT_TAG);
        for (Element docFont : presentationFonts) {
            this.processPresentationFont(presentationTemplate, docFont);
        }
        List presentationColors = template.getChildren(COLOR_TAG);
        for (Element docColor : presentationColors) {
            this.processPresentationColor(presentationTemplate, docColor);
        }
        Element slide = template.getChild(SLIDES_TAG);
        if (slide != null) {
            this.processBetweenSlides(presentationTemplate, slide);
        }
        if ((point = template.getChild(POINTS_TAG)) != null) {
            this.processBetweenPoints(presentationTemplate, point);
        }
        return presentationTemplate;
    }

    private void processPresentationColor(PresentationTemplate presentationTemplate, Element docColor) {
        String colorType = docColor.getAttributeValue("type");
        PresentationColor dColor = PresentationColor.valueOf(colorType);
        Element cElement = docColor.getChild(COLOR_COLOR_TAG);
        String red = cElement.getAttributeValue(COLOR_COLOR_R_ATT);
        String green = cElement.getAttributeValue(COLOR_COLOR_G_ATT);
        String blue = cElement.getAttributeValue(COLOR_COLOR_B_ATT);
        Color color = new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue));
        presentationTemplate.getColorMap().put(dColor, color);
    }

    private void processPresentationFont(PresentationTemplate presentationTemplate, Element docFont) {
        String type = docFont.getAttributeValue("type");
        PresentationFont dFont = PresentationFont.valueOf(type);
        Element fElement = docFont.getChild(FONT_FONT_TAG);
        String fontName = fElement.getAttributeValue("name");
        String fontSize = fElement.getAttributeValue(FONT_FONT_SIZE_ATT);
        String fontStyle = fElement.getAttributeValue(FONT_FONT_STYLE_ATT);
        Font font = new Font(fontName, Integer.parseInt(fontStyle), Integer.parseInt(fontSize));
        presentationTemplate.getFontMap().put(dFont, font);
    }

    private void processPresentationBoolean(PresentationTemplate presentationTemplate, Element documentBoolean) {
        String typeName = documentBoolean.getAttributeValue("type");
        PresentationBoolean type = PresentationBoolean.valueOf(typeName);
        String value = documentBoolean.getAttributeValue("value");
        boolean booleanValue = Boolean.parseBoolean(value);
        presentationTemplate.getBooleanMap().put(type, booleanValue);
    }

    private void processBetweenPoints(PresentationTemplate presentationTemplate, Element point) {
        String value = point.getAttributeValue("value");
        PointsTransition pointsTransition = PointsTransition.valueOf(value);
        presentationTemplate.setTransitionBetweenPoints(pointsTransition);
    }

    private void processBetweenSlides(PresentationTemplate documentTemplate, Element slide) {
        String value = slide.getAttributeValue("value");
        SlidesTransition slidesTransition = SlidesTransition.valueOf(value);
        documentTemplate.setTransitionBetweenSlides(slidesTransition);
    }

    public List<ITemplate> getTemplates() {
        return this.presentationTemplates;
    }
}

