/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.presentation.template.resources;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class PresentationExporterResourcesManager {
    private static final Logger LOG = Logger.getLogger(PresentationExporterResourcesManager.class);
    private static final String TEMPLATE_FILE = "PresentationTemplates.xml";

    private PresentationExporterResourcesManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(String name) {
        InputStream templateFileStream = null;
        try {
            templateFileStream = PresentationExporterResourcesManager.class.getResourceAsStream(name);
            BufferedImage bufferedImage = ImageIO.read(templateFileStream);
            return bufferedImage;
        }
        catch (Exception e) {
            LOG.error((Object)("read template's icon " + name + " failed."), (Throwable)e);
        }
        finally {
            if (templateFileStream != null) {
                try {
                    templateFileStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Close input stream failed!");
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getTemplateDocument() {
        InputStream templateFileStream = null;
        try {
            templateFileStream = PresentationExporterResourcesManager.class.getResourceAsStream(TEMPLATE_FILE);
            Document document = PresentationExporterResourcesManager.getTemplateDocument(templateFileStream);
            return document;
        }
        finally {
            if (templateFileStream != null) {
                try {
                    templateFileStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Close input stream failed!");
                }
            }
        }
    }

    public static Document getTemplateDocument(InputStream in) {
        try {
            SAXBuilder builder = new SAXBuilder();
            return builder.build(in);
        }
        catch (JDOMException e) {
            LOG.error((Object)"Build document from XML file failed!", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IOException happened when build document from XML file.", (Throwable)e);
        }
        return null;
    }
}

