/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.presentation.util;

import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.model.mxICell;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.export.IExporterListener;
import java.util.List;

public class ProcessProgressor {
    private transient float progress = 0.0f;
    private transient float progressCell = 0.0f;
    private final transient IExporterListener exporterListener;
    private static final transient float PROCESS_BEFORE_PROCESSING = 0.1f;
    private static final transient float PROCESS_AFTER_PROCESSING = 0.9f;

    public ProcessProgressor(IEditorComponent editorComponent, IExporterListener exporterListenerIn) {
        this.exporterListener = exporterListenerIn;
        float processPart = 0.8f;
        this.progressCell = 0.8f / (float)this.getTotalBranches(editorComponent);
    }

    public final void startProcess() {
        this.progress = 0.0f;
        this.exporterListener.exportProgress(this.progress);
    }

    public final void beforeProcessing() {
        this.progress = 0.1f;
        this.exporterListener.exportProgress(this.progress);
    }

    public final void processing() {
        if (this.progress < 0.1f) {
            this.beforeProcessing();
        }
        this.progress = this.progress + this.progressCell > 0.9f ? 0.9f : (this.progress += this.progressCell);
        this.exporterListener.exportProgress(this.progress);
    }

    public final void afterProcessing() {
        this.progress = 0.9f;
        this.exporterListener.exportProgress(this.progress);
    }

    public final void endProcess() {
        this.progress = 1.0f;
        this.exporterListener.exportProgress(this.progress);
    }

    private int getSubTotalCount(IEditorComponent editorComponent, mmBranchCell branchCell) {
        int subTotal = 0;
        List subCells = editorComponent.getBranches((mxICell)branchCell);
        if (null != subCells && !subCells.isEmpty()) {
            subTotal = subCells.size();
            for (mmBranchCell subBranchCell : subCells) {
                subTotal += this.getSubTotalCount(editorComponent, subBranchCell);
            }
        }
        return subTotal;
    }

    private int getTotalBranches(IEditorComponent editorComponent) {
        int total = 1;
        List floatingIdeas = editorComponent.getFloatingIdeas();
        for (mmFloatingIdeaCell mxICell2 : floatingIdeas) {
            List subCells = editorComponent.getBranches((mxICell)mxICell2);
            total += subCells.size();
            for (mmBranchCell subBranchCell : subCells) {
                total += this.getSubTotalCount(editorComponent, subBranchCell);
            }
        }
        return total;
    }
}

