/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.splash.activator;

import com.thinkbuzan.chaos.splash.SplashService;
import java.io.File;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final String PROP_CACHE_CLEAR_FLAG_PATH = "osgi.clean.cache.flag.path";
    private static int bundlesStarted = 1;

    public void start(BundleContext bundleContext) {
        final SplashService splashService = this.getSplashService(bundleContext);
        if (splashService != null) {
            splashService.setVisible(true);
            String string = System.getProperty("firstRun");
            boolean bl = false;
            if (string != null && string.equals("true")) {
                bl = true;
            }
            if (this.isOsgiCacheUsedOnLaunch() && !bl) {
                splashService.setModuleCount(1, bundleContext.getBundles().length);
                bundleContext.addBundleListener(new BundleListener(){

                    public void bundleChanged(BundleEvent bundleEvent) {
                        int n;
                        if (bundleEvent.getType() == 2 && (n = splashService.getNumberOfBundlesWhichActivateOnStart()) > 0) {
                            splashService.setPhaseCount(1);
                            splashService.setModuleCount(1, n);
                            splashService.incrementLoadedModuleCount(1, 1);
                            bundlesStarted++;
                        }
                    }
                });
            }
        }
    }

    private boolean isOsgiCacheUsedOnLaunch() {
        String string = this.getOsgiCleanCacheFlagFilePath();
        if (string == null) {
            return false;
        }
        File file = new File(string);
        return !file.exists();
    }

    private String getOsgiCleanCacheFlagFilePath() {
        return System.getProperty(PROP_CACHE_CLEAR_FLAG_PATH);
    }

    private SplashService getSplashService(BundleContext bundleContext) {
        ServiceTracker serviceTracker = new ServiceTracker(bundleContext, SplashService.class.getName(), null);
        serviceTracker.open();
        SplashService splashService = (SplashService)serviceTracker.getService();
        serviceTracker.close();
        return splashService;
    }

    public void stop(BundleContext bundleContext) {
    }
}

