/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.shortcutmanager.impl;

import com.buzanonline.chaos.action.ActionManager;
import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.gaia.shortcutmanager.ShortcutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShortcutManagerImpl
implements ShortcutManager {
    public static final String GLOBAL = "global";
    public static final String EDITOR = "editor";
    private static final Logger LOGGER = Logger.getLogger(ShortcutManagerImpl.class);
    private final transient ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ActionManager actionManager;
    private final String control = "ctrl";
    private final String commandMac = "meta";
    private final Map<String, List<ShortcutDefinition>> allShortcuts;

    private void validateCreateShortcuts(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("ShortcutManager, param inputStream is null");
        }
    }

    public ShortcutManagerImpl(ActionManager actionManager) {
        if (actionManager == null) {
            throw new IllegalArgumentException("actionManagerIn cannot be null!");
        }
        this.actionManager = actionManager;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"ShortcutManagerImpl created");
        }
        this.allShortcuts = new HashMap<String, List<ShortcutDefinition>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStroke getMenuAcceleratorForAction(String string) {
        this.lock.readLock().lock();
        try {
            Object object = null;
            if (string != null) {
                for (Map.Entry<String, List<ShortcutDefinition>> entry : this.allShortcuts.entrySet()) {
                    if (entry.getValue() == null) continue;
                    for (ShortcutDefinition shortcutDefinition : entry.getValue()) {
                        if (!string.equals(shortcutDefinition.action)) continue;
                        object = shortcutDefinition.stroke;
                        break;
                    }
                    if (object == null) continue;
                    break;
                }
            }
            Iterator<Map.Entry<String, List<ShortcutDefinition>>> iterator = object;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installShortcutsOnMainFrame(JFrame jFrame) {
        if (jFrame == null) {
            throw new IllegalArgumentException("Cannot install shortcuts on a null frame!");
        }
        this.lock.readLock().lock();
        try {
            jFrame.setFocusTraversalKeysEnabled(false);
            JRootPane jRootPane = jFrame.getRootPane();
            InputMap inputMap = jRootPane.getInputMap(2);
            ActionMap actionMap = jRootPane.getRootPane().getActionMap();
            List<ShortcutDefinition> list = this.allShortcuts.get(GLOBAL);
            if (list == null) {
                LOGGER.fatal((Object)"could not get the global shortcuts");
                return;
            }
            for (ShortcutDefinition shortcutDefinition : list) {
                if (actionMap != null) {
                    actionMap.put(shortcutDefinition.name, new GaiaAction(this.actionManager, shortcutDefinition.action));
                }
                if (inputMap == null) continue;
                inputMap.put(shortcutDefinition.stroke, shortcutDefinition.name);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createShortcuts(InputStream inputStream) {
        this.lock.writeLock().lock();
        try {
            this.initialise(inputStream);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void initialise(InputStream inputStream) {
        this.validateCreateShortcuts(inputStream);
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(inputStream);
            this.readShortcuts(document);
        }
        catch (JDOMException jDOMException) {
            LOGGER.error((Object)"Could not create shortcuts, jdom parse failed ", (Throwable)jDOMException);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Could not create shortcuts, could not read input stream ", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installShortcuts(JComponent jComponent, String string) {
        this.lock.readLock().lock();
        try {
            this.doInstallShortcuts(jComponent, string);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void doInstallShortcuts(JComponent jComponent, String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("install " + string + " shorcuts on " + jComponent));
        }
        jComponent.setFocusTraversalKeysEnabled(false);
        InputMap inputMap = jComponent.getInputMap(0);
        ActionMap actionMap = jComponent.getActionMap();
        List<ShortcutDefinition> list = this.allShortcuts.get(string);
        if (list == null) {
            LOGGER.fatal((Object)"could not get the global shortcuts");
            return;
        }
        for (ShortcutDefinition shortcutDefinition : list) {
            actionMap.put(shortcutDefinition.name, new GaiaAction(this.actionManager, shortcutDefinition.action));
            inputMap.put(shortcutDefinition.stroke, shortcutDefinition.name);
        }
    }

    private void readShortcuts(Document document) {
        List list = document.getRootElement().getChildren();
        for (Element element : list) {
            LinkedList<ShortcutDefinition> linkedList = new LinkedList<ShortcutDefinition>();
            this.allShortcuts.put(element.getName(), linkedList);
            List list2 = element.getChildren();
            for (Element element2 : list2) {
                if (element2.getName() != "item") continue;
                Attribute attribute = element2.getAttribute("keystroke");
                Attribute attribute2 = element2.getAttribute("action");
                if (attribute == null || attribute2 == null) {
                    throw new IllegalStateException("parsing shortcuts failed, shortcut item must contain 'keystroke' and 'action' attributes");
                }
                String string = attribute.getValue();
                String string2 = attribute2.getValue();
                Attribute attribute3 = element2.getAttribute("name");
                String string3 = attribute3 != null ? attribute3.getValue() : string2;
                String string4 = string.contains("MASK") ? this.unmaskShortcut(string) : string;
                KeyStroke keyStroke = KeyStroke.getKeyStroke(string4);
                if (keyStroke == null) {
                    LOGGER.warn((Object)("could not get keystroke for " + string + " the action " + string2 + " has not been assigned"));
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("adding action " + string3 + " for keystroke " + keyStroke + "(" + string + ")"));
                }
                linkedList.add(new ShortcutDefinition(string3, keyStroke, string2));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("found following groups of shortcuts " + this.allShortcuts.keySet()));
        }
    }

    private String unmaskShortcut(String string) {
        if (SystemInfo.isWindows() || SystemInfo.isLinux()) {
            String string2 = string.replace("MASK", this.control);
            return string2;
        }
        if (SystemInfo.isMacOSX()) {
            String string3 = string.replace("MASK", this.commandMac);
            return string3;
        }
        throw new UnsupportedOperationException(String.format("Unsupported Operating System: %s", SystemInfo.getOS()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShortcutDefinition> getShortcuts(String string) {
        this.lock.readLock().lock();
        try {
            List<ShortcutDefinition> list = this.allShortcuts.get(string);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static class GaiaAction
    extends AbstractAction {
        private static final long serialVersionUID = 5711558263023355709L;
        private final ActionManager manager;
        private final String actionKey;

        public GaiaAction(ActionManager actionManager, String string) {
            this.manager = actionManager;
            this.actionKey = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.manager.runAction(this.actionKey, new Object[0]);
        }
    }

    public static final class ShortcutDefinition {
        public final String name;
        public final KeyStroke stroke;
        public final String action;

        public ShortcutDefinition(String string, KeyStroke keyStroke, String string2) {
            this.name = string;
            this.stroke = keyStroke;
            this.action = string2;
        }
    }
}

