/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.splash.impl;

import com.thinkbuzan.chaos.splash.SplashService;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SplashScreen
implements SplashService {
    public static final Logger LOGGER = Logger.getLogger(SplashScreen.class.getName());
    public static final String SPLASH_IMAGE_PATH = "com/thinkbuzan/chaos/splash/resource/splash";
    public static final String RETINA = "@2x";
    public static final String PNG = ".png";
    public static final String SPLASH_FRAME_ICON_PATH = "com/thinkbuzan/chaos/splash/resource/icon.png";
    public static final int DEFAULT_SPLASH_WIDTH = 550;
    public static final int DEFAULT_SPLASH_HEIGHT = 347;
    public static final float DEFAULT_PROGRESSBAR_X_SCALE = 0.04f;
    public static final float DEFAULT_PROGRESSBAR_Y_SCALE = 0.92f;
    public static final int DEFAULT_PROGRESSBAR_HEIGHT = 5;
    public static final Color PROGRESSBAR_COLOR = new Color(255, 255, 255, 255);
    public static final Color PROGRESSBAR_OUTER_BORDER_COLOR = Color.decode("#1BD1E1");
    public static final Color PROGRESSBAR_INNER_BORDER_COLOR = new Color(200, 200, 200, 0);
    public static final Color PROGRESSBAR_TEXT_COLOR = Color.decode("#1BD1E1");
    private final transient int splashWidth;
    private final transient int splashHeight;
    private transient int progressBarX;
    private transient int progressBarY;
    private transient int progressBarWidth;
    private transient int progressBarHeight;
    private transient boolean progressBarShowing = false;
    private transient int progressWidth;
    private transient int phaseCount = 0;
    private final transient Map<Integer, Integer> moduleCount;
    private final transient Map<Integer, Integer> loadedCount;
    private transient JFrame splashWindow;
    private transient SplashPanel splash;
    private transient int numberBundlesActiveOnStart = 0;
    private static final int SPLASH_TEXT_BORDER = 5;
    private static final String PROP_CACHE_CLEAR_FLAG_PATH = "osgi.clean.cache.flag.path";
    private transient ResourceBundle resourceBundle = null;
    private transient int numberPaintCalls = 0;
    private static final int NUMBER_CALLS_BEFORE_PAINT = 12;
    private transient boolean setVisible;
    private transient boolean startRequested;

    public static void main(String[] stringArray) {
    }

    public SplashScreen(int n, int n2) {
        this.validateSplashScreen(n, n2);
        this.splashWidth = n;
        this.splashHeight = n2;
        this.progressBarX = (int)((float)n * 0.04f);
        this.progressBarY = (int)((float)n2 * 0.92f);
        this.progressBarWidth = n - 2 * this.progressBarX;
        this.progressBarHeight = 5;
        this.moduleCount = new HashMap<Integer, Integer>();
        this.loadedCount = new HashMap<Integer, Integer>();
        this.loadResourceBundle();
        this.initGUI();
    }

    private void validateSplashScreen(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (n <= 0) {
            stringBuffer.append("First parameter must be larger than zero!\n");
        }
        if (n2 <= 0) {
            stringBuffer.append("Second parameter must be larger than zero!");
        }
        if (stringBuffer.length() > 0) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
    }

    private void initGUI() {
        this.splashWindow = new JFrame("iMindMap");
        this.splashWindow.setIconImage(this.getFrameIcon());
        this.splashWindow.setUndecorated(true);
        this.splashWindow.setDefaultCloseOperation(2);
        this.splashWindow.setSize(this.splashWidth, this.splashHeight);
        this.splashWindow.setLocationRelativeTo(null);
        this.splash = new SplashPanel();
        this.splashWindow.setContentPane(this.splash);
    }

    public static boolean isRetina() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        try {
            Field field = graphicsDevice.getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                Object object = field.get(graphicsDevice);
                if (object instanceof Integer && (Integer)object == 2) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Image getFrameIcon() {
        return this.getImageFromPath(SPLASH_FRAME_ICON_PATH);
    }

    private Image getImageFromPath(String string) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        if (inputStream != null) {
            try {
                return ImageIO.read(inputStream);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Could not read image from " + string, iOException);
            }
        } else {
            LOGGER.log(Level.WARNING, "Could not find image at " + string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVisible(boolean bl) {
        LOGGER.log(Level.FINEST, "Set visible called with " + bl);
        SplashScreen splashScreen = this;
        synchronized (splashScreen) {
            this.setVisible = bl;
            if (this.startRequested) {
                this.doSetVisible(this.setVisible);
            }
        }
    }

    private void doSetVisible(final boolean bl) {
        if (bl) {
            this.splashWindow.setIgnoreRepaint(false);
        } else {
            this.progressBarShowing = false;
            this.splashWindow.setIgnoreRepaint(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (bl) {
                    SplashScreen.this.splashWindow.setVisible(bl);
                    SplashScreen.this.splashWindow.requestFocus();
                } else {
                    SplashScreen.this.splashWindow.dispose();
                    SplashScreen.this.splash.release();
                }
            }
        });
    }

    public final void setPhaseCount(int n) {
        this.validatePhaseCount(n);
        this.phaseCount = n;
    }

    private void validatePhaseCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("phase cannot be negative");
        }
    }

    public final void setProgressBar(int n, int n2, int n3, int n4) {
        this.validateSetProgressBar(n, n2, n3, n4);
        if (this.progressBarShowing) {
            return;
        }
        this.progressBarX = n;
        this.progressBarY = n2;
        this.progressBarWidth = n3;
        this.progressBarHeight = n4;
        this.showProgressBar();
    }

    private void validateSetProgressBar(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (n < 0 || n2 < 0) {
            stringBuffer.append("Parameters x and y cant be less than zero!\n");
        }
        if (n3 <= 0 || n4 <= 0) {
            stringBuffer.append("Parameters widthIn and heightIn must be larger than zero!\n");
        }
        if (n * 2 + n3 > this.splashWidth) {
            stringBuffer.append(" Parameters x and/or widthIn too large, can't display progressbar entirely!\n");
        }
        if (n2 + n4 > this.splashHeight) {
            stringBuffer.append(" Parameters y and/or heightIn too large, can't display progressbar entirely!");
        }
        if (stringBuffer.length() > 0) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
    }

    private void showProgressBar() {
        this.progressBarShowing = true;
        this.splashWindow.setIgnoreRepaint(false);
        this.splash.repaint();
    }

    public final void setModuleCount(int n, int n2) {
        this.validateSetModuleCount(n, n2);
        this.moduleCount.put(n, n2);
        if (!this.progressBarShowing) {
            this.showProgressBar();
        }
    }

    private void validateSetModuleCount(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("phase cannot be negative");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("parameter totalModules must be larger than zero!");
        }
    }

    public final void setLoadedModuleCount(int n, int n2) {
        this.validateSetModuleLoadedCount(n, n2);
        this.setPreviousPhasesToComplete(n);
        this.loadedCount.put(n, n2);
        if (!this.progressBarShowing) {
            this.showProgressBar();
        }
        this.updateProgressBar();
    }

    private void setPreviousPhasesToComplete(int n) {
        if (n > 1) {
            for (int i = 1; n > i; ++i) {
                if (this.getLoadedModuleCount(i) >= this.getModuleCount(i)) continue;
                this.setLoadedModuleCount(i, this.getModuleCount(i));
            }
        }
    }

    private boolean isRepaintRequiredThisUpdate() {
        boolean bl = this.numberPaintCalls % 12 == 0;
        ++this.numberPaintCalls;
        return bl;
    }

    private void updateProgressBar() {
        int n = this.getModuleCount(1);
        if (n > 0) {
            double d = this.getLoadedModuleCount(1);
            double d2 = d / (double)n;
            this.progressWidth = (int)(d2 * (double)this.progressBarWidth);
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            if (this.isRepaintRequiredThisUpdate() || d2 == 1.0) {
                this.splash.repaint(this.progressBarX - 2, this.progressBarY - 2, this.progressWidth + 4, this.progressBarHeight + 4);
            }
        }
    }

    private void validateSetModuleLoadedCount(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("phase cannot be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Loaded modules count cant be less than zero");
        }
        if (n2 > this.getModuleCount(n)) {
            throw new IllegalArgumentException("Loaded modules count cant be more than the total count");
        }
    }

    public final int getModuleCount(int n) {
        int n2 = 0;
        if (n == 0 && this.phaseCount > 0) {
            for (int i = 0; i <= this.phaseCount; ++i) {
                Integer n3 = this.moduleCount.get(i);
                if (n3 == null) continue;
                n2 += n3.intValue();
            }
        } else {
            Integer n4 = this.moduleCount.get(n);
            if (n4 != null) {
                n2 = n4;
            }
        }
        return n2;
    }

    public final int getLoadedModuleCount() {
        int n = 0;
        if (this.phaseCount == 0) {
            n = this.getLoadedModuleCount(0);
        } else {
            for (int i = 1; i <= this.phaseCount; ++i) {
                Integer n2 = this.loadedCount.get(i);
                if (n2 == null) continue;
                n += n2.intValue();
            }
        }
        return n;
    }

    private int getLoadedModuleCount(int n) {
        int n2 = 0;
        Integer n3 = this.loadedCount.get(n);
        if (n3 != null) {
            n2 = n3;
        }
        return n2;
    }

    public final void incrementLoadedModuleCount(int n, int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("you cant use this to decrement");
        }
        int n3 = this.getLoadedModuleCount(n) + n2;
        this.setLoadedModuleCount(n, Math.min(n3, this.getModuleCount(n)));
    }

    public final void addNumberOfBundlesWhichActivateOnStart(int n) {
        this.numberBundlesActiveOnStart += n;
    }

    public final int getNumberOfBundlesWhichActivateOnStart() {
        return this.numberBundlesActiveOnStart;
    }

    private boolean isLaunchAfterUpdates() {
        String string = this.getOsgiCleanCacheFlagFilePath();
        if (string == null) {
            return false;
        }
        File file = new File(string);
        return file.exists();
    }

    private String getOsgiCleanCacheFlagFilePath() {
        return System.getProperty(PROP_CACHE_CLEAR_FLAG_PATH);
    }

    private void loadResourceBundle() {
        this.loadResourceBundle(Locale.getDefault(), false);
        if (this.resourceBundle == null) {
            this.loadResourceBundle(Locale.UK, true);
        }
    }

    private void loadResourceBundle(Locale locale, boolean bl) {
        try {
            this.resourceBundle = ResourceBundle.getBundle("i18nproperties/SplashScreenMessages", locale, this.getClass().getClassLoader());
        }
        catch (Exception exception) {
            if (bl) {
                LOGGER.log(Level.WARNING, "Could not load resources for locale " + Locale.getDefault(), exception);
            }
            LOGGER.log(Level.WARNING, "Could not load resources for locale " + Locale.getDefault());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setStartRequested() {
        SplashScreen splashScreen = this;
        synchronized (splashScreen) {
            this.startRequested = true;
            this.doSetVisible(this.setVisible);
        }
    }

    static /* synthetic */ boolean access$300(SplashScreen splashScreen) {
        return splashScreen.isLaunchAfterUpdates();
    }

    private class SplashPanel
    extends JPanel {
        private static final long serialVersionUID = -7818205016568625959L;
        private transient boolean drawnLoadingText = false;
        private final transient boolean isAfterUpdates = SplashScreen.access$300(SplashScreen.this);
        private Logger LOGGER = Logger.getLogger(SplashPanel.class.getName());
        private transient Image splashImage;

        private SplashPanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Image getSplashImg() {
            if (this.splashImage == null) {
                String string = SplashScreen.SPLASH_IMAGE_PATH;
                try {
                    if (SplashScreen.isRetina()) {
                        string = string + SplashScreen.RETINA;
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    string = string + SplashScreen.PNG;
                }
                this.splashImage = SplashScreen.this.getImageFromPath(string);
            }
            return this.splashImage;
        }

        public void paint(Graphics graphics) {
            Image image = this.getSplashImg();
            if (image != null) {
                int n;
                int n2;
                int n3;
                int n4;
                float f = (float)image.getWidth(null) / (float)this.getWidth();
                float f2 = (float)image.getHeight(null) / (float)this.getHeight();
                Rectangle rectangle = graphics.getClipBounds();
                if (rectangle == null) {
                    n4 = 0;
                    n3 = 0;
                    n2 = this.getWidth();
                    n = this.getHeight();
                } else {
                    n4 = rectangle.x;
                    n3 = rectangle.y;
                    n2 = rectangle.x + rectangle.width;
                    n = rectangle.y + rectangle.height;
                }
                int n5 = (int)(f * (float)n4);
                int n6 = (int)(f2 * (float)n3);
                int n7 = (int)(f * (float)n2);
                int n8 = (int)(f2 * (float)n);
                if (SplashScreen.isRetina()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    graphics2D.drawImage(image, n4, n3, n2, n, n5, n6, n7, n8, null);
                } else {
                    graphics.drawImage(image, n4, n3, n2, n, n5, n6, n7, n8, null);
                }
            }
            if (SplashScreen.this.progressBarShowing) {
                Color color = graphics.getColor();
                graphics.setColor(PROGRESSBAR_OUTER_BORDER_COLOR);
                graphics.fillRect(SplashScreen.this.progressBarX, SplashScreen.this.progressBarY, SplashScreen.this.progressBarWidth, SplashScreen.this.progressBarHeight);
                graphics.setColor(PROGRESSBAR_COLOR);
                graphics.fillRect(SplashScreen.this.progressBarX, SplashScreen.this.progressBarY, SplashScreen.this.progressWidth, SplashScreen.this.progressBarHeight);
                this.drawSplashText(graphics);
                graphics.setColor(color);
            }
        }

        private void drawSplashText(Graphics graphics) {
            if (SplashScreen.this.resourceBundle != null) {
                SplashScreen.this.loadResourceBundle();
            }
            graphics.setColor(PROGRESSBAR_TEXT_COLOR);
            if (!this.drawnLoadingText && this.isAfterUpdates) {
                try {
                    graphics.drawString(SplashScreen.this.resourceBundle.getString("com.thinkbuzan.i18n.splash.updates"), SplashScreen.this.progressBarX, SplashScreen.this.progressBarY - 5);
                }
                catch (Exception exception) {
                    this.LOGGER.log(Level.WARNING, "Could not display text for updates", exception);
                }
                this.drawnLoadingText = true;
            } else if (!this.drawnLoadingText && Boolean.valueOf(System.getProperty("firstClearCacheRun")).booleanValue()) {
                try {
                    graphics.drawString(SplashScreen.this.resourceBundle.getString("com.thinkbuzan.i18n.splash.firstLaunch"), SplashScreen.this.progressBarX, SplashScreen.this.progressBarY - 5);
                }
                catch (Exception exception) {
                    this.LOGGER.log(Level.WARNING, "Could not display text for first launch", exception);
                }
                this.drawnLoadingText = true;
            }
        }

        public final void release() {
            this.splashImage = null;
        }
    }
}

