/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.splash.osgi;

import com.thinkbuzan.chaos.preload.IPreloadContext;
import com.thinkbuzan.chaos.preload.IStartRequestListener;
import com.thinkbuzan.chaos.preload.Preload;
import com.thinkbuzan.chaos.splash.SplashService;
import com.thinkbuzan.chaos.splash.impl.SplashScreen;
import java.awt.GraphicsEnvironment;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = Logger.getLogger(Activator.class.getName());
    private transient SplashScreen ss = null;

    public final void start(BundleContext bundleContext) {
        LOGGER.log(Level.FINE, "Starting splash screen bundle");
        if (Boolean.valueOf(System.getProperty("com.thinkbuzan.chaos.splash.show", "false")).booleanValue() && !GraphicsEnvironment.isHeadless()) {
            LOGGER.log(Level.FINE, "Splash screen is to be shown");
            int n = Integer.valueOf(System.getProperty("com.thinkbuzan.chaos.splash.width", "500"));
            int n2 = Integer.valueOf(System.getProperty("com.thinkbuzan.chaos.splash.height", "246"));
            try {
                this.ss = new SplashScreen(n, n2);
                bundleContext.registerService(SplashService.class.getName(), (Object)this.ss, null);
                this.addStartRequestListener(bundleContext);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Could not start splash screen", exception);
            }
        }
    }

    private void addStartRequestListener(BundleContext bundleContext) {
        Preload preload = this.getPreload(bundleContext);
        if (preload == null) {
            LOGGER.severe("Could not get Preload service");
            this.ss.setStartRequested();
        } else {
            preload.addStartRequestListener(new IStartRequestListener(){

                public void startRequested(IPreloadContext iPreloadContext) {
                    Activator.this.ss.setStartRequested();
                }
            });
        }
    }

    private Preload getPreload(BundleContext bundleContext) {
        ServiceReference serviceReference = bundleContext.getServiceReference(Preload.class.getName());
        if (serviceReference == null) {
            return null;
        }
        Preload preload = (Preload)bundleContext.getService(serviceReference);
        return preload;
    }

    public final void stop(BundleContext bundleContext) {
        if (this.ss != null) {
            this.ss.setVisible(false);
        }
    }
}

