/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.model.properties;

import com.thinkbuzan.gaia.model.properties.IProperty;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesRegistry {
    private static final List<IProperty> HANDLERS = new LinkedList<IProperty>();
    private static final PropertiesRegistry INSTANCE = new PropertiesRegistry();

    private PropertiesRegistry() {
    }

    public static PropertiesRegistry getInstance() {
        return INSTANCE;
    }

    public void registerPropertyHandler(IProperty propertyHandler) {
        if (propertyHandler == null) {
            throw new IllegalArgumentException("param property handler can not be null");
        }
        HANDLERS.add(propertyHandler);
    }

    public List<IProperty> getRegisteredHandlers() {
        return Collections.unmodifiableList(HANDLERS);
    }
}

