/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.phoenix.externalshare.ui.account;

import com.thinkbuzan.phoenix.externalshare.auxillery.TypeUtility;
import com.thinkbuzan.phoenix.externalshare.connector.SocialConnectorType;
import com.thinkbuzan.phoenix.externalshare.model.account.IAccount;
import com.thinkbuzan.phoenix.externalshare.ui.account.AccountArea;
import com.thinkbuzan.phoenix.externalshare.ui.account.AccountCellRenderer;
import com.thinkbuzan.phoenix.externalshare.ui.account.AccountListModel;
import com.thinkbuzan.phoenix.externalshare.ui.listener.SelectionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;

public class AccountList
extends JList {
    private static final long serialVersionUID = -4241323461837153626L;
    private final transient AccountListModel a = new AccountListModel();
    private final List<SelectionListener> b = new ArrayList<SelectionListener>();

    public AccountList() {
        this.setModel(this.a);
        this.setCellRenderer(new AccountCellRenderer(this.a));
        this.setVisibleRowCount(-1);
        this.setLayoutOrientation(2);
    }

    public final AccountListModel getModel() {
        return this.a;
    }

    public final void clearAccounts() {
        int n = AccountArea.g;
        for (IAccount iAccount : this.getModel().getAccounts()) {
            this.getModel().removeElement(iAccount);
            if (n == 0) continue;
        }
    }

    public final List<IAccount> getSelectedAccounts() {
        int n = AccountArea.g;
        ArrayList<IAccount> arrayList = new ArrayList<IAccount>();
        for (IAccount iAccount : this.getModel().getAccounts()) {
            if (iAccount.isSelected()) {
                arrayList.add(iAccount);
            }
            if (n == 0) continue;
        }
        return arrayList;
    }

    public final void updateAccounts(List<IAccount> list) {
        int n = AccountArea.g;
        this.a(list);
        this.clearAccounts();
        for (IAccount iAccount : list) {
            if (iAccount.getType() == SocialConnectorType.DROPBOX || iAccount.getType() == SocialConnectorType.GOOGLE_DRIVE || iAccount.getType() == SocialConnectorType.YOUTUBE && n == 0) continue;
            this.getModel().addElement(iAccount);
            if (n == 0) continue;
        }
        this.a();
    }

    private void a(List<IAccount> list) {
        int n = AccountArea.g;
        List<IAccount> list2 = this.getSelectedAccounts();
        for (IAccount iAccount : list) {
            for (IAccount iAccount2 : list2) {
                if (iAccount2.getToken().equals(iAccount.getToken())) {
                    iAccount.setSelected(true);
                }
                if (n == 0) continue;
            }
            if (n == 0) continue;
        }
    }

    public final void setSelectedType(String string) {
        int n = AccountArea.g;
        for (IAccount iAccount : this.getModel().getAccounts()) {
            SocialConnectorType socialConnectorType = TypeUtility.getTypeForKey(string);
            if (iAccount.getType().equals((Object)socialConnectorType)) {
                iAccount.setSelected(true);
            }
            if (n == 0) continue;
        }
        this.a();
    }

    @Override
    public void clearSelection() {
        int n = AccountArea.g;
        super.clearSelection();
        for (IAccount iAccount : this.getModel().getAccounts()) {
            iAccount.setSelected(false);
            if (n == 0) continue;
        }
    }

    public void selectAccount(IAccount iAccount, boolean bl) {
        iAccount.setSelected(bl);
        this.a();
    }

    public final void addSelectionListener(SelectionListener selectionListener) {
        this.b.add(selectionListener);
    }

    public void removeSelectionListeners() {
        this.b.clear();
    }

    private void a() {
        int n = AccountArea.g;
        for (SelectionListener selectionListener : this.b) {
            selectionListener.selectionChanged(this.getSelectedAccounts());
            if (n == 0) continue;
        }
    }
}

