/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service;

import com.thinkbuzan.gaia.printing.service.IPrintable;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;

public class ComponentPrintable
implements IPrintable {
    private final JComponent component;
    private int height;
    private final int width;
    private JTableHeader header;

    public ComponentPrintable(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("param component can not be null");
        }
        this.component = jComponent;
        this.height = this.component.getPreferredSize().height;
        this.width = this.component.getPreferredSize().width;
        if (this.component instanceof JTable) {
            this.header = ((JTable)this.component).getTableHeader();
            this.height += this.header.getPreferredSize().height;
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics2D) {
        Rectangle rectangle = this.component.getBounds();
        try {
            if (this.header != null) {
                this.header.setBounds(0, 0, this.header.getPreferredSize().width, this.header.getPreferredSize().height);
                this.header.print(graphics2D);
                graphics2D.setColor(((JTable)this.component).getGridColor());
                graphics2D.drawRect(0, 0, this.header.getPreferredSize().width - 1, this.header.getPreferredSize().height - 1);
                graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                graphics2D.translate(0, this.header.getPreferredSize().height);
            }
            this.component.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.component.print(graphics2D);
        }
        finally {
            this.component.setBounds(rectangle);
        }
    }
}

