/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service;

import com.thinkbuzan.gaia.printing.service.IPrintable;
import com.thinkbuzan.gaia.printing.service.PageListener;
import com.thinkbuzan.gaia.printing.service.PrintableObject;
import com.thinkbuzan.gaia.printing.service.WaterMark;
import com.thinkbuzan.gaia.printing.service.impl.HeaderFooterDrawer;
import com.thinkbuzan.gaia.printing.service.model.HeaderFooter;
import com.thinkbuzan.gaia.printing.service.model.PageRange;
import com.thinkbuzan.gaia.printing.service.model.ScaleMode;
import com.thinkbuzan.gaia.printing.service.printable.AbstractPainterPrintable;
import com.thinkbuzan.gaia.printing.service.printable.GraphPrintable;
import com.thinkbuzan.gaia.printing.service.utils.Validator;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPrintable
implements PrintableObject {
    private final transient List<PageListener> pageListeners = new ArrayList<PageListener>();
    private final transient IPrintable printableObject;
    protected transient PageFormat pageFormat;
    private transient HeaderFooterDrawer header;
    private transient HeaderFooterDrawer footer;
    private transient WaterMark waterMark;
    private transient ScaleMode scaleMode;

    public GenericPrintable(IPrintable iPrintable) {
        Validator.nullObjectParamenter(iPrintable, "GenericPrintable, param object can not be null");
        this.printableObject = iPrintable;
        this.pageFormat = new PageFormat();
        this.scaleMode = new ScaleMode(ScaleMode.ScaleType.SCALE_TO_PAGES, 1, 1);
    }

    @Override
    public final void setPageFormat(PageFormat pageFormat) {
        if (pageFormat == null) {
            throw new IllegalArgumentException("param pageFormat can not be null");
        }
        this.pageFormat = pageFormat;
    }

    @Override
    public int getNumberOfPages() {
        if (this.scaleMode.getScaleType() == ScaleMode.ScaleType.NO_SCALING) {
            int n = (int)this.getRealWidth(this.pageFormat);
            int n2 = (int)this.getRealHeight(this.pageFormat);
            int n3 = this.printableObject.getWidth();
            int n4 = this.printableObject.getHeight();
            int n5 = n3 / n + 1;
            int n6 = n4 / n2 + 1;
            return n5 * n6;
        }
        if (this.scaleMode.getScaleType() == ScaleMode.ScaleType.SCALE_TO_PAGES) {
            return this.scaleMode.getRows() * this.scaleMode.getColumns();
        }
        if (this.scaleMode.getScaleType() == ScaleMode.ScaleType.SCALE_TO_HALF) {
            return 1;
        }
        return 0;
    }

    @Override
    public final void addPageListener(PageListener pageListener) {
        if (pageListener != null) {
            this.pageListeners.add(pageListener);
        }
    }

    @Override
    public final void removePageListener(PageListener pageListener) {
        if (pageListener != null) {
            this.pageListeners.remove(pageListener);
        }
    }

    protected final List<PageListener> getPageListeners() {
        return this.pageListeners;
    }

    @Override
    public final HeaderFooter getHeader() {
        if (this.header != null) {
            return this.header.getHeaderFooter();
        }
        return null;
    }

    @Override
    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter != null ? new HeaderFooterDrawer(headerFooter) : null;
    }

    @Override
    public final HeaderFooter getFooter() {
        if (this.footer != null) {
            return this.footer.getHeaderFooter();
        }
        return null;
    }

    @Override
    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter != null ? new HeaderFooterDrawer(headerFooter) : null;
    }

    @Override
    public final PageFormat getPageFormat(int n) {
        return this.pageFormat;
    }

    @Override
    public final WaterMark getWaterMarkTool() {
        return this.waterMark;
    }

    @Override
    public final void setWaterMarkTool(WaterMark waterMark) {
        this.waterMark = waterMark;
    }

    @Override
    public final ScaleMode getScaleMode() {
        return this.scaleMode;
    }

    @Override
    public final void setScaleMode(ScaleMode scaleMode) {
        if (scaleMode == null) {
            throw new IllegalArgumentException("param scale Mode can not be null");
        }
        if (this.scaleMode != scaleMode) {
            this.scaleMode = scaleMode;
            this.firePagesChanged();
        }
    }

    protected final void firePagesChanged() {
        for (PageListener pageListener : this.getPageListeners()) {
            pageListener.numberOfPagesChanged();
        }
    }

    @Override
    public final Printable getPrintable(final int n) {
        return new Printable(){

            public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
                return GenericPrintable.this.print(graphics, pageFormat, n);
            }
        };
    }

    public final IPrintable getPrintable() {
        return this.printableObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void paintPrintable(Graphics graphics, PageFormat pageFormat, int n, IPrintable iPrintable, ScaleMode scaleMode) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            double d;
            double d2;
            int n2;
            int n3 = (int)pageFormat.getImageableX();
            int n4 = (int)pageFormat.getImageableY();
            AffineTransform affineTransform = graphics2D.getTransform();
            Shape shape = graphics2D.getClip();
            double d3 = pageFormat.getImageableWidth();
            if (this.header != null) {
                this.header.draw(graphics2D, n3, n4, (int)d3, n + 1);
                n4 = (int)((double)n4 + this.header.getHeight(d3));
            }
            if (this.footer != null) {
                n2 = (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight() - this.footer.getHeight(d3));
                this.footer.draw(graphics2D, n3, n2, (int)d3, n + 1);
            }
            n2 = (int)this.getRealWidth(pageFormat);
            int n5 = (int)this.getRealHeight(pageFormat);
            int n6 = iPrintable.getWidth();
            int n7 = iPrintable.getHeight();
            double d4 = 1.0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            if (scaleMode.getScaleType() == ScaleMode.ScaleType.SCALE_TO_PAGES) {
                n8 = scaleMode.getRows();
                n9 = scaleMode.getColumns();
                d2 = n2 * n9;
                d = n5 * n8;
                d4 = Math.min(d2 / (double)n6, d / (double)n7);
                n10 = n / n9;
                n11 = n % n9;
                n6 = (int)((double)n6 * d4);
                n7 = (int)((double)n7 * d4);
            } else if (scaleMode.getScaleType() == ScaleMode.ScaleType.SCALE_TO_HALF) {
                n8 = 1;
                n9 = 1;
                n10 = 0;
                n11 = 0;
                d2 = (double)n2 * 0.5;
                d = n5;
                d4 = Math.min(d2 / (double)n6, d / (double)n7);
                d2 = n2;
                d = (double)n5 * 0.5;
                double d5 = Math.min(d2 / (double)n6, d / (double)n7);
                if (d5 < d4) {
                    d2 = (double)n2 * 0.5;
                    d = n5;
                }
                d4 = Math.max(d4, Math.min(d2 / (double)n6, d / (double)n7));
                n6 = (int)((double)n6 * d4);
                n7 = (int)((double)n7 * d4);
            } else {
                n9 = n6 / n2 + 1;
                n8 = n7 / n5 + 1;
                n10 = n / n9;
                n11 = n % n9;
                d2 = n2 * n9;
                d = n5 * n8;
            }
            boolean bl = iPrintable instanceof AbstractPainterPrintable && ((AbstractPainterPrintable)iPrintable).isFillPage();
            double d6 = (d2 - (double)n6) / 2.0;
            double d7 = (d - (double)n7) / 2.0;
            int n12 = n11 * n2;
            int n13 = n10 * n5;
            graphics2D.translate(n3, n4);
            if (bl && n8 <= 1 && n9 <= 1) {
                graphics2D.scale(d4, d4);
                ((AbstractPainterPrintable)iPrintable).paint(graphics2D, new Rectangle(0, 0, (int)(d2 / d4), (int)(d / d4)));
            } else {
                graphics2D.translate(d6, d7);
                graphics2D.translate(-n12, -n13);
                graphics2D.scale(d4, d4);
                iPrintable.paint(graphics2D);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            this.printWaterMark(graphics2D, pageFormat);
        }
        finally {
            graphics2D.dispose();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= this.getNumberOfPages()) {
            return 1;
        }
        this.paintPrintable(graphics, pageFormat, n, this.printableObject, this.scaleMode);
        return 0;
    }

    public final BufferedImage getPagePreview(int n) {
        int n2 = (int)this.pageFormat.getWidth();
        int n3 = (int)this.pageFormat.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            this.print(graphics2D, this.pageFormat, n);
        }
        catch (PrinterException printerException) {
            throw new IllegalArgumentException(printerException);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public final BufferedImage getPagePreview(int n, int n2, int n3) {
        double d = this.pageFormat.getWidth();
        double d2 = this.pageFormat.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.scale((double)n2 / d, (double)n3 / d2);
            this.print(graphics2D, this.pageFormat, n);
        }
        catch (PrinterException printerException) {
            throw new IllegalArgumentException(printerException);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private double getRealWidth(PageFormat pageFormat) {
        return pageFormat.getImageableWidth();
    }

    private double getRealHeight(PageFormat pageFormat) {
        double d;
        double d2 = d = pageFormat.getImageableHeight();
        if (this.header != null) {
            d2 -= this.header.getHeight(pageFormat.getImageableWidth());
        }
        if (this.footer != null) {
            d2 -= this.footer.getHeight(pageFormat.getImageableWidth());
        }
        return d2;
    }

    private void printWaterMark(Graphics2D graphics2D, PageFormat pageFormat) {
        if (this.waterMark == null) {
            return;
        }
        int n = (int)this.getRealWidth(this.pageFormat);
        int n2 = (int)this.getRealHeight(this.pageFormat);
        Rectangle2D.Double double_ = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), n, n2);
        this.waterMark.paintWaterMark(graphics2D, double_);
    }

    @Override
    public final PageRange getPageRange() {
        return null;
    }

    @Override
    public final void setPageRange(PageRange pageRange) {
    }

    public final void setBackgroundPainted(boolean bl) {
        if (this.printableObject instanceof GraphPrintable) {
            ((GraphPrintable)this.printableObject).setBackgroundPainted(bl);
        }
    }

    public final boolean isBackgroundPainted() {
        if (this.printableObject instanceof GraphPrintable) {
            return ((GraphPrintable)this.printableObject).isBackgroundPainted();
        }
        return true;
    }

    public final void setFillPage(boolean bl) {
        if (this.printableObject instanceof GraphPrintable) {
            ((GraphPrintable)this.printableObject).setFillPage(bl);
        }
    }
}

