/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service;

import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.listeners.ModelListener;
import com.thinkbuzan.gaia.printing.service.GenericPrintable;
import com.thinkbuzan.gaia.printing.service.PageListener;
import com.thinkbuzan.gaia.printing.service.WaterMark;
import com.thinkbuzan.gaia.printing.service.model.HeaderFooter;
import com.thinkbuzan.gaia.printing.service.model.ScaleMode;
import com.thinkbuzan.gaia.printing.service.osgi.Activator;
import com.thinkbuzan.gaia.printing.service.printable.FloatingIdeaPrintable;
import com.thinkbuzan.gaia.printing.service.printable.GraphPrintable;
import com.thinkbuzan.gaia.printing.service.printable.MainBranchPrintable;
import com.thinkbuzan.gaia.printing.service.printable.RegionPrintable;
import com.thinkbuzan.gaia.printing.service.printable.SelectionPrintable;
import com.thinkbuzan.gaia.printing.service.resource.ResourceManager;
import com.thinkbuzan.gaia.printing.service.utils.Validator;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MindMapPrintable
extends GenericPrintable {
    private final transient IEditorComponent editor;
    private final transient List<FloatingIdeaPrintable> floatingIdeaPrintables = new ArrayList<FloatingIdeaPrintable>();
    private final transient List<MainBranchPrintable> mainBranchPrintables = new ArrayList<MainBranchPrintable>();
    private final transient List<SelectionPrintable> selectionPrintables = new ArrayList<SelectionPrintable>();
    private final transient List<RegionPrintable> regionPrintables = new ArrayList<RegionPrintable>();
    private transient Rectangle2D printRegion;
    private transient PrintRange range;
    private final transient ScaleMode scale1page = new ScaleMode(ScaleMode.ScaleType.SCALE_TO_PAGES, 1, 1);

    public MindMapPrintable(IEditorComponent iEditorComponent) {
        super(new GraphPrintable(iEditorComponent));
        Validator.nullObjectParamenter(iEditorComponent, "MindMapPrintable, param editor can not be null");
        this.editor = iEditorComponent;
        this.pageFormat.setOrientation(0);
        this.range = PrintRange.MAP;
        this.editor.addModelListener(new ModelListener(){

            public void cellLabelChanged(Object[] objectArray) {
                MindMapPrintable.this.clearPrintables();
            }

            public void cellsAdded(Object[] objectArray) {
                MindMapPrintable.this.clearPrintables();
            }

            public void cellsRemoved(Object[] objectArray) {
                MindMapPrintable.this.clearPrintables();
            }

            public void modelChanged() {
                MindMapPrintable.this.clearPrintables();
            }
        });
        this.needWaterMark();
        super.setHeader(new HeaderFooter());
        this.getHeader().setColor(iEditorComponent.getMapMetaData().getHeaderColour());
        this.getHeader().setTextLeft(iEditorComponent.getMapMetaData().getHeaderTitleLeft());
        this.getHeader().setTextCenter(iEditorComponent.getMapMetaData().getHeaderTitleCenter());
        this.getHeader().setTextRight(iEditorComponent.getMapMetaData().getHeaderTitleRight());
        Font font = new Font(iEditorComponent.getMapMetaData().getHeaderFontName(), iEditorComponent.getMapMetaData().getHeaderFontStyle(), iEditorComponent.getMapMetaData().getHeaderFontSize());
        this.getHeader().setFont(font);
        super.setFooter(new HeaderFooter());
        this.getFooter().setColor(iEditorComponent.getMapMetaData().getFooterColour());
        this.getFooter().setTextLeft(iEditorComponent.getMapMetaData().getFooterTitleLeft());
        this.getFooter().setTextCenter(iEditorComponent.getMapMetaData().getFooterTitleCenter());
        this.getFooter().setTextRight(iEditorComponent.getMapMetaData().getFooterTitleRight());
        Font font2 = new Font(iEditorComponent.getMapMetaData().getFooterFontName(), iEditorComponent.getMapMetaData().getFooterFontStyle(), iEditorComponent.getMapMetaData().getFooterFontSize());
        this.getFooter().setFont(font2);
    }

    public final void setPrintRange(PrintRange printRange) {
        this.range = printRange;
    }

    public final PrintRange getPrintRange() {
        return this.range;
    }

    public final int getNumberOfPages() {
        switch (this.range) {
            case MAP: {
                return super.getNumberOfPages();
            }
            case FLOATING_IDEAS: {
                if (this.floatingIdeaPrintables.isEmpty()) {
                    this.populateFloatingIdeaPrintables();
                }
                return this.floatingIdeaPrintables.size();
            }
            case MAIN_BRANCHES: {
                if (this.mainBranchPrintables.isEmpty()) {
                    this.populateMainBranchPrintables();
                }
                return this.mainBranchPrintables.size();
            }
            case SELECTION: {
                if (this.regionPrintables.isEmpty()) {
                    this.populateRegionPrintables();
                }
                return this.regionPrintables.size();
            }
            case MAP_SELECTION: {
                if (this.selectionPrintables.isEmpty()) {
                    this.populateSelectionPrintables();
                }
                return this.selectionPrintables.size();
            }
        }
        throw new IllegalArgumentException("unknown range " + (Object)((Object)this.range));
    }

    public final int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.print(graphics, pageFormat, n, true);
    }

    public final int print(Graphics graphics, PageFormat pageFormat, int n, boolean bl) throws PrinterException {
        int n2 = 0;
        if (this.range == PrintRange.MAP) {
            n2 = super.print(graphics, pageFormat, n);
        } else if (this.range == PrintRange.FLOATING_IDEAS) {
            if (this.floatingIdeaPrintables.isEmpty()) {
                this.populateFloatingIdeaPrintables();
            }
            if (n >= this.floatingIdeaPrintables.size()) {
                n2 = 1;
            }
            this.paintPrintable(graphics, pageFormat, 0, this.floatingIdeaPrintables.get(n), this.scale1page);
        } else if (this.range == PrintRange.MAIN_BRANCHES) {
            if (this.mainBranchPrintables.isEmpty()) {
                this.populateMainBranchPrintables();
            }
            if (n >= this.mainBranchPrintables.size()) {
                n2 = 1;
            }
            this.paintPrintable(graphics, pageFormat, 0, this.mainBranchPrintables.get(n), this.scale1page);
        } else if (this.range == PrintRange.SELECTION) {
            if (this.regionPrintables.isEmpty()) {
                this.populateRegionPrintables();
            }
            if (n >= this.regionPrintables.size()) {
                n2 = 1;
            }
            if (bl) {
                this.regionPrintables.get(n).setRegionEnabled(true);
                this.paintPrintable(graphics, pageFormat, 0, this.regionPrintables.get(n), this.scale1page);
                this.regionPrintables.get(n).setRegionEnabled(false);
            } else {
                this.paintPrintable(graphics, pageFormat, 0, this.regionPrintables.get(n), this.scale1page);
            }
        } else if (this.range == PrintRange.MAP_SELECTION) {
            if (this.selectionPrintables.isEmpty()) {
                this.populateSelectionPrintables();
            }
            if (n >= this.selectionPrintables.size()) {
                n2 = 1;
            }
            this.paintPrintable(graphics, pageFormat, 0, this.selectionPrintables.get(n), this.scale1page);
        } else {
            throw new IllegalArgumentException("unknown range " + (Object)((Object)this.range));
        }
        return n2;
    }

    public final void populateFloatingIdeaPrintables() {
        for (mmFloatingIdeaCell mmFloatingIdeaCell2 : this.editor.getFloatingIdeas()) {
            this.floatingIdeaPrintables.add(new FloatingIdeaPrintable(this.editor, mmFloatingIdeaCell2));
        }
    }

    private void populateMainBranchPrintables() {
        for (mmFloatingIdeaCell mmFloatingIdeaCell2 : this.editor.getFloatingIdeas()) {
            for (mmIStructureCell mmIStructureCell2 : mmFloatingIdeaCell2.getChildStructures()) {
                this.mainBranchPrintables.add(new MainBranchPrintable(this.editor, mmIStructureCell2));
            }
        }
    }

    private void populateSelectionPrintables() {
        this.selectionPrintables.add(new SelectionPrintable(this.editor, this.editor.getAllSelectionCells()));
    }

    private void populateRegionPrintables() {
        this.regionPrintables.add(new RegionPrintable(this.editor, this.printRegion));
    }

    private void clearPrintables() {
        this.floatingIdeaPrintables.clear();
        this.mainBranchPrintables.clear();
        this.selectionPrintables.clear();
        this.regionPrintables.clear();
        for (PageListener pageListener : this.getPageListeners()) {
            pageListener.numberOfPagesChanged();
        }
    }

    private void needWaterMark() {
        if (Activator.isLicenseTypeBasic() || Activator.isLicenseTypeTrial()) {
            WaterMark waterMark = new WaterMark(){

                public void paintWaterMark(Graphics2D graphics2D, Rectangle2D rectangle2D) {
                    BufferedImage bufferedImage = null;
                    try {
                        bufferedImage = ResourceManager.getWaterMarkImage();
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass()).warn((Object)"Issue when exporting: log and continue", (Throwable)exception);
                    }
                    if (bufferedImage != null) {
                        graphics2D.drawImage(bufferedImage, (int)(rectangle2D.getMaxX() - (double)((Image)bufferedImage).getWidth(null) / 2.0), (int)(rectangle2D.getMaxY() - (double)((Image)bufferedImage).getHeight(null) / 2.0), (int)((double)((Image)bufferedImage).getWidth(null) / 2.0), (int)((double)((Image)bufferedImage).getHeight(null) / 2.0), null);
                    }
                }
            };
            this.setWaterMarkTool(waterMark);
        }
    }

    public final void setRegion(Rectangle2D rectangle2D) {
        this.printRegion = rectangle2D;
        if (this.regionPrintables.isEmpty()) {
            this.populateRegionPrintables();
        }
        this.regionPrintables.get(0).setBounds(rectangle2D);
    }

    public final Rectangle getPaintBounds() {
        if (this.regionPrintables.isEmpty()) {
            this.populateRegionPrintables();
        }
        return this.regionPrintables.get(0).getPainterBounds();
    }

    public final void setHeader(HeaderFooter headerFooter) {
        super.setHeader(headerFooter);
        if (this.editor != null && headerFooter != null) {
            this.editor.getMapMetaData().setHeaderColour(headerFooter.getColor());
            this.editor.getMapMetaData().setHeaderTitleLeft(headerFooter.getTextLeft(0));
            this.editor.getMapMetaData().setHeaderTitleCenter(headerFooter.getTextCenter(0));
            this.editor.getMapMetaData().setHeaderTitleRight(headerFooter.getTextRight(0));
            this.editor.getMapMetaData().setHeaderFontName(headerFooter.getFont().getName());
            this.editor.getMapMetaData().setHeaderFontSize(headerFooter.getFont().getSize());
            this.editor.getMapMetaData().setHeaderFontStyle(headerFooter.getFont().getStyle());
            this.editor.setModified(true);
        }
    }

    public final void setFooter(HeaderFooter headerFooter) {
        super.setFooter(headerFooter);
        if (this.editor != null && headerFooter != null) {
            this.editor.getMapMetaData().setFooterColour(headerFooter.getColor());
            this.editor.getMapMetaData().setFooterTitleLeft(headerFooter.getTextLeft(0));
            this.editor.getMapMetaData().setFooterTitleCenter(headerFooter.getTextCenter(0));
            this.editor.getMapMetaData().setFooterTitleRight(headerFooter.getTextRight(0));
            this.editor.getMapMetaData().setFooterFontName(headerFooter.getFont().getName());
            this.editor.getMapMetaData().setFooterFontSize(headerFooter.getFont().getSize());
            this.editor.getMapMetaData().setFooterFontStyle(headerFooter.getFont().getStyle());
            this.editor.setModified(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrintRange {
        MAP,
        FLOATING_IDEAS,
        MAIN_BRANCHES,
        SELECTION,
        MAP_SELECTION;

    }
}

