/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service;

import com.thinkbuzan.gaia.printing.service.GenericPrintable;
import com.thinkbuzan.gaia.printing.service.PageListener;
import com.thinkbuzan.gaia.printing.service.PageableObject;
import com.thinkbuzan.gaia.printing.service.model.PageRange;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPagePrintable
implements PageableObject,
Printable,
PageListener {
    private static final Logger LOGGER = Logger.getLogger(MultiPagePrintable.class);
    private final transient Map<Integer, PrintablePointer> pageMap = new HashMap<Integer, PrintablePointer>();
    private final transient List<GenericPrintable> printables;
    private final transient List<PageListener> pageListeners = new ArrayList<PageListener>();
    private transient PageRange pageRange;

    public MultiPagePrintable() {
        this.printables = new ArrayList<GenericPrintable>();
    }

    @Override
    public final PageRange getPageRange() {
        return this.pageRange;
    }

    @Override
    public final void setPageRange(PageRange pageRange) {
        this.pageRange = pageRange;
        this.populatePageMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, PrintablePointer> getPageMap() {
        Map<Integer, PrintablePointer> map = this.pageMap;
        synchronized (map) {
            if (this.pageMap.size() == 0) {
                this.populatePageMap();
            }
        }
        return this.pageMap;
    }

    private boolean shouldUseOneToOneMapping() {
        boolean bl = this.pageRange == null || PageRange.PageRangeType.ALL.equals((Object)this.pageRange.getPageRangeType()) || PageRange.PageRangeType.CURRENT.equals((Object)this.pageRange.getPageRangeType()) || this.pageRange.getPagesToPrint() == null || this.pageRange.getPagesToPrint().isEmpty();
        return bl;
    }

    private void populatePageMap() {
        this.pageMap.clear();
        if (this.shouldUseOneToOneMapping()) {
            this.populatePageMapOneToOne();
        } else {
            int n = 0;
            for (int n2 : this.pageRange.getPagesToPrint()) {
                PrintablePointer printablePointer = this.getPointerToPage(n2);
                if (printablePointer == null) {
                    LOGGER.debug((Object)("Could not get pointer for page number " + n2));
                    continue;
                }
                this.pageMap.put(n, printablePointer);
                ++n;
            }
            if (this.pageMap.size() == 0) {
                this.populatePageMapOneToOne();
            }
        }
    }

    private void populatePageMapOneToOne() {
        int n = 0;
        for (GenericPrintable genericPrintable : this.printables) {
            for (int i = 0; i < genericPrintable.getNumberOfPages(); ++i) {
                this.pageMap.put(n, new PrintablePointer(genericPrintable, i));
                ++n;
            }
        }
    }

    private PrintablePointer getPointerToPage(int n) {
        PrintablePointer printablePointer = null;
        int n2 = 0;
        for (GenericPrintable genericPrintable : this.printables) {
            if (n >= n2 && n < n2 + genericPrintable.getNumberOfPages()) {
                printablePointer = new PrintablePointer(genericPrintable, n - n2);
                break;
            }
            n2 += genericPrintable.getNumberOfPages();
        }
        return printablePointer;
    }

    @Override
    public final int getNumberOfPages() {
        return this.getPageMap().keySet().size();
    }

    @Override
    public final void addPageListener(PageListener pageListener) {
        if (pageListener != null) {
            this.pageListeners.add(pageListener);
        }
    }

    @Override
    public final void removePageListener(PageListener pageListener) {
        if (pageListener != null) {
            this.pageListeners.add(pageListener);
        }
    }

    public final void appendPrintable(GenericPrintable genericPrintable) {
        genericPrintable.addPageListener(this);
        this.printables.add(genericPrintable);
        this.populatePageMap();
    }

    public final Printable getPrintableAt(int n) {
        PrintablePointer printablePointer = this.getPageMap().get(n);
        if (printablePointer != null) {
            return printablePointer.getPrintable();
        }
        return null;
    }

    @Override
    public final PageFormat getPageFormat(int n) {
        PrintablePointer printablePointer = this.getPageMap().get(n);
        if (printablePointer != null) {
            return printablePointer.getPrintable().getPageFormat(printablePointer.getPageIndex());
        }
        throw new IllegalArgumentException("wrong page index " + n + ",  numberOfPages " + this.getNumberOfPages());
    }

    @Override
    public final Printable getPrintable(int n) {
        return this;
    }

    @Override
    public final int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        PrintablePointer printablePointer = this.getPageMap().get(n);
        if (printablePointer != null) {
            printablePointer.getPrintable().print(graphics, pageFormat, printablePointer.getPageIndex());
            return 0;
        }
        return 1;
    }

    @Override
    public final BufferedImage getPagePreview(int n, int n2, int n3) {
        PrintablePointer printablePointer = this.getPageMap().get(n);
        if (printablePointer != null) {
            printablePointer.getPrintable().getPagePreview(printablePointer.getPageIndex(), n2, n3);
        }
        throw new IllegalArgumentException("wrong page index " + n + ",  numberOfPages " + this.getNumberOfPages());
    }

    public final void clearPrintables() {
        for (GenericPrintable genericPrintable : this.printables) {
            genericPrintable.removePageListener(this);
        }
        this.printables.clear();
        this.pageMap.clear();
    }

    @Override
    public final void numberOfPagesChanged() {
        this.pageMap.clear();
        this.populatePageMap();
        for (PageListener pageListener : this.pageListeners) {
            pageListener.numberOfPagesChanged();
        }
    }

    public final Pageable getCurrentPagePageable(int n) {
        Pageable pageable;
        if (this.isCurrentPagePrintable()) {
            int n2 = 1;
            if (n > 0 && n <= this.getNumberOfPages()) {
                n2 = n - 1;
            } else {
                LOGGER.warn((Object)("Invalid CURRENT PageRange! currentPage = " + n + ", number of pages = " + this.getNumberOfPages()));
            }
            PrintablePointer printablePointer = this.getPointerToPage(n2);
            if (printablePointer == null) {
                LOGGER.warn((Object)("Invalid CURRENT PageRange! Could not get pointer for page number " + n2 + ", number of pages = " + this.getNumberOfPages()));
                pageable = this;
            } else {
                pageable = new CurrentPagePageable(printablePointer.getPageIndex(), printablePointer.getPrintable());
            }
        } else {
            pageable = this;
        }
        return pageable;
    }

    public final boolean isCurrentPagePrintable() {
        boolean bl = this.pageRange != null && PageRange.PageRangeType.CURRENT.equals((Object)this.pageRange.getPageRangeType());
        return bl;
    }

    private static class PrintablePointer {
        private final transient GenericPrintable printable;
        private final transient int pageIndex;

        public PrintablePointer(GenericPrintable genericPrintable, int n) {
            this.validateParams(genericPrintable, n);
            this.printable = genericPrintable;
            this.pageIndex = n;
        }

        public final GenericPrintable getPrintable() {
            return this.printable;
        }

        public final int getPageIndex() {
            return this.pageIndex;
        }

        private void validateParams(GenericPrintable genericPrintable, int n) {
            if (genericPrintable == null) {
                throw new IllegalArgumentException("Printable object cannot be null!");
            }
            int n2 = genericPrintable.getNumberOfPages();
            if (n < 0 || n >= n2) {
                throw new IllegalArgumentException("Page index is invalid! must be between 0 and " + (n2 - 1) + ", value = " + n);
            }
        }
    }

    private static class CurrentPagePageable
    implements Pageable {
        private final int pageIndex;
        private final Pageable pageable;

        public CurrentPagePageable(int n, Pageable pageable) {
            this.pageIndex = n;
            this.pageable = pageable;
        }

        public int getNumberOfPages() {
            return 1;
        }

        public PageFormat getPageFormat(int n) {
            PageFormat pageFormat = this.pageable.getPageFormat(this.pageIndex);
            return pageFormat;
        }

        public Printable getPrintable(int n) {
            Printable printable = this.pageable.getPrintable(this.pageIndex);
            return printable;
        }
    }
}

