/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service.impl;

import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.printing.service.GenericPrintable;
import com.thinkbuzan.gaia.printing.service.IPrintable;
import com.thinkbuzan.gaia.printing.service.MultiPagePrintable;
import com.thinkbuzan.gaia.printing.service.PrintableObject;
import com.thinkbuzan.gaia.printing.service.PrintingService;
import com.thinkbuzan.gaia.printing.service.model.Margins;
import com.thinkbuzan.gaia.printing.service.model.PrintServiceAttribute;
import com.thinkbuzan.gaia.printing.service.model.ScaleMode;
import com.thinkbuzan.gaia.printing.service.utils.Validator;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.SheetCollate;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintingServiceImpl
implements PrintingService {
    private static final transient Logger LOGGER = Logger.getLogger(PrintingServiceImpl.class);
    private static final int INCH = 72;
    private transient PrintServiceAttribute printServiceAttribute;
    private final transient I18n i18n;
    private final transient String statusBusy;
    private final transient String statusReady;
    private final transient String statusStopped;

    public PrintingServiceImpl(I18n i18n) {
        Validator.nullObjectParamenter(i18n, "You can't set i18n to null.");
        this.i18n = i18n;
        this.statusBusy = this.i18n.getLocalizedText("com.thinkbuzan.i18n.printingservice.busy");
        this.statusReady = this.i18n.getLocalizedText("com.thinkbuzan.i18n.printingservice.ready");
        this.statusStopped = this.i18n.getLocalizedText("com.thinkbuzan.i18n.printingservice.stopped");
    }

    public PrintingServiceImpl(PrintServiceAttribute printServiceAttribute, I18n i18n) {
        Validator.nullObjectParamenter(i18n, "You can't set i18n to null.");
        Validator.nullObjectParamenter(printServiceAttribute, "You can't set print service setting to null.");
        this.setPrintServiceAttribute(printServiceAttribute);
        this.i18n = i18n;
        this.statusBusy = this.i18n.getLocalizedText("com.thinkbuzan.i18n.printingservice.busy");
        this.statusReady = this.i18n.getLocalizedText("com.thinkbuzan.i18n.printingservice.ready");
        this.statusStopped = this.i18n.getLocalizedText("com.thinkbuzan.i18n.printingservice.stopped");
    }

    private PrintServiceAttribute getPrintServiceAttribute() {
        if (this.printServiceAttribute == null) {
            this.printServiceAttribute = new PrintServiceAttribute(this.getDefaultPrintService());
        }
        return this.printServiceAttribute;
    }

    @Override
    public final PrintServiceAttribute getPrintAttributes() {
        return this.getPrintServiceAttribute();
    }

    @Override
    public final void setPrintServiceAttribute(PrintServiceAttribute printServiceAttribute) {
        Validator.nullObjectParamenter(printServiceAttribute, "You can't set print service setting to null.");
        this.printServiceAttribute = printServiceAttribute;
    }

    @Override
    public final void print(IPrintable iPrintable) throws PrinterException {
        this.validatePrint(iPrintable);
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        if (printServiceArray.length == 0) {
            return;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PrintServiceAttribute printServiceAttribute = this.getPrintServiceAttribute();
        printerJob.setPrintService(printServiceAttribute.getPrintService());
        printerJob.setCopies(printServiceAttribute.getCopies());
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (printServiceAttribute.isCollate()) {
            hashPrintRequestAttributeSet.add(SheetCollate.COLLATED);
        } else {
            hashPrintRequestAttributeSet.add(SheetCollate.UNCOLLATED);
        }
        Printable printable = this.getPrintable(iPrintable);
        printerJob.setPrintable(printable, printServiceAttribute.createPageFormat(printServiceAttribute.getPrintService()));
        printerJob.print(hashPrintRequestAttributeSet);
    }

    private void validatePrint(IPrintable iPrintable) {
        if (null == iPrintable) {
            throw new IllegalArgumentException("printableObject can't be null.");
        }
        if (null == this.getPrintServiceAttribute().getPrintService()) {
            throw new IllegalArgumentException("No printer have been selected to print.");
        }
    }

    public final Printable getPrintable(IPrintable iPrintable) throws PrinterException {
        GenericPrintable genericPrintable = new GenericPrintable(iPrintable);
        genericPrintable.setScaleMode(new ScaleMode(ScaleMode.ScaleType.SCALE_TO_PAGES, 1, 1));
        return genericPrintable;
    }

    @Override
    public final PrintService[] getAllPrintServices() {
        return PrintServiceLookup.lookupPrintServices(null, null);
    }

    @Override
    public final PrintService getDefaultPrintService() {
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    @Override
    public final List<String> getAllPrintServicesNameList() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        if (printServiceArray == null) {
            return new LinkedList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PrintService printService : printServiceArray) {
            arrayList.add(printService.getName());
        }
        return arrayList;
    }

    @Override
    public final String getPrinterServiceStatus(PrintService printService) {
        this.validateGetPrinterStatus(printService);
        PrinterIsAcceptingJobs printerIsAcceptingJobs = printService.getAttribute(PrinterIsAcceptingJobs.class);
        int n = printerIsAcceptingJobs.getValue();
        if (PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS.getValue() == n) {
            return this.statusStopped;
        }
        QueuedJobCount queuedJobCount = printService.getAttribute(QueuedJobCount.class);
        int n2 = queuedJobCount.getValue();
        if (n2 > 0) {
            return this.statusBusy;
        }
        return this.statusReady;
    }

    private void validateGetPrinterStatus(PrintService printService) {
        if (null == printService || null == printService.getAttributes()) {
            throw new IllegalArgumentException("printService can't be null.");
        }
    }

    @Override
    public final PrintService getPrintService(String string) {
        PrintingServiceImpl.validateGetPrintService(string);
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        if (printServiceArray == null) {
            return null;
        }
        for (PrintService printService : printServiceArray) {
            if (!string.equals(printService.getName())) continue;
            return printService;
        }
        return null;
    }

    private static void validateGetPrintService(String string) {
        if (null == string) {
            throw new IllegalArgumentException("printerName can't be null.");
        }
    }

    @Override
    public final Vector<MediaSizeName> getPaperSizeItems() {
        PrintService printService = this.getPrintAttributes().getPrintService();
        return PrintingServiceImpl.getPaperSizeNames(printService);
    }

    @Override
    public final Vector<MediaTray> getPaperSourceItems() {
        PrintService printService = this.getPrintAttributes().getPrintService();
        return PrintingServiceImpl.getPaperSources(printService);
    }

    public static Vector<MediaSizeName> getPaperSizeNames(PrintService printService) {
        Media[] mediaArray;
        PrintingServiceImpl.validateGetPaperSizeNames(printService);
        try {
            mediaArray = (Media[])printService.getSupportedAttributeValues(Media.class, null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't get MediaSizeName List from this PrintService.", exception);
        }
        Vector<MediaSizeName> vector = new Vector<MediaSizeName>();
        for (Media media : mediaArray) {
            if (!(media instanceof MediaSizeName)) continue;
            if (MediaSize.getMediaSizeForName((MediaSizeName)media) == null) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn((Object)String.format("Excluding MediaSizeName(%s) because it doesn't have an assosiated MediaSize", media));
                continue;
            }
            vector.add((MediaSizeName)media);
        }
        return vector;
    }

    private static void validateGetPaperSizeNames(PrintService printService) {
        if (null == printService) {
            throw new IllegalArgumentException("PrintService can't be null.");
        }
    }

    public static Vector<MediaTray> getPaperSources(PrintService printService) {
        Media[] mediaArray;
        PrintingServiceImpl.validateGetPaperSources(printService);
        try {
            mediaArray = (Media[])printService.getSupportedAttributeValues(Media.class, null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't get MediaSizeName List from this PrintService.", exception);
        }
        Vector<MediaTray> vector = new Vector<MediaTray>();
        for (Media media : mediaArray) {
            if (!(media instanceof MediaTray)) continue;
            vector.add((MediaTray)media);
        }
        return vector;
    }

    private static void validateGetPaperSources(PrintService printService) {
        if (null == printService) {
            throw new IllegalArgumentException("PrintService can't be null.");
        }
    }

    @Override
    public final void print(PrintableObject printableObject, int n) throws PrinterException {
        this.print((Pageable)printableObject, n);
    }

    @Override
    public final void print(Pageable pageable, int n) throws PrinterException {
        Pageable pageable2 = n > 0 && pageable instanceof MultiPagePrintable && ((MultiPagePrintable)pageable).isCurrentPagePrintable() ? ((MultiPagePrintable)pageable).getCurrentPagePageable(n) : pageable;
        this.print(pageable2);
    }

    private void print(Pageable pageable) throws PrinterException {
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        if (printServiceArray.length == 0) {
            return;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PrintServiceAttribute printServiceAttribute = this.getPrintServiceAttribute();
        printerJob.setPrintService(printServiceAttribute.getPrintService());
        printerJob.setCopies(printServiceAttribute.getCopies());
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (printServiceAttribute.isCollate()) {
            hashPrintRequestAttributeSet.add(SheetCollate.COLLATED);
        } else {
            hashPrintRequestAttributeSet.add(SheetCollate.UNCOLLATED);
        }
        printerJob.setPageable(pageable);
        printerJob.print(hashPrintRequestAttributeSet);
    }

    public static PageFormat createFormat(MediaSizeName mediaSizeName, Margins margins, int n, PrintService printService) {
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        if (mediaSize == null) {
            throw new IllegalArgumentException(String.format("MediaSizeName(%s) has a null MediaSize", mediaSizeName));
        }
        return PrintingServiceImpl.createFormat(mediaSize, margins, n, printService);
    }

    public static PageFormat createFormat(MediaSize mediaSize, Margins margins, int n, PrintService printService) {
        Paper paper = new Paper();
        paper.setSize(72.0f * mediaSize.getX(25400), 72.0f * mediaSize.getY(25400));
        LOGGER.debug((Object)("Papersize - width: " + paper.getWidth() + ", height: " + paper.getHeight()));
        paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(n);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (n) {
            case 1: {
                d = paper.getImageableX() + (double)(72.0f * margins.getLeft());
                d2 = paper.getImageableY() + (double)(72.0f * margins.getTop());
                d3 = paper.getImageableWidth() - (double)(72.0f * margins.getLeft()) - (double)(72.0f * margins.getRight());
                d4 = paper.getImageableHeight() - (double)(72.0f * margins.getTop()) - (double)(72.0f * margins.getBottom());
                break;
            }
            case 0: {
                d = paper.getImageableX() + (double)(72.0f * margins.getTop());
                d2 = paper.getImageableY() + (double)(72.0f * margins.getRight());
                d3 = paper.getImageableWidth() - (double)(72.0f * margins.getTop()) - (double)(72.0f * margins.getBottom());
                d4 = paper.getImageableHeight() - (double)(72.0f * margins.getLeft()) - (double)(72.0f * margins.getRight());
                break;
            }
            case 2: {
                d = paper.getImageableX() + (double)(72.0f * margins.getBottom());
                d2 = paper.getImageableY() + (double)(72.0f * margins.getLeft());
                d3 = paper.getImageableWidth() - (double)(72.0f * margins.getTop()) - (double)(72.0f * margins.getBottom());
                d4 = paper.getImageableHeight() - (double)(72.0f * margins.getLeft()) - (double)(72.0f * margins.getRight());
                break;
            }
        }
        paper.setImageableArea(d, d2, d3, d4);
        LOGGER.debug((Object)("ImageableArea - x: " + paper.getImageableX() + ", y: " + paper.getImageableY() + ", width: " + paper.getImageableWidth() + ", height: " + paper.getImageableHeight()));
        pageFormat.setPaper(paper);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printService != null) {
            try {
                printerJob.setPrintService(printService);
            }
            catch (PrinterException printerException) {
                LOGGER.error((Object)("Couldn't set the print service to " + printService.getName()), (Throwable)printerException);
            }
        }
        return printerJob.validatePage(pageFormat);
    }
}

