/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.service.model;

import com.thinkbuzan.gaia.printing.service.osgi.I18nWrapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRange {
    private static final transient Logger LOGGER = Logger.getLogger(PageRange.class);
    private final transient PageRangeType type;
    private final transient List<Integer> pagesToPrint;

    public PageRange(PageRangeType pageRangeType, List<Integer> list) {
        this.validateParams(pageRangeType, list);
        this.type = pageRangeType;
        this.pagesToPrint = list;
    }

    public final PageRangeType getPageRangeType() {
        return this.type;
    }

    public final List<Integer> getPagesToPrint() {
        return this.pagesToPrint;
    }

    private void validateParams(PageRangeType pageRangeType, List<Integer> list) {
        if (pageRangeType == null) {
            throw new IllegalArgumentException("PageRangeType cannot be null!");
        }
        if (PageRangeType.CUSTOM.equals((Object)pageRangeType) && (list == null || list.isEmpty())) {
            throw new IllegalArgumentException("CUSTOM PageRangeType must have a non empty page list! page list = " + list);
        }
    }

    public static PageRange decodeCustomRange(String string) {
        Object object;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string != null && !string.trim().equals("")) {
            try {
                for (String string2 : object = string.split(",")) {
                    List<Integer> list = PageRange.decodePartition(string2.trim());
                    arrayList.addAll(list);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.warn((Object)("Could not parse full custom range string = " + string), (Throwable)illegalArgumentException);
            }
        }
        object = arrayList.isEmpty() ? new PageRange(PageRangeType.ALL, null) : new PageRange(PageRangeType.CUSTOM, arrayList);
        return object;
    }

    private static List<Integer> decodePartition(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string.contains("-")) {
            String[] stringArray = string.split("-", 2);
            if (stringArray.length == 2) {
                int n = PageRange.getZeroIndexShiftedInt(stringArray[0]);
                int n2 = PageRange.getZeroIndexShiftedInt(stringArray[1]);
                if (n2 >= n) {
                    int n3 = n;
                    do {
                        arrayList.add(n3);
                    } while (++n3 <= n2);
                } else {
                    int n4 = n;
                    do {
                        arrayList.add(n4);
                    } while (--n4 >= n2);
                }
            }
        } else {
            int n = PageRange.getZeroIndexShiftedInt(string);
            arrayList.add(n);
        }
        return arrayList;
    }

    private static int getZeroIndexShiftedInt(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid section in page range! invalid section = " + string);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Pages cannot be zero or negative! invalid page entered = " + string);
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageRangeType {
        ALL,
        CUSTOM,
        CURRENT;


        public final String toString() {
            String string;
            switch (this) {
                case CUSTOM: {
                    string = I18nWrapper.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.printCustomRange");
                    break;
                }
                case CURRENT: {
                    string = I18nWrapper.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.printCurrentPage");
                    break;
                }
                default: {
                    string = I18nWrapper.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.printAllPages");
                }
            }
            return string;
        }
    }
}

